/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.asm.ClassDependenciesVisitor;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.internal.hash.HashCode;
import org.objectweb.asm.ClassReader;

public class DefaultClassDependenciesAnalyzer
implements ClassDependenciesAnalyzer {
    private final StringInterner interner;

    public DefaultClassDependenciesAnalyzer(StringInterner interner) {
        this.interner = interner;
    }

    public ClassAnalysis getClassAnalysis(InputStream input) throws IOException {
        ClassReader reader = new ClassReader(ByteStreams.toByteArray((InputStream)input));
        String className = reader.getClassName().replace("/", ".");
        return ClassDependenciesVisitor.analyze(className, reader, this.interner);
    }

    @Override
    public ClassAnalysis getClassAnalysis(HashCode classFileHash, FileTreeElement classFile) {
        ClassAnalysis classAnalysis;
        block8: {
            InputStream input = classFile.open();
            try {
                classAnalysis = this.getClassAnalysis(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Problems loading class analysis for " + classFile.toString());
                }
            }
            input.close();
        }
        return classAnalysis;
    }
}

