/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.ScopeContainer;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

public abstract class Feature
extends FreeColSpecObject
implements Named {
    private FreeColObject source;
    private Turn firstTurn;
    private Turn lastTurn;
    private int duration = 0;
    private boolean temporary;
    private ScopeContainer scopeContainer;
    private static final String DURATION_TAG = "duration";
    private static final String FIRST_TURN_TAG = "firstTurn";
    private static final String LAST_TURN_TAG = "lastTurn";
    private static final String SOURCE_TAG = "source";
    private static final String TEMPORARY_TAG = "temporary";

    public Feature(Specification specification) {
        super(specification);
    }

    public final boolean hasTimeLimit() {
        return this.firstTurn != null || this.lastTurn != null;
    }

    public final Turn getFirstTurn() {
        return this.firstTurn;
    }

    public final void setFirstTurn(Turn newFirstTurn) {
        this.firstTurn = newFirstTurn;
    }

    public final Turn getLastTurn() {
        return this.lastTurn;
    }

    public final void setLastTurn(Turn newLastTurn) {
        this.lastTurn = newLastTurn;
    }

    public final FreeColObject getSource() {
        return this.source;
    }

    public final void setSource(FreeColObject newSource) {
        this.source = newSource;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final void setDuration(int newDuration) {
        this.duration = newDuration;
    }

    public final boolean isTemporary() {
        return this.temporary;
    }

    public final void setTemporary(boolean newTemporary) {
        this.temporary = newTemporary;
    }

    protected boolean appliesTo(Turn turn) {
        return turn == null || (this.firstTurn == null || turn.getNumber() >= this.firstTurn.getNumber()) && (this.lastTurn == null || turn.getNumber() <= this.lastTurn.getNumber());
    }

    protected boolean appliesTo(FreeColSpecObjectType objectType, Turn turn) {
        return this.appliesTo(turn) && this.appliesTo(objectType);
    }

    public boolean isOutOfDate(Turn turn) {
        return turn != null && this.lastTurn != null && turn.getNumber() > this.lastTurn.getNumber();
    }

    public boolean isIndependent() {
        return !(this.source instanceof BuildingType) && !(this.source instanceof FoundingFather) && !(this.source instanceof NationType) && !(this.source instanceof SettlementType);
    }

    @Override
    public String getNameKey() {
        return Messages.nameKey(this.getId());
    }

    public final boolean hasScope() {
        return !ScopeContainer.isScopeContainerEmpty(this.scopeContainer);
    }

    public final List<Scope> getScopeList() {
        return ScopeContainer.getScopeList(this.scopeContainer);
    }

    public final Stream<Scope> getScopes() {
        return ScopeContainer.getScopes(this.scopeContainer);
    }

    public final void copyScopes(Collection<Scope> scopes) {
        this.scopeContainer = ScopeContainer.setScopes(this.scopeContainer, scopes);
    }

    public final void addScope(Scope scope) {
        this.scopeContainer = ScopeContainer.addScope(this.scopeContainer, scope);
    }

    public boolean appliesTo(FreeColObject fco) {
        return ScopeContainer.scopeContainerAppliesTo(this.scopeContainer, fco);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Feature o = this.copyInCast(other, Feature.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.source = o.getSource();
        this.firstTurn = o.getFirstTurn();
        this.lastTurn = o.getLastTurn();
        this.duration = o.getDuration();
        this.temporary = o.isTemporary();
        this.copyScopes(o.getScopeList());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.getSource() != null) {
            xw.writeAttribute(SOURCE_TAG, this.getSource());
        }
        if (this.getFirstTurn() != null) {
            xw.writeAttribute(FIRST_TURN_TAG, this.getFirstTurn().getNumber());
        }
        if (this.getLastTurn() != null) {
            xw.writeAttribute(LAST_TURN_TAG, this.getLastTurn().getNumber());
        }
        if (this.duration != 0) {
            xw.writeAttribute(DURATION_TAG, this.duration);
        }
        if (this.temporary) {
            xw.writeAttribute(TEMPORARY_TAG, this.temporary);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Scope scope : this.getScopeList()) {
            scope.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        int lastTurn;
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        String str = xr.getAttribute(SOURCE_TAG, null);
        if (str == null) {
            this.setSource(null);
        } else if (spec != null) {
            this.setSource(spec.getType(str));
        }
        int firstTurn = xr.getAttribute(FIRST_TURN_TAG, Integer.MIN_VALUE);
        if (firstTurn != Integer.MIN_VALUE) {
            this.setFirstTurn(new Turn(firstTurn));
        }
        if ((lastTurn = xr.getAttribute(LAST_TURN_TAG, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            this.setLastTurn(new Turn(lastTurn));
        }
        this.duration = xr.getAttribute(DURATION_TAG, 0);
        this.temporary = xr.getAttribute(TEMPORARY_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        ScopeContainer.clearScopes(this.scopeContainer);
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if ("scope".equals(tag)) {
            this.addScope(new Scope(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Feature) {
            Feature other = (Feature)o;
            if (this.source != other.source || this.duration != other.duration || this.temporary != other.temporary) {
                return false;
            }
            if (this.firstTurn == null) {
                if (other.firstTurn != null) {
                    return false;
                }
            } else {
                if (other.firstTurn == null) {
                    return false;
                }
                if (this.firstTurn.getNumber() != other.firstTurn.getNumber()) {
                    return false;
                }
            }
            if (this.lastTurn == null) {
                if (other.lastTurn != null) {
                    return false;
                }
            } else {
                if (other.lastTurn == null) {
                    return false;
                }
                if (this.lastTurn.getNumber() != other.lastTurn.getNumber()) {
                    return false;
                }
            }
            return ScopeContainer.equalScopes(this.scopeContainer, other.scopeContainer) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash += 31 * hash + Utils.hashCode(this.source);
        hash += 31 * hash + (this.firstTurn == null ? 0 : this.firstTurn.getNumber());
        hash += 31 * hash + (this.lastTurn == null ? 0 : this.lastTurn.getNumber());
        hash += 31 * hash + this.duration;
        hash += 31 * (this.temporary ? 1 : 0);
        return hash += CollectionUtils.sum(this.getScopeList(), s -> Utils.hashCode(s));
    }
}

