/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssRotate
extends org.w3c.css.properties.css.CssRotate {
    public static final CssIdent[] allowedValues;

    public static final CssIdent getAllowedValue(CssIdent ident) {
        for (CssIdent id : allowedValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssRotate() {
        this.value = initial;
    }

    public CssRotate(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        int nbNumber = 0;
        boolean gotIdent = false;
        boolean gotAngle = false;
        this.setByUser();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    if (gotIdent || nbNumber == 3) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    ++nbNumber;
                    v.add(val);
                    break;
                }
                case 7: {
                    if (gotAngle || nbNumber == 1 || nbNumber == 2) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    gotAngle = true;
                    v.add(val);
                    break;
                }
                case 0: {
                    CssIdent id = val.getIdent();
                    if (none.equals(id) || CssIdent.isCssWide(id)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        v.add(val);
                        break;
                    }
                    if (!gotIdent && nbNumber == 0 && CssRotate.getAllowedValue(id) != null) {
                        v.add(val);
                        gotIdent = true;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (nbNumber > 0 && nbNumber != 3 || (gotIdent || nbNumber != 0) && !gotAngle) {
            throw new InvalidParamException("value", v.toString(), this.getPropertyName(), ac);
        }
        this.value = v.size() == 1 ? (CssValue)v.get(0) : new CssValueList(v);
    }

    public CssRotate(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _allowedValues = new String[]{"x", "y", "z"};
        allowedValues = new CssIdent[_allowedValues.length];
        for (int i = 0; i < allowedValues.length; ++i) {
            CssRotate.allowedValues[i] = CssIdent.getIdent(_allowedValues[i]);
        }
    }
}

