/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml.test;

import nu.validator.xml.BaseUriTracker;

public class BaseUriTrackerTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        BaseUriTrackerTest.testValidUrlResolution();
        BaseUriTrackerTest.testMalformedUrlsReturnNull();
        BaseUriTrackerTest.testNullBaseUrl();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testValidUrlResolution() {
        BaseUriTracker tracker = new BaseUriTracker("https://example.com/path/page.html", null);
        String result = tracker.toAbsoluteUriWithCurrentBase("image.png");
        BaseUriTrackerTest.assertEquals("Valid relative URL resolves correctly", "https://example.com/path/image.png", result);
        result = tracker.toAbsoluteUriWithCurrentBase("/absolute/path.png");
        BaseUriTrackerTest.assertEquals("Absolute path resolves correctly", "https://example.com/absolute/path.png", result);
        result = tracker.toAbsoluteUriWithCurrentBase("https://other.com/img.png");
        BaseUriTrackerTest.assertEquals("Absolute URL passes through", "https://other.com/img.png", result);
    }

    private static void testMalformedUrlsReturnNull() {
        String[] malformedUrls;
        BaseUriTracker tracker = new BaseUriTracker("https://example.com/page.html", null);
        for (String url : malformedUrls = new String[]{":", ":/", "://", ":///", ":a", "a:", "a::", "::", "://:", ":::"}) {
            try {
                String result = tracker.toAbsoluteUriWithCurrentBase(url);
                BaseUriTrackerTest.pass("Malformed URL '" + url + "' handled without exception");
            }
            catch (StringIndexOutOfBoundsException e) {
                BaseUriTrackerTest.fail("Malformed URL '" + url + "' threw StringIndexOutOfBoundsException");
            }
            catch (Exception e) {
                BaseUriTrackerTest.fail("Malformed URL '" + url + "' threw " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
    }

    private static void testNullBaseUrl() {
        BaseUriTracker tracker = new BaseUriTracker("not-a-valid-url", null);
        try {
            String result = tracker.toAbsoluteUriWithCurrentBase("image.png");
            BaseUriTrackerTest.pass("Null base URL handled without exception");
        }
        catch (Exception e) {
            BaseUriTrackerTest.fail("Null base URL threw " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private static void assertEquals(String testName, String expected, String actual) {
        if (expected == null ? actual == null : expected.equals(actual)) {
            BaseUriTrackerTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: " + expected);
            System.out.println("  Actual: " + actual);
            ++failed;
        }
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }

    private static void fail(String testName) {
        System.out.println("FAIL: " + testName);
        ++failed;
    }
}

