/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.xml.sax;

import nu.validator.vendor.thaiopensource.util.Uri;
import org.xml.sax.Locator;

public class XmlBaseHandler {
    private int depth = 0;
    private Locator loc;
    private Entry stack = null;

    public void setLocator(Locator locator) {
        this.loc = locator;
    }

    public void startElement() {
        ++this.depth;
    }

    public void endElement() {
        if (this.stack != null && this.stack.depth == this.depth) {
            this.stack = this.stack.parent;
        }
        --this.depth;
    }

    public void xmlBaseAttribute(String string) {
        Entry entry = new Entry();
        entry.parent = this.stack;
        this.stack = entry;
        entry.attValue = string;
        entry.systemId = this.getSystemId();
        entry.depth = this.depth;
    }

    private String getSystemId() {
        return this.loc == null ? null : this.loc.getSystemId();
    }

    public String getBaseUri() {
        return XmlBaseHandler.getBaseUri1(this.getSystemId(), this.stack);
    }

    private static String getBaseUri1(String string, Entry entry) {
        if (entry == null || string != null && !string.equals(entry.systemId)) {
            return string;
        }
        string = entry.attValue;
        if (Uri.isAbsolute(string)) {
            return string;
        }
        return Uri.resolve(XmlBaseHandler.getBaseUri1(entry.systemId, entry.parent), string);
    }

    private static class Entry {
        private Entry parent;
        private String attValue;
        private String systemId;
        private int depth;

        private Entry() {
        }
    }
}

