/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.xml.out;

import java.io.UnsupportedEncodingException;

public class CharRepertoire {
    private final byte[] allUnknown = new byte[256];
    private final byte[][] charTable = new byte[256][];
    private static final byte UNKNOWN = 0;
    private static final byte IN = 1;
    private static final byte OUT = -1;
    private final String enc;

    CharRepertoire(String string) {
        this.enc = string;
        for (int i = 0; i < this.charTable.length; ++i) {
            this.charTable[i] = this.allUnknown;
        }
    }

    public static CharRepertoire getInstance(String string) throws UnsupportedEncodingException {
        "x".getBytes(string);
        return new CharRepertoire(string);
    }

    public final boolean contains(char c) {
        byte by = this.charTable[c >> 8][c & 0xFF];
        return by == 0 ? this.contains1(c) : by > 0;
    }

    private boolean contains1(char c) {
        int n = c >> 8;
        if (this.charTable[n] == this.allUnknown) {
            this.charTable[n] = new byte[256];
        }
        if (this.contains2(c)) {
            this.charTable[n][c & 0xFF] = 1;
            return true;
        }
        this.charTable[n][c & 0xFF] = -1;
        return false;
    }

    private boolean contains2(char c) {
        try {
            String string = new String(new String(new char[]{c}).getBytes(this.enc), this.enc);
            return string.length() == 1 && string.charAt(0) == c;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public final boolean contains(char c, char c2) {
        try {
            String string = new String(new String(new char[]{c, c2}).getBytes(this.enc), this.enc);
            return string.length() == 2 && string.charAt(0) == c && string.charAt(1) == c2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }
}

