/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.schematron;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.validate.ResolverFactory;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.Validator;
import nu.validator.vendor.thaiopensource.validate.schematron.OutputHandler;
import nu.validator.vendor.thaiopensource.xml.sax.Resolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;

class ValidatorImpl
implements Validator {
    private final Templates templates;
    private final SAXTransformerFactory factory;
    private final ContentHandler outputHandler;
    private TransformerHandler transformerHandler;
    private final Resolver resolver;

    ValidatorImpl(Templates templates, SAXTransformerFactory sAXTransformerFactory, PropertyMap propertyMap) {
        this.templates = templates;
        this.factory = sAXTransformerFactory;
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        this.outputHandler = new OutputHandler(errorHandler);
        this.resolver = ResolverFactory.createResolver(propertyMap);
        this.initTransformerHandler();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.transformerHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.transformerHandler;
    }

    @Override
    public void reset() {
        this.initTransformerHandler();
    }

    private void initTransformerHandler() {
        try {
            this.transformerHandler = this.factory.newTransformerHandler(this.templates);
            this.transformerHandler.getTransformer().setURIResolver(this.resolver.getURIResolver());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException("could not create transformer");
        }
        this.transformerHandler.setResult(new SAXResult(this.outputHandler));
    }
}

