/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.picl;

import java.util.Stack;
import nu.validator.vendor.thaiopensource.util.Localizer;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.Validator;
import nu.validator.vendor.thaiopensource.validate.picl.Constraint;
import nu.validator.vendor.thaiopensource.validate.picl.ErrorContext;
import nu.validator.vendor.thaiopensource.validate.picl.Path;
import nu.validator.vendor.thaiopensource.validate.picl.Pattern;
import nu.validator.vendor.thaiopensource.validate.picl.PatternManager;
import nu.validator.vendor.thaiopensource.validate.picl.SelectionHandler;
import nu.validator.vendor.thaiopensource.validate.picl.ValueHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

class ValidatorImpl
extends DefaultHandler
implements Validator,
Path,
PatternManager,
ErrorContext {
    private final Constraint constraint;
    private final Stack openElements = new Stack();
    private final Stack valueHandlers = new Stack();
    private final Stack activePatterns = new Stack();
    private final AttributePath attributePath = new AttributePath();
    private Locator locator;
    private final ErrorHandler eh;
    private final Localizer localizer = new Localizer(ValidatorImpl.class);

    ValidatorImpl(Constraint constraint, PropertyMap propertyMap) {
        this.constraint = constraint;
        this.eh = ValidateProperty.ERROR_HANDLER.get(propertyMap);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void reset() {
        this.openElements.setSize(0);
        this.valueHandlers.setSize(0);
        this.activePatterns.setSize(0);
        this.locator = null;
    }

    @Override
    public int length() {
        return this.openElements.size();
    }

    @Override
    public String getLocalName(int n) {
        return ((OpenElement)this.openElements.elementAt((int)n)).localName;
    }

    @Override
    public String getNamespaceUri(int n) {
        return ((OpenElement)this.openElements.elementAt((int)n)).namespaceUri;
    }

    @Override
    public boolean isAttribute() {
        return false;
    }

    @Override
    public void registerPattern(Pattern pattern, SelectionHandler selectionHandler) {
        this.activePatterns.push(new ActivePattern(this.openElements.size(), pattern, selectionHandler));
        ++((OpenElement)this.openElements.peek()).nActivePatterns;
    }

    @Override
    public void registerValueHandler(ValueHandler valueHandler) {
        this.valueHandlers.push(valueHandler);
        ++((OpenElement)this.openElements.peek()).nValueHandlers;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.locator == null) {
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setLineNumber(-1);
            locatorImpl.setColumnNumber(-1);
            this.locator = locatorImpl;
        }
        this.openElements.push(new OpenElement("", "#root"));
        try {
            this.constraint.activate(this);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.popOpenElement();
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n;
            this.openElements.push(new OpenElement(string, string2));
            int n2 = this.valueHandlers.size();
            for (n = 0; n < n2; ++n) {
                ((ValueHandler)this.valueHandlers.elementAt(n)).tag(this);
            }
            n2 = this.activePatterns.size();
            for (n = 0; n < n2; ++n) {
                ActivePattern activePattern = (ActivePattern)this.activePatterns.elementAt(n);
                if (!activePattern.pattern.matches(this, activePattern.rootDepth)) continue;
                activePattern.handler.selectElement(this, this, this);
            }
            n = this.activePatterns.size();
            int n3 = attributes.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                this.attributePath.set(attributes, n2);
                for (int i = 0; i < n; ++i) {
                    ActivePattern activePattern = (ActivePattern)this.activePatterns.elementAt(i);
                    if (!activePattern.pattern.matches(this.attributePath, activePattern.rootDepth)) continue;
                    activePattern.handler.selectAttribute(this, this.attributePath, attributes.getValue(n2));
                }
            }
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.popOpenElement();
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            int n3 = this.valueHandlers.size();
            for (int i = 0; i < n3; ++i) {
                ((ValueHandler)this.valueHandlers.elementAt(i)).characters(this, cArray, n, n2);
            }
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    private void popOpenElement() {
        Object object;
        int n;
        OpenElement openElement = (OpenElement)this.openElements.pop();
        for (n = 0; n < openElement.nValueHandlers; ++n) {
            object = (ValueHandler)this.valueHandlers.pop();
            object.valueComplete(this);
        }
        for (n = 0; n < openElement.nActivePatterns; ++n) {
            object = (ActivePattern)this.activePatterns.pop();
            ((ActivePattern)object).handler.selectComplete(this);
        }
    }

    @Override
    public void error(Locator locator, String string) {
        if (locator == null) {
            locator = this.locator;
        }
        try {
            this.eh.error(new SAXParseException(this.localizer.message(string), locator));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    @Override
    public void error(Locator locator, String string, String string2) {
        if (locator == null) {
            locator = this.locator;
        }
        try {
            this.eh.error(new SAXParseException(this.localizer.message(string, string2), locator));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    @Override
    public Locator saveLocator() {
        return new LocatorImpl(this.locator);
    }

    class AttributePath
    implements Path {
        private Attributes atts;
        private int attIndex;

        AttributePath() {
        }

        void set(Attributes attributes, int n) {
            this.atts = attributes;
            this.attIndex = n;
        }

        @Override
        public boolean isAttribute() {
            return true;
        }

        @Override
        public int length() {
            return ValidatorImpl.this.length() + 1;
        }

        @Override
        public String getLocalName(int n) {
            if (n == ValidatorImpl.this.openElements.size()) {
                return this.atts.getLocalName(this.attIndex);
            }
            return ValidatorImpl.this.getLocalName(n);
        }

        @Override
        public String getNamespaceUri(int n) {
            if (n == ValidatorImpl.this.openElements.size()) {
                return this.atts.getURI(this.attIndex);
            }
            return ValidatorImpl.this.getNamespaceUri(n);
        }
    }

    static class OpenElement {
        final String namespaceUri;
        final String localName;
        int nActivePatterns;
        int nValueHandlers;

        OpenElement(String string, String string2) {
            this.namespaceUri = string;
            this.localName = string2;
        }
    }

    static class ActivePattern {
        final int rootDepth;
        final Pattern pattern;
        final SelectionHandler handler;

        ActivePattern(int n, Pattern pattern, SelectionHandler selectionHandler) {
            this.rootDepth = n;
            this.pattern = pattern;
            this.handler = selectionHandler;
        }
    }

    private static class WrappedSAXException
    extends RuntimeException {
        final SAXException exception;

        WrappedSAXException(SAXException sAXException) {
            this.exception = sAXException;
        }
    }
}

