/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.picl;

import java.io.IOException;
import java.net.URL;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.util.SinglePropertyMap;
import nu.validator.vendor.thaiopensource.validate.IncorrectSchemaException;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaFuture;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaReceiver;
import nu.validator.vendor.thaiopensource.validate.picl.SchemaParser;
import nu.validator.vendor.thaiopensource.validate.rng.CompactSchemaReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private final String PICL_SCHEMA = "picl.rnc";
    private Schema piclSchema = null;
    private final PropertyMap properties;

    SchemaReceiverImpl(PropertyMap propertyMap) {
        this.properties = new SinglePropertyMap(ValidateProperty.ERROR_HANDLER, ValidateProperty.ERROR_HANDLER.get(propertyMap));
    }

    @Override
    public SchemaFuture installHandlers(XMLReader xMLReader) throws SAXException {
        SchemaParser schemaParser = new SchemaParser(this.properties, this.getPiclSchema());
        xMLReader.setContentHandler(schemaParser);
        return schemaParser;
    }

    private Schema getPiclSchema() throws SAXException {
        if (this.piclSchema == null) {
            String string = SchemaReceiverImpl.class.getName();
            String string2 = string.substring(0, string.lastIndexOf(46)).replace('.', '/') + "/resources/" + "picl.rnc";
            URL uRL = SchemaReceiverImpl.getResource(string2);
            try {
                this.piclSchema = CompactSchemaReader.getInstance().createSchema(new InputSource(uRL.toString()), this.properties);
            }
            catch (IncorrectSchemaException incorrectSchemaException) {
                throw new SAXException("unexpected internal error in RNC schema for picl");
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        return this.piclSchema;
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = SchemaReceiverImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }
}

