/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.mns;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import nu.validator.vendor.thaiopensource.util.Localizer;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.util.PropertyMapBuilder;
import nu.validator.vendor.thaiopensource.util.Uri;
import nu.validator.vendor.thaiopensource.validate.AbstractSchema;
import nu.validator.vendor.thaiopensource.validate.IncorrectSchemaException;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.Validator;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaFuture;
import nu.validator.vendor.thaiopensource.validate.mns.ContextMap;
import nu.validator.vendor.thaiopensource.validate.mns.ElementsOrAttributes;
import nu.validator.vendor.thaiopensource.validate.mns.Hashset;
import nu.validator.vendor.thaiopensource.validate.mns.SchemaReceiverImpl;
import nu.validator.vendor.thaiopensource.validate.mns.ValidatorImpl;
import nu.validator.vendor.thaiopensource.xml.sax.CountingErrorHandler;
import nu.validator.vendor.thaiopensource.xml.sax.DelegatingContentHandler;
import nu.validator.vendor.thaiopensource.xml.sax.XmlBaseHandler;
import nu.validator.vendor.thaiopensource.xml.util.Name;
import nu.validator.vendor.thaiopensource.xml.util.StringSplitter;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

class SchemaImpl
extends AbstractSchema {
    static final String MNS_URI = "http://www.thaiopensource.com/ns/mns";
    private final Hashtable modeMap = new Hashtable();
    private Mode startMode;
    private static final String DEFAULT_MODE_NAME = "#default";
    private final boolean attributesSchema;

    SchemaImpl(boolean bl) {
        this.attributesSchema = bl;
    }

    SchemaFuture installHandlers(XMLReader xMLReader, SchemaReceiverImpl schemaReceiverImpl) {
        Handler handler = new Handler(schemaReceiverImpl);
        xMLReader.setContentHandler(handler);
        return handler;
    }

    @Override
    public Validator createValidator(PropertyMap propertyMap) {
        return new ValidatorImpl(this.startMode, propertyMap);
    }

    private Mode lookupCreateMode(String string) {
        Mode mode = (Mode)this.modeMap.get(string);
        if (mode == null) {
            mode = new Mode(this.attributesSchema ? ElementsOrAttributes.ELEMENTS : ElementsOrAttributes.NEITHER);
            this.modeMap.put(string, mode);
        }
        return mode;
    }

    static class Mode {
        private Locator whereDefined;
        private boolean defined = false;
        private ElementsOrAttributes lax;
        private boolean strictDefined = false;
        private final Hashtable elementMap = new Hashtable();
        private final Hashtable attributesMap = new Hashtable();

        Mode(ElementsOrAttributes elementsOrAttributes) {
            this.lax = elementsOrAttributes;
        }

        ElementsOrAttributes getLax() {
            return this.lax;
        }

        Schema getAttributesSchema(String string) {
            return (Schema)this.attributesMap.get(string);
        }

        ElementAction getElementAction(String string) {
            return (ElementAction)this.elementMap.get(string);
        }
    }

    private class Handler
    extends DelegatingContentHandler
    implements SchemaFuture {
        private final SchemaReceiverImpl sr;
        private ElementAction currentElementAction;
        private boolean hadError = false;
        private final ErrorHandler eh;
        private final CountingErrorHandler ceh;
        private final Localizer localizer = new Localizer(SchemaImpl.class);
        private Locator locator;
        private final XmlBaseHandler xmlBaseHandler = new XmlBaseHandler();
        private int foreignDepth = 0;
        private String contextNs;
        private Mode contextMode;
        private String elementNs;
        private String defaultSchemaType;
        private final Stack nameStack = new Stack();
        private boolean isRoot;
        private int pathDepth = 0;
        private Validator validator;

        Handler(SchemaReceiverImpl schemaReceiverImpl) {
            this.sr = schemaReceiverImpl;
            this.eh = ValidateProperty.ERROR_HANDLER.get(schemaReceiverImpl.getProperties());
            this.ceh = new CountingErrorHandler(this.eh);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.xmlBaseHandler.setLocator(locator);
            this.locator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
            try {
                PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.sr.getProperties());
                ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, this.ceh);
                this.validator = this.sr.getMnsSchema().createValidator(propertyMapBuilder.toPropertyMap());
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
            catch (IncorrectSchemaException incorrectSchemaException) {
                throw new RuntimeException("internal error in RNG schema for MNS");
            }
            this.setDelegate(this.validator.getContentHandler());
            if (this.locator != null) {
                super.setDocumentLocator(this.locator);
            }
            super.startDocument();
        }

        @Override
        public Schema getSchema() throws IncorrectSchemaException, SAXException {
            if (this.validator == null || this.ceh.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            Enumeration enumeration = SchemaImpl.this.modeMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Mode mode = (Mode)SchemaImpl.this.modeMap.get(string);
                if (mode.defined || string.equals(SchemaImpl.DEFAULT_MODE_NAME)) continue;
                this.error("undefined_mode", string, mode.whereDefined);
            }
            if (this.hadError) {
                throw new IncorrectSchemaException();
            }
            return SchemaImpl.this;
        }

        @Override
        public RuntimeException unwrapException(RuntimeException runtimeException) throws SAXException, IOException, IncorrectSchemaException {
            if (runtimeException instanceof WrappedIOException) {
                throw ((WrappedIOException)runtimeException).getException();
            }
            return runtimeException;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            this.xmlBaseHandler.startElement();
            String string4 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            if (string4 != null) {
                this.xmlBaseHandler.xmlBaseAttribute(string4);
            }
            if (!SchemaImpl.MNS_URI.equals(string) || this.foreignDepth > 0) {
                ++this.foreignDepth;
                return;
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                return;
            }
            if (string2.equals("rules")) {
                this.parseRules(attributes);
            } else if (string2.equals("cover")) {
                this.parseCover(attributes);
            } else if (string2.equals("context")) {
                this.parseContext(attributes);
            } else if (string2.equals("root")) {
                this.parseRoot(attributes);
            } else if (string2.equals("element")) {
                this.parseElement(attributes);
            } else if (string2.equals("lax")) {
                this.parseLax(attributes);
            } else {
                this.parseValidate(string2.equals("validateAttributes"), attributes);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            this.xmlBaseHandler.endElement();
            if (this.foreignDepth > 0) {
                --this.foreignDepth;
                return;
            }
            if (this.pathDepth > 0) {
                --this.pathDepth;
                if (this.pathDepth == 0) {
                    this.endPath();
                }
            }
        }

        private void parseRules(Attributes attributes) {
            String string = attributes.getValue("", "startMode");
            if (string == null) {
                string = SchemaImpl.DEFAULT_MODE_NAME;
            }
            this.defaultSchemaType = this.getSchemaType(attributes);
            SchemaImpl.this.startMode = SchemaImpl.this.lookupCreateMode(string);
        }

        private void parseCover(Attributes attributes) throws SAXException {
            String string = this.getNs(attributes, false);
            this.currentElementAction.covered.add(string);
        }

        private void parseLax(Attributes attributes) throws SAXException {
            String[] stringArray = this.getInModes(attributes);
            Mode[] modeArray = this.getModes(stringArray);
            ElementsOrAttributes elementsOrAttributes = this.toElementsOrAttributes(attributes.getValue("", "allow"), ElementsOrAttributes.BOTH);
            for (int i = 0; i < modeArray.length; ++i) {
                if (modeArray[i].strictDefined) {
                    this.error("lax_multiply_defined", stringArray[i]);
                    continue;
                }
                modeArray[i].lax = elementsOrAttributes;
                modeArray[i].strictDefined = true;
            }
        }

        private void parseValidate(boolean bl, Attributes attributes) throws SAXException {
            String[] stringArray = this.getInModes(attributes);
            Mode[] modeArray = this.getModes(stringArray);
            String string = this.getNs(attributes, bl);
            String string2 = this.getSchema(attributes);
            String string3 = this.getSchemaType(attributes);
            if (string3 == null) {
                string3 = this.defaultSchemaType;
            }
            try {
                if (bl) {
                    Schema schema = this.sr.createChildSchema(new InputSource(string2), string3, true);
                    for (int i = 0; i < modeArray.length; ++i) {
                        if (modeArray[i].attributesMap.get(string) != null) {
                            this.error("validate_attributes_multiply_defined", stringArray[i], string);
                            continue;
                        }
                        modeArray[i].attributesMap.put(string, schema);
                    }
                } else {
                    Schema schema = this.sr.createChildSchema(new InputSource(string2), string3, false);
                    this.currentElementAction = new ElementAction(string, schema, this.getUseMode(attributes), new ContextMap(), this.getPrune(attributes));
                    this.contextNs = string;
                    for (int i = 0; i < modeArray.length; ++i) {
                        if (modeArray[i].elementMap.get(string) != null) {
                            this.error("validate_element_multiply_defined", stringArray[i], string);
                            continue;
                        }
                        modeArray[i].elementMap.put(string, this.currentElementAction);
                    }
                }
            }
            catch (IncorrectSchemaException incorrectSchemaException) {
                this.hadError = true;
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
        }

        private void parseContext(Attributes attributes) throws SAXException {
            String string = this.getNs(attributes, false);
            if (string != null) {
                this.contextNs = string;
            }
            this.elementNs = this.contextNs;
            this.contextMode = this.getUseMode(attributes);
        }

        private void parseRoot(Attributes attributes) throws SAXException {
            String string = this.getNs(attributes, false);
            if (string != null) {
                this.elementNs = string;
            }
            this.isRoot = true;
            ++this.pathDepth;
        }

        private void parseElement(Attributes attributes) throws SAXException {
            String string = this.getNs(attributes, false);
            if (string != null) {
                this.elementNs = string;
            }
            if (!this.currentElementAction.covered.contains(this.elementNs)) {
                this.error("context_ns_not_covered", this.elementNs);
            }
            this.nameStack.push(new Name(this.elementNs, attributes.getValue("", "name").trim()));
            ++this.pathDepth;
        }

        private void endPath() throws SAXException {
            if (!this.currentElementAction.contextMap.put(this.isRoot, this.nameStack, this.contextMode)) {
                this.error("path_multiply_defined", this.displayPath(this.isRoot, this.nameStack));
            }
            this.elementNs = this.contextNs;
            this.isRoot = false;
            this.nameStack.setSize(0);
        }

        private String displayPath(boolean bl, Stack stack) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = stack.size();
            for (int i = 0; i < n; ++i) {
                Name name;
                if (i > 0 || bl) {
                    stringBuffer.append('/');
                }
                if ((name = (Name)stack.elementAt(i)).getNamespaceUri().length() > 0) {
                    stringBuffer.append('{');
                    stringBuffer.append(name.getNamespaceUri());
                    stringBuffer.append('}');
                }
                stringBuffer.append(name.getLocalName());
            }
            return stringBuffer.toString();
        }

        private String getSchema(Attributes attributes) throws SAXException {
            String string = attributes.getValue("", "schema");
            if (Uri.hasFragmentId(string)) {
                this.error("schema_fragment_id");
            }
            return Uri.resolve(this.xmlBaseHandler.getBaseUri(), Uri.escapeDisallowedChars(string));
        }

        private String getSchemaType(Attributes attributes) {
            return attributes.getValue("", "schemaType");
        }

        private ElementsOrAttributes getPrune(Attributes attributes) {
            return this.toElementsOrAttributes(attributes.getValue("", "prune"), ElementsOrAttributes.NEITHER);
        }

        private ElementsOrAttributes toElementsOrAttributes(String string, ElementsOrAttributes elementsOrAttributes) {
            if (string == null) {
                return elementsOrAttributes;
            }
            ElementsOrAttributes elementsOrAttributes2 = ElementsOrAttributes.NEITHER;
            if (string.indexOf("elements") >= 0) {
                elementsOrAttributes2 = elementsOrAttributes2.addElements();
            }
            if (string.indexOf("attributes") >= 0) {
                elementsOrAttributes2 = elementsOrAttributes2.addAttributes();
            }
            return elementsOrAttributes2;
        }

        private Mode getUseMode(Attributes attributes) {
            Mode mode;
            String string = attributes.getValue("", "useMode");
            if (string == null) {
                string = SchemaImpl.DEFAULT_MODE_NAME;
            }
            if ((mode = SchemaImpl.this.lookupCreateMode(string)).whereDefined == null && this.locator != null) {
                mode.whereDefined = new LocatorImpl(this.locator);
            }
            return mode;
        }

        private String getNs(Attributes attributes, boolean bl) throws SAXException {
            String string = attributes.getValue("", "ns");
            if (!(string == null || Uri.isAbsolute(string) || !bl && string.equals(""))) {
                this.error("ns_absolute");
            }
            return string;
        }

        private Mode[] getModes(String[] stringArray) {
            Mode[] modeArray = new Mode[stringArray.length];
            for (int i = 0; i < modeArray.length; ++i) {
                modeArray[i] = SchemaImpl.this.lookupCreateMode(stringArray[i]);
                modeArray[i].defined = true;
            }
            return modeArray;
        }

        private String[] getInModes(Attributes attributes) {
            String string = attributes.getValue("", "inModes");
            if (string == null) {
                return new String[]{SchemaImpl.DEFAULT_MODE_NAME};
            }
            return StringSplitter.split(string);
        }

        void error(String string) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string), this.locator));
        }

        void error(String string, String string2) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string, string2), this.locator));
        }

        void error(String string, String string2, Locator locator) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string, string2), locator));
        }

        void error(String string, String string2, String string3) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string, string2, string3), this.locator));
        }
    }

    static class ElementAction {
        private final Schema schema;
        private final Mode mode;
        private final ContextMap contextMap;
        private final ElementsOrAttributes prune;
        private final Hashset covered = new Hashset();

        ElementAction(String string, Schema schema, Mode mode, ContextMap contextMap, ElementsOrAttributes elementsOrAttributes) {
            this.schema = schema;
            this.mode = mode;
            this.contextMap = contextMap;
            this.prune = elementsOrAttributes;
            this.covered.add(string);
        }

        Mode getMode() {
            return this.mode;
        }

        ContextMap getContextMap() {
            return this.contextMap;
        }

        Schema getSchema() {
            return this.schema;
        }

        ElementsOrAttributes getPrune() {
            return this.prune;
        }

        Hashset getCoveredNamespaces() {
            return this.covered;
        }
    }

    private static final class WrappedIOException
    extends RuntimeException {
        private final IOException exception;

        private WrappedIOException(IOException iOException) {
            this.exception = iOException;
        }

        private IOException getException() {
            return this.exception;
        }
    }
}

