/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import java.util.HashMap;
import java.util.Map;
import nu.validator.vendor.relaxng.datatype.Datatype;
import nu.validator.vendor.relaxng.datatype.ValidationContext;
import nu.validator.vendor.thaiopensource.relaxng.impl.DataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.DatatypeValue;
import nu.validator.vendor.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternMemo;
import nu.validator.vendor.thaiopensource.relaxng.impl.ValidatorPatternBuilder;

class ValueDataDerivType
extends DataDerivType {
    private final Datatype dt;
    private PatternMemo noValue;
    private Map valueTable;

    ValueDataDerivType(Datatype datatype) {
        this.dt = datatype;
    }

    @Override
    DataDerivType copy() {
        return new ValueDataDerivType(this.dt);
    }

    @Override
    PatternMemo dataDeriv(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern, String string, ValidationContext validationContext) {
        PatternMemo patternMemo;
        Object object = this.dt.createValue(string, validationContext);
        if (object == null) {
            if (this.noValue == null) {
                this.noValue = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
            }
            return this.noValue;
        }
        DatatypeValue datatypeValue = new DatatypeValue(object, this.dt);
        if (this.valueTable == null) {
            this.valueTable = new HashMap();
        }
        if ((patternMemo = (PatternMemo)this.valueTable.get(datatypeValue)) == null) {
            patternMemo = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
            this.valueTable.put(datatypeValue, patternMemo);
        }
        return patternMemo;
    }

    @Override
    DataDerivType combine(DataDerivType dataDerivType) {
        if (dataDerivType instanceof ValueDataDerivType) {
            if (((ValueDataDerivType)dataDerivType).dt == this.dt) {
                return this;
            }
            return InconsistentDataDerivType.getInstance();
        }
        return dataDerivType.combine(this);
    }

    Datatype getDatatype() {
        return this.dt;
    }
}

