/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import nu.validator.vendor.relaxng.datatype.Datatype;
import nu.validator.vendor.thaiopensource.relaxng.impl.AttributePattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.DataExceptPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.DataPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.ElementPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.ErrorPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.ListPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.NameClass;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternBuilder;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternInterner;
import nu.validator.vendor.thaiopensource.relaxng.impl.TextPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.UnexpandedNotAllowedPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.ValuePattern;
import org.xml.sax.Locator;

public class SchemaPatternBuilder
extends PatternBuilder {
    private boolean idTypes;
    private final UnexpandedNotAllowedPattern unexpandedNotAllowed = new UnexpandedNotAllowedPattern();
    private final TextPattern text = new TextPattern();
    private final PatternInterner schemaInterner = new PatternInterner();

    public boolean hasIdTypes() {
        return this.idTypes;
    }

    Pattern makeElement(NameClass nameClass, Pattern pattern, Locator locator) {
        ElementPattern elementPattern = new ElementPattern(nameClass, pattern, locator);
        return this.schemaInterner.intern(elementPattern);
    }

    Pattern makeAttribute(NameClass nameClass, Pattern pattern, Locator locator) {
        if (pattern == this.notAllowed) {
            return pattern;
        }
        AttributePattern attributePattern = new AttributePattern(nameClass, pattern, locator);
        return this.schemaInterner.intern(attributePattern);
    }

    Pattern makeData(Datatype datatype) {
        this.noteDatatype(datatype);
        DataPattern dataPattern = new DataPattern(datatype);
        return this.schemaInterner.intern(dataPattern);
    }

    Pattern makeDataExcept(Datatype datatype, Pattern pattern, Locator locator) {
        this.noteDatatype(datatype);
        DataExceptPattern dataExceptPattern = new DataExceptPattern(datatype, pattern, locator);
        return this.schemaInterner.intern(dataExceptPattern);
    }

    Pattern makeValue(Datatype datatype, Object object) {
        this.noteDatatype(datatype);
        ValuePattern valuePattern = new ValuePattern(datatype, object);
        return this.schemaInterner.intern(valuePattern);
    }

    Pattern makeText() {
        return this.text;
    }

    @Override
    Pattern makeOneOrMore(Pattern pattern) {
        if (pattern == this.text) {
            return pattern;
        }
        return super.makeOneOrMore(pattern);
    }

    Pattern makeUnexpandedNotAllowed() {
        return this.unexpandedNotAllowed;
    }

    Pattern makeError() {
        ErrorPattern errorPattern = new ErrorPattern();
        return this.schemaInterner.intern(errorPattern);
    }

    @Override
    Pattern makeChoice(Pattern pattern, Pattern pattern2) {
        if (pattern == this.notAllowed || pattern == pattern2) {
            return pattern2;
        }
        if (pattern2 == this.notAllowed) {
            return pattern;
        }
        return super.makeChoice(pattern, pattern2);
    }

    Pattern makeList(Pattern pattern, Locator locator) {
        if (pattern == this.notAllowed) {
            return pattern;
        }
        ListPattern listPattern = new ListPattern(pattern, locator);
        return this.schemaInterner.intern(listPattern);
    }

    Pattern makeMixed(Pattern pattern) {
        return this.makeInterleave(this.text, pattern);
    }

    private void noteDatatype(Datatype datatype) {
        if (datatype.getIdType() != 0) {
            this.idTypes = true;
        }
    }
}

