/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import java.util.HashMap;
import java.util.Map;
import nu.validator.vendor.thaiopensource.relaxng.impl.AbstractPatternFunction;
import nu.validator.vendor.thaiopensource.relaxng.impl.BinaryPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.ChoicePattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.ElementPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.GroupPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.InterleavePattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.OneOrMorePattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import nu.validator.vendor.thaiopensource.xml.util.Name;

class FindElementFunction
extends AbstractPatternFunction {
    private final ValidatorPatternBuilder builder;
    private final Name name;
    private final Map processed = new HashMap();
    private int specificity = -1;
    private Pattern pattern = null;

    public static Pattern findElement(ValidatorPatternBuilder validatorPatternBuilder, Name name, Pattern pattern) {
        FindElementFunction findElementFunction = new FindElementFunction(validatorPatternBuilder, name);
        pattern.apply(findElementFunction);
        if (findElementFunction.pattern == null) {
            return validatorPatternBuilder.makeNotAllowed();
        }
        return findElementFunction.pattern;
    }

    private FindElementFunction(ValidatorPatternBuilder validatorPatternBuilder, Name name) {
        this.builder = validatorPatternBuilder;
        this.name = name;
    }

    private boolean haveProcessed(Pattern pattern) {
        if (this.processed.get(pattern) != null) {
            return true;
        }
        this.processed.put(pattern, pattern);
        return false;
    }

    private Object caseBinary(BinaryPattern binaryPattern) {
        if (!this.haveProcessed(binaryPattern)) {
            binaryPattern.getOperand1().apply(this);
            binaryPattern.getOperand2().apply(this);
        }
        return null;
    }

    @Override
    public Object caseGroup(GroupPattern groupPattern) {
        return this.caseBinary(groupPattern);
    }

    @Override
    public Object caseInterleave(InterleavePattern interleavePattern) {
        return this.caseBinary(interleavePattern);
    }

    @Override
    public Object caseChoice(ChoicePattern choicePattern) {
        return this.caseBinary(choicePattern);
    }

    @Override
    public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        if (!this.haveProcessed(oneOrMorePattern)) {
            oneOrMorePattern.getOperand().apply(this);
        }
        return null;
    }

    @Override
    public Object caseElement(ElementPattern elementPattern) {
        if (!this.haveProcessed(elementPattern)) {
            int n = elementPattern.getNameClass().containsSpecificity(this.name);
            if (n > this.specificity) {
                this.specificity = n;
                this.pattern = elementPattern.getContent();
            } else if (n == this.specificity && n != -1) {
                this.pattern = this.builder.makeChoice(this.pattern, elementPattern.getContent());
            }
            elementPattern.getContent().apply(this);
        }
        return null;
    }

    @Override
    public Object caseOther(Pattern pattern) {
        return null;
    }
}

