/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import nu.validator.vendor.relaxng.datatype.Datatype;
import nu.validator.vendor.thaiopensource.datatype.Datatype2;
import nu.validator.vendor.thaiopensource.relaxng.impl.Alphabet;
import nu.validator.vendor.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternFunction;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternVisitor;
import nu.validator.vendor.thaiopensource.relaxng.impl.RestrictionViolationException;
import nu.validator.vendor.thaiopensource.relaxng.impl.StringPattern;

class DataPattern
extends StringPattern {
    private final Datatype dt;

    DataPattern(Datatype datatype) {
        super(DataPattern.combineHashCode(31, datatype.hashCode()));
        this.dt = datatype;
    }

    @Override
    boolean samePattern(Pattern pattern) {
        if (pattern.getClass() != this.getClass()) {
            return false;
        }
        return this.dt.equals(((DataPattern)pattern).dt);
    }

    @Override
    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitData(this.dt);
    }

    @Override
    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseData(this);
    }

    Datatype getDatatype() {
        return this.dt;
    }

    boolean allowsAnyString() {
        return this.dt instanceof Datatype2 && ((Datatype2)this.dt).alwaysValid();
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_data");
            }
        }
    }
}

