/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng;

import java.io.IOException;
import nu.validator.vendor.relaxng.datatype.DatatypeLibraryFactory;
import nu.validator.vendor.thaiopensource.util.PropertyMapBuilder;
import nu.validator.vendor.thaiopensource.validate.Flag;
import nu.validator.vendor.thaiopensource.validate.IncorrectSchemaException;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.SchemaReader;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.auto.AutoSchemaReader;
import nu.validator.vendor.thaiopensource.validate.prop.rng.RngProperty;
import nu.validator.vendor.thaiopensource.validate.rng.CompactSchemaReader;
import nu.validator.vendor.thaiopensource.xml.sax.XMLReaderCreator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaFactory {
    private PropertyMapBuilder properties = new PropertyMapBuilder();
    private boolean compactSyntax = false;
    private SchemaReader autoSchemaLanguage = new AutoSchemaReader();

    public Schema createSchema(InputSource inputSource) throws IOException, SAXException, IncorrectSchemaException {
        SchemaReader schemaReader = this.compactSyntax ? CompactSchemaReader.getInstance() : this.autoSchemaLanguage;
        return schemaReader.createSchema(inputSource, this.properties.toPropertyMap());
    }

    public void setXMLReaderCreator(XMLReaderCreator xMLReaderCreator) {
        this.properties.put(ValidateProperty.XML_READER_CREATOR, xMLReaderCreator);
    }

    public XMLReaderCreator getXMLReaderCreator() {
        return (XMLReaderCreator)this.properties.get(ValidateProperty.XML_READER_CREATOR);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.properties.put(ValidateProperty.ERROR_HANDLER, errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return (ErrorHandler)this.properties.get(ValidateProperty.ERROR_HANDLER);
    }

    public void setDatatypeLibraryFactory(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.properties.put(RngProperty.DATATYPE_LIBRARY_FACTORY, datatypeLibraryFactory);
    }

    public DatatypeLibraryFactory getDatatypeLibraryFactory() {
        return (DatatypeLibraryFactory)this.properties.get(RngProperty.DATATYPE_LIBRARY_FACTORY);
    }

    public void setCheckIdIdref(boolean bl) {
        this.properties.put(RngProperty.CHECK_ID_IDREF, bl ? Flag.PRESENT : null);
    }

    public boolean getCheckIdIdref() {
        return this.properties.contains(RngProperty.CHECK_ID_IDREF);
    }

    public void setCompactSyntax(boolean bl) {
        this.compactSyntax = bl;
    }

    public boolean getCompactSyntax() {
        return this.compactSyntax;
    }

    public void setFeasible(boolean bl) {
        this.properties.put(RngProperty.FEASIBLE, bl ? Flag.PRESENT : null);
    }

    public boolean getFeasible() {
        return this.properties.contains(RngProperty.FEASIBLE);
    }
}

