/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.validation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import nu.validator.checker.CspEnforcementChecker;
import nu.validator.checker.DuplicateDtChecker;
import nu.validator.checker.HeadingHierarchyChecker;
import nu.validator.checker.MicrodataChecker;
import nu.validator.checker.NormalizationChecker;
import nu.validator.checker.SpeculationRulesChecker;
import nu.validator.checker.TextContentChecker;
import nu.validator.checker.UncheckedSubtreeWarner;
import nu.validator.checker.UsemapChecker;
import nu.validator.checker.XmlPiChecker;
import nu.validator.checker.jing.CheckerSchema;
import nu.validator.checker.jing.CheckerValidator;
import nu.validator.checker.table.TableChecker;
import nu.validator.gnu.xml.aelfred2.FatalSAXException;
import nu.validator.gnu.xml.aelfred2.SAXDriver;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.localentities.LocalCacheEntityResolver;
import nu.validator.source.SourceCode;
import nu.validator.vendor.thaiopensource.relaxng.impl.CombineValidator;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.util.PropertyMapBuilder;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.SchemaReader;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.Validator;
import nu.validator.vendor.thaiopensource.validate.auto.AutoSchemaReader;
import nu.validator.vendor.thaiopensource.validate.prop.rng.RngProperty;
import nu.validator.vendor.thaiopensource.validate.rng.CompactSchemaReader;
import nu.validator.vendor.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import nu.validator.xml.AttributesPermutingXMLReaderWrapper;
import nu.validator.xml.IdFilter;
import nu.validator.xml.NullEntityResolver;
import nu.validator.xml.PrudentHttpEntityResolver;
import nu.validator.xml.TypedInputSource;
import nu.validator.xml.WiretapXMLReaderWrapper;
import nu.validator.xml.ariaattributes.AriaAttributeDroppingSchemaWrapper;
import nu.validator.xml.customelements.NamespaceChangingSchemaWrapper;
import nu.validator.xml.dataattributes.DataAttributeDroppingSchemaWrapper;
import nu.validator.xml.langattributes.XmlLangAttributeDroppingSchemaWrapper;
import nu.validator.xml.roleattributes.RoleAttributeFilteringSchemaWrapper;
import nu.validator.xml.templateelement.TemplateElementDroppingSchemaWrapper;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SimpleDocumentValidator {
    private LocalCacheEntityResolver entityResolver;
    private Schema mainSchema;
    private String mainSchemaUrl;
    private boolean hasHtml5Schema;
    private Schema assertionSchema;
    private Schema langdetectSchema;
    private Validator validator;
    private SourceCode sourceCode = new SourceCode();
    private TypedInputSource documentInput;
    private PrudentHttpEntityResolver httpRes;
    private XMLReader htmlReader;
    private SAXDriver xmlParser;
    private XMLReader xmlReader;
    private LexicalHandler lexicalHandler;
    private boolean allowCss = false;
    private static final byte[] CSS_CHECKING_PROLOG;
    private static final byte[] CSS_CHECKING_EPILOG;

    private Schema schemaByUrl(String schemaUrl, ErrorHandler errorHandler) throws Exception, SchemaReadException {
        PropertyMapBuilder pmb = new PropertyMapBuilder();
        pmb.put(ValidateProperty.ERROR_HANDLER, errorHandler);
        pmb.put(ValidateProperty.ENTITY_RESOLVER, this.entityResolver);
        pmb.put(ValidateProperty.XML_READER_CREATOR, new Jaxp11XMLReaderCreator());
        RngProperty.CHECK_ID_IDREF.add(pmb);
        PropertyMap jingPropertyMap = pmb.toPropertyMap();
        try {
            TypedInputSource schemaInput;
            InputSource resolvedInput = this.entityResolver.resolveEntity(null, schemaUrl);
            if (resolvedInput instanceof TypedInputSource) {
                schemaInput = (TypedInputSource)resolvedInput;
            } else if (schemaUrl.startsWith("http://") || schemaUrl.startsWith("https://")) {
                PrudentHttpEntityResolver httpResolver = new PrudentHttpEntityResolver(-1L, true, errorHandler);
                httpResolver.setAllowRnc(true);
                httpResolver.setAllowGenericXml(true);
                schemaInput = (TypedInputSource)httpResolver.resolveEntity(null, schemaUrl);
            } else if (schemaUrl.startsWith("file:")) {
                schemaInput = new TypedInputSource();
                URL url = new URL(schemaUrl);
                schemaInput.setByteStream(url.openStream());
                schemaInput.setSystemId(schemaUrl);
                if (schemaUrl.endsWith(".rnc")) {
                    schemaInput.setType("application/relax-ng-compact-syntax");
                } else if (schemaUrl.endsWith(".rng")) {
                    schemaInput.setType("application/xml");
                } else {
                    schemaInput.setType("application/xml");
                }
            } else {
                throw new SchemaReadException(String.format("Failed to resolve schema URL \"%s\".", schemaUrl));
            }
            SchemaReader sr = "application/relax-ng-compact-syntax".equals(schemaInput.getType()) ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
            return sr.createSchema(schemaInput, jingPropertyMap);
        }
        catch (ClassCastException e) {
            throw new SchemaReadException(String.format("Failed to resolve schema URL \"%s\".", schemaUrl));
        }
        catch (PrudentHttpEntityResolver.ResourceNotRetrievableException e) {
            throw new SchemaReadException(String.format("Failed to retrieve schema from URL \"%s\".", schemaUrl));
        }
    }

    public SimpleDocumentValidator() {
        this(true, true, true);
    }

    public SimpleDocumentValidator(boolean initializeLog4j) {
        this(initializeLog4j, true, true);
    }

    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    public String getMainSchemaUrl() {
        return this.mainSchemaUrl;
    }

    public SimpleDocumentValidator(boolean initializeLog4j, boolean logUrls, boolean enableLanguageDetection) {
        System.setProperty("nu.validator.checker.enableLangDetection", "0");
        if (enableLanguageDetection) {
            System.setProperty("nu.validator.checker.enableLangDetection", "1");
        }
        if (initializeLog4j) {
            Properties properties = new Properties();
            try {
                properties.load(SimpleDocumentValidator.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/log4j.properties"));
                if (!logUrls) {
                    properties.setProperty("log4j.logger.nu.validator.xml.PrudentHttpEntityResolver", "FATAL");
                }
                PropertyConfigurator.configure(properties);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.entityResolver = new LocalCacheEntityResolver(new NullEntityResolver());
        this.entityResolver.setAllowRnc(true);
    }

    public void setUpMainSchema(String schemaUrl, ErrorHandler errorHandler) throws SAXException, Exception, SchemaReadException {
        Schema schema = this.schemaByUrl(schemaUrl, errorHandler);
        if (schemaUrl.contains("html5")) {
            try {
                this.assertionSchema = CheckerSchema.ASSERTION_SCH;
            }
            catch (Exception e) {
                throw new SchemaReadException("Failed to retrieve secondary schema.");
            }
            try {
                this.langdetectSchema = CheckerSchema.LANGUAGE_DETECTING_CHECKER;
            }
            catch (Exception e) {
                throw new SchemaReadException("Failed to retrieve secondary schema.");
            }
            schema = new DataAttributeDroppingSchemaWrapper(schema);
            schema = new AriaAttributeDroppingSchemaWrapper(schema);
            schema = new XmlLangAttributeDroppingSchemaWrapper(schema);
            schema = new RoleAttributeFilteringSchemaWrapper(schema);
            schema = new TemplateElementDroppingSchemaWrapper(schema);
            schema = new NamespaceChangingSchemaWrapper(schema);
            this.hasHtml5Schema = true;
            if ("http://s.validator.nu/html5-all.rnc".equals(schemaUrl)) {
                System.setProperty("nu.validator.schema.rdfa-full", "1");
            } else {
                System.setProperty("nu.validator.schema.rdfa-full", "0");
            }
        } else if (schemaUrl.contains("svg")) {
            schema = new RoleAttributeFilteringSchemaWrapper(schema);
        }
        this.mainSchemaUrl = schemaUrl;
        this.mainSchema = schema;
    }

    public void setUpValidatorAndParsers(ErrorHandler docValidationErrHandler, boolean noStream, boolean loadExternalEnts) throws SAXException {
        PropertyMapBuilder pmb = new PropertyMapBuilder();
        pmb.put(ValidateProperty.ERROR_HANDLER, docValidationErrHandler);
        pmb.put(ValidateProperty.XML_READER_CREATOR, new Jaxp11XMLReaderCreator());
        RngProperty.CHECK_ID_IDREF.add(pmb);
        PropertyMap jingPropertyMap = pmb.toPropertyMap();
        this.validator = this.mainSchema.createValidator(jingPropertyMap);
        if (this.hasHtml5Schema) {
            Validator assertionValidator = this.assertionSchema.createValidator(jingPropertyMap);
            this.validator = new CombineValidator(this.validator, assertionValidator);
            Validator langdetectValidator = this.langdetectSchema.createValidator(jingPropertyMap);
            this.validator = new CombineValidator(this.validator, langdetectValidator);
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new TableChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new DuplicateDtChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new HeadingHierarchyChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new MicrodataChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new NormalizationChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new SpeculationRulesChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new TextContentChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new UncheckedSubtreeWarner(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new UsemapChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new XmlPiChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new CspEnforcementChecker(), jingPropertyMap));
        }
        HtmlParser htmlParser = new HtmlParser();
        htmlParser.addCharacterHandler(this.sourceCode);
        htmlParser.setCommentPolicy(XmlViolationPolicy.ALLOW);
        htmlParser.setContentNonXmlCharPolicy(XmlViolationPolicy.ALLOW);
        htmlParser.setContentSpacePolicy(XmlViolationPolicy.ALTER_INFOSET);
        htmlParser.setNamePolicy(XmlViolationPolicy.ALLOW);
        htmlParser.setXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
        htmlParser.setMappingLangToXmlLang(true);
        htmlParser.setHeuristics(Heuristics.ALL);
        htmlParser.setContentHandler(this.validator.getContentHandler());
        htmlParser.setErrorHandler(docValidationErrHandler);
        htmlParser.setNamePolicy(XmlViolationPolicy.ALLOW);
        htmlParser.setMappingLangToXmlLang(true);
        htmlParser.setFeature("http://xml.org/sax/features/unicode-normalization-checking", true);
        if (!noStream) {
            htmlParser.setStreamabilityViolationPolicy(XmlViolationPolicy.FATAL);
        }
        HashMap<String, String> profileMap = new HashMap<String, String>();
        profileMap.put("html-strict", "warn");
        htmlParser.setErrorProfile(profileMap);
        AttributesPermutingXMLReaderWrapper permutingHtmlReader = new AttributesPermutingXMLReaderWrapper(htmlParser);
        this.htmlReader = this.getWiretap(permutingHtmlReader);
        this.xmlParser = new SAXDriver();
        this.xmlParser.setContentHandler(this.validator.getContentHandler());
        this.xmlParser.setErrorHandler(docValidationErrHandler);
        if (this.lexicalHandler != null) {
            this.xmlParser.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
        }
        this.xmlReader = new IdFilter(this.xmlParser);
        this.xmlReader.setContentHandler(this.validator.getContentHandler());
        this.xmlReader.setErrorHandler(this.xmlParser.getErrorHandler());
        this.xmlReader.setFeature("http://xml.org/sax/features/string-interning", true);
        this.xmlReader.setFeature("http://xml.org/sax/features/unicode-normalization-checking", true);
        if (loadExternalEnts) {
            this.xmlReader.setEntityResolver(this.entityResolver);
        } else {
            this.xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.xmlReader.setEntityResolver(new NullEntityResolver());
        }
        this.xmlReader = this.getWiretap(this.xmlReader);
        this.xmlParser.lockErrorHandler();
    }

    private WiretapXMLReaderWrapper getWiretap(XMLReader reader) {
        WiretapXMLReaderWrapper wiretap = new WiretapXMLReaderWrapper(reader);
        ContentHandler recorder = this.sourceCode.getLocationRecorder();
        wiretap.setWiretapContentHander(recorder);
        wiretap.setWiretapLexicalHandler((LexicalHandler)((Object)recorder));
        return wiretap;
    }

    public void setAllowCss(boolean allowCss) {
        this.allowCss = allowCss;
    }

    public void checkHtmlInputSource(InputSource is) throws IOException, SAXException {
        this.validator.reset();
        is.setEncoding("UTF-8");
        this.checkAsHTML(is);
    }

    public void checkXmlInputSource(InputSource is) throws IOException, SAXException {
        this.validator.reset();
        this.checkAsXML(is);
    }

    public void checkCssInputSource(InputSource is) throws IOException, SAXException {
        this.validator.reset();
        this.checkAsCss(is);
    }

    public void checkCssFile(File file, boolean asUTF8) throws IOException, SAXException {
        this.validator.reset();
        InputSource is = new InputSource(new FileInputStream(file));
        is.setSystemId(file.toURI().toURL().toString());
        if (asUTF8) {
            is.setEncoding("UTF-8");
        }
        this.checkAsCss(is);
    }

    public void checkHtmlFile(File file, boolean asUTF8) throws IOException, SAXException {
        this.validator.reset();
        InputSource is = new InputSource(new FileInputStream(file));
        is.setSystemId(file.toURI().toURL().toString());
        if (asUTF8) {
            is.setEncoding("UTF-8");
        }
        this.checkAsHTML(is);
    }

    public void checkXmlFile(File file) throws IOException, SAXException {
        this.validator.reset();
        InputSource is = new InputSource(new FileInputStream(file));
        is.setSystemId(file.toURI().toURL().toString());
        this.checkAsXML(is);
    }

    public void checkHttpURL(String document, String userAgent, ErrorHandler errorHandler) throws IOException, SAXException {
        this.checkHttpURL(document, userAgent, errorHandler, null);
    }

    public void checkHttpURL(String document, String userAgent, ErrorHandler errorHandler, Map<String, String> additionalHeaders) throws IOException, SAXException {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        this.validator.reset();
        this.httpRes = new PrudentHttpEntityResolver(-1L, true, errorHandler);
        if (this.allowCss) {
            this.httpRes.setAllowCss(true);
        }
        this.httpRes.setAllowHtml(true);
        this.httpRes.setUserAgent(userAgent);
        if (additionalHeaders != null && !additionalHeaders.isEmpty()) {
            this.httpRes.setAdditionalRequestHeaders(additionalHeaders);
        }
        try {
            this.documentInput = (TypedInputSource)this.httpRes.resolveEntity(null, document);
            String contentType = this.documentInput.getType();
            this.documentInput.setSystemId(document);
            for (String param : contentType.replace(" ", "").split(";")) {
                if (!param.startsWith("charset=")) continue;
                this.documentInput.setEncoding(param.split("=", 2)[1]);
                break;
            }
            if (this.documentInput.getType().startsWith("text/css")) {
                this.checkAsCss(this.documentInput);
            } else if (this.documentInput.getType().startsWith("text/html")) {
                this.checkAsHTML(this.documentInput);
            } else {
                this.checkAsXML(this.documentInput);
            }
        }
        catch (PrudentHttpEntityResolver.ResourceNotRetrievableException resourceNotRetrievableException) {
            // empty catch block
        }
    }

    private void checkAsCss(InputSource is) throws IOException, SAXException {
        String charset = "UTF-8";
        if (is.getEncoding() != null) {
            charset = is.getEncoding();
        }
        ArrayList<InputStream> streamsList = new ArrayList<InputStream>();
        streamsList.add(new ByteArrayInputStream(CSS_CHECKING_PROLOG));
        streamsList.add(new BOMStripperInputStream(is.getByteStream()));
        streamsList.add(new ByteArrayInputStream(CSS_CHECKING_EPILOG));
        Enumeration streams = Collections.enumeration(streamsList);
        is.setByteStream(new SequenceInputStream(streams));
        is.setEncoding(charset);
        this.sourceCode.setIsCss();
        this.sourceCode.initialize(is);
        try {
            this.htmlReader.parse(is);
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
    }

    private void checkAsHTML(InputSource is) throws IOException, SAXException {
        this.sourceCode.initialize(is);
        try {
            this.htmlReader.parse(is);
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
    }

    private void checkAsXML(InputSource is) throws IOException, SAXException {
        this.xmlParser.setCharacterHandler(this.sourceCode);
        this.sourceCode.initialize(is);
        try {
            this.xmlReader.parse(is);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (FatalSAXException fatalSAXException) {
            // empty catch block
        }
    }

    static {
        PrudentHttpEntityResolver.setParams(Integer.parseInt(System.getProperty("nu.validator.servlet.connection-timeout", "5000")), Integer.parseInt(System.getProperty("nu.validator.servlet.socket-timeout", "5000")), Integer.parseInt(System.getProperty("nu.validator.servlet.max-requests", "100")));
        CSS_CHECKING_PROLOG = "<!DOCTYPE html><html lang=''><title>s</title><style>\n".getBytes();
        CSS_CHECKING_EPILOG = "\n</style>".getBytes();
    }

    public class SchemaReadException
    extends Exception {
        public SchemaReadException() {
        }

        public SchemaReadException(String message) {
            super(message);
        }
    }

    private static class BOMStripperInputStream
    extends FilterInputStream {
        private boolean firstRead = true;
        private byte[] buffer = null;
        private int bufferPos = 0;
        private int bufferLen = 0;

        protected BOMStripperInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            if (this.firstRead) {
                this.firstRead = false;
                this.checkAndSkipBOM();
            }
            if (this.buffer != null && this.bufferPos < this.bufferLen) {
                return this.buffer[this.bufferPos++] & 0xFF;
            }
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.firstRead) {
                this.firstRead = false;
                this.checkAndSkipBOM();
            }
            if (this.buffer != null && this.bufferPos < this.bufferLen) {
                int bytesToCopy = Math.min(len, this.bufferLen - this.bufferPos);
                System.arraycopy(this.buffer, this.bufferPos, b, off, bytesToCopy);
                this.bufferPos += bytesToCopy;
                if (bytesToCopy == len) {
                    return bytesToCopy;
                }
                int additionalBytes = super.read(b, off + bytesToCopy, len - bytesToCopy);
                if (additionalBytes > 0) {
                    return bytesToCopy + additionalBytes;
                }
                return bytesToCopy;
            }
            return super.read(b, off, len);
        }

        private void checkAndSkipBOM() throws IOException {
            byte[] bom = new byte[3];
            int bytesRead = super.read(bom, 0, 3);
            if (bytesRead >= 3 && bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                return;
            }
            if (bytesRead > 0) {
                this.buffer = bom;
                this.bufferPos = 0;
                this.bufferLen = bytesRead;
            }
        }
    }
}

