/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.io.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import nu.validator.io.DataUri;

public class DataUriTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        DataUriTest.testStartsWithData();
        DataUriTest.testSimpleTextPlain();
        DataUriTest.testExplicitTextPlain();
        DataUriTest.testTextHtml();
        DataUriTest.testWithCharset();
        DataUriTest.testBase64Encoded();
        DataUriTest.testBase64EncodedImage();
        DataUriTest.testEmptyData();
        DataUriTest.testWithParameters();
        DataUriTest.testCaseInsensitiveScheme();
        DataUriTest.testInvalidUris();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testStartsWithData() {
        DataUriTest.assertTrue("startsWithData: 'data:' returns true", DataUri.startsWithData("data:text/plain,hello"));
        DataUriTest.assertTrue("startsWithData: 'DATA:' returns true (case insensitive)", DataUri.startsWithData("DATA:text/plain,hello"));
        DataUriTest.assertTrue("startsWithData: 'DaTa:' returns true (mixed case)", DataUri.startsWithData("DaTa:text/plain,hello"));
        DataUriTest.assertFalse("startsWithData: 'http:' returns false", DataUri.startsWithData("http://example.com"));
        DataUriTest.assertFalse("startsWithData: null returns false", DataUri.startsWithData(null));
        DataUriTest.assertFalse("startsWithData: 'dat' returns false (too short)", DataUri.startsWithData("dat"));
        DataUriTest.assertFalse("startsWithData: empty string returns false", DataUri.startsWithData(""));
    }

    private static void testSimpleTextPlain() {
        try {
            DataUri dataUri = new DataUri("data:,Hello%20World");
            DataUriTest.assertEquals("Simple text/plain: content type is text/plain;charset=US-ASCII", "text/plain;charset=US-ASCII", dataUri.getContentType());
            DataUriTest.assertEquals("Simple text/plain: content is 'Hello World'", "Hello World", DataUriTest.readContent(dataUri));
            DataUriTest.pass("Simple text/plain: parsed successfully");
        }
        catch (IOException e) {
            DataUriTest.fail("Simple text/plain: unexpected exception: " + e.getMessage());
        }
    }

    private static void testExplicitTextPlain() {
        try {
            DataUri dataUri = new DataUri("data:text/plain,Hello");
            DataUriTest.assertEquals("Explicit text/plain: content type", "text/plain", dataUri.getContentType());
            DataUriTest.assertEquals("Explicit text/plain: content", "Hello", DataUriTest.readContent(dataUri));
            DataUriTest.pass("Explicit text/plain: parsed successfully");
        }
        catch (IOException e) {
            DataUriTest.fail("Explicit text/plain: unexpected exception: " + e.getMessage());
        }
    }

    private static void testTextHtml() {
        try {
            DataUri dataUri = new DataUri("data:text/html,%3Ch1%3EHello%3C%2Fh1%3E");
            DataUriTest.assertEquals("text/html: content type", "text/html", dataUri.getContentType());
            DataUriTest.assertEquals("text/html: content", "<h1>Hello</h1>", DataUriTest.readContent(dataUri));
            DataUriTest.pass("text/html: parsed successfully");
        }
        catch (IOException e) {
            DataUriTest.fail("text/html: unexpected exception: " + e.getMessage());
        }
    }

    private static void testWithCharset() {
        try {
            DataUri dataUri = new DataUri("data:text/plain;charset=utf-8,Hello");
            DataUriTest.assertEquals("With charset: content type", "text/plain;charset=utf-8", dataUri.getContentType());
            DataUriTest.assertEquals("With charset: content", "Hello", DataUriTest.readContent(dataUri));
            DataUriTest.pass("With charset: parsed successfully");
        }
        catch (IOException e) {
            DataUriTest.fail("With charset: unexpected exception: " + e.getMessage());
        }
    }

    private static void testBase64Encoded() {
        try {
            DataUri dataUri = new DataUri("data:text/plain;base64,SGVsbG8=");
            DataUriTest.assertEquals("Base64: content type", "text/plain", dataUri.getContentType());
            DataUriTest.assertEquals("Base64: decoded content", "Hello", DataUriTest.readContent(dataUri));
            DataUriTest.pass("Base64: parsed successfully");
        }
        catch (IOException e) {
            DataUriTest.fail("Base64: unexpected exception: " + e.getMessage());
        }
    }

    private static void testBase64EncodedImage() {
        try {
            String pngBase64 = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNk+M9QDwADhgGAWjR9awAAAABJRU5ErkJggg==";
            DataUri dataUri = new DataUri("data:image/png;base64," + pngBase64);
            DataUriTest.assertEquals("Base64 PNG: content type", "image/png", dataUri.getContentType());
            byte[] content = DataUriTest.readBytes(dataUri);
            DataUriTest.assertTrue("Base64 PNG: has content", content.length > 0);
            DataUriTest.pass("Base64 PNG: parsed successfully");
        }
        catch (IOException e) {
            DataUriTest.fail("Base64 PNG: unexpected exception: " + e.getMessage());
        }
    }

    private static void testEmptyData() {
        try {
            DataUri dataUri = new DataUri("data:text/plain,");
            DataUriTest.assertEquals("Empty data: content type", "text/plain", dataUri.getContentType());
            DataUriTest.assertEquals("Empty data: content is empty", "", DataUriTest.readContent(dataUri));
            DataUriTest.pass("Empty data: parsed successfully");
        }
        catch (IOException e) {
            DataUriTest.fail("Empty data: unexpected exception: " + e.getMessage());
        }
    }

    private static void testWithParameters() {
        try {
            DataUri dataUri = new DataUri("data:text/plain;charset=utf-8;foo=bar,Hello");
            DataUriTest.assertTrue("With parameters: content type contains charset", dataUri.getContentType().contains("charset=utf-8"));
            DataUriTest.assertEquals("With parameters: content", "Hello", DataUriTest.readContent(dataUri));
            DataUriTest.pass("With parameters: parsed successfully");
        }
        catch (IOException e) {
            DataUriTest.fail("With parameters: unexpected exception: " + e.getMessage());
        }
    }

    private static void testCaseInsensitiveScheme() {
        try {
            DataUri dataUri = new DataUri("DATA:text/plain,Hello");
            DataUriTest.assertEquals("Case insensitive scheme: content type", "text/plain", dataUri.getContentType());
            DataUriTest.pass("Case insensitive scheme: parsed successfully");
        }
        catch (IOException e) {
            DataUriTest.fail("Case insensitive scheme: unexpected exception: " + e.getMessage());
        }
    }

    private static void testInvalidUris() {
        try {
            new DataUri("data:text/plain,Hello#fragment");
            DataUriTest.fail("Fragment: should throw MalformedURLException");
        }
        catch (MalformedURLException e) {
            DataUriTest.pass("Fragment: throws MalformedURLException as expected");
        }
        catch (IOException e) {
            DataUriTest.fail("Fragment: unexpected IOException: " + e.getMessage());
        }
        try {
            new DataUri("http://example.com");
            DataUriTest.fail("Non-data scheme: should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            DataUriTest.pass("Non-data scheme: throws IllegalArgumentException as expected");
        }
        catch (IOException e) {
            DataUriTest.fail("Non-data scheme: unexpected IOException: " + e.getMessage());
        }
    }

    private static String readContent(DataUri dataUri) throws IOException {
        return new String(DataUriTest.readBytes(dataUri), "UTF-8");
    }

    private static byte[] readBytes(DataUri dataUri) throws IOException {
        int len;
        InputStream is = dataUri.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        is.close();
        return baos.toByteArray();
    }

    private static void assertTrue(String testName, boolean condition) {
        if (condition) {
            DataUriTest.pass(testName);
        } else {
            DataUriTest.fail(testName);
        }
    }

    private static void assertFalse(String testName, boolean condition) {
        DataUriTest.assertTrue(testName, !condition);
    }

    private static void assertEquals(String testName, String expected, String actual) {
        if (expected == null ? actual == null : expected.equals(actual)) {
            DataUriTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: " + expected);
            System.out.println("  Actual: " + actual);
            ++failed;
        }
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }

    private static void fail(String testName) {
        System.out.println("FAIL: " + testName);
        ++failed;
    }
}

