/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import nu.validator.datatype.Language;
import nu.validator.vendor.relaxng.datatype.Datatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public class LanguageTester {
    private BufferedReader in;
    private Datatype datatype;

    public LanguageTester() throws IOException {
        URL url = new URL("http://unicode.org/cldr/data/tools/java/org/unicode/cldr/util/data/langtagTest.txt");
        this.in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
        this.datatype = Language.THE_INSTANCE;
    }

    public static void main(String[] args) throws IOException {
        new LanguageTester().run();
    }

    private void run() throws IOException {
        String line = null;
        while ((line = this.in.readLine()) != null) {
            this.test(line);
        }
    }

    private void test(String line) {
        int hash = line.indexOf(35);
        if (hash > -1) {
            line = line.substring(0, hash);
        }
        line = line.trim();
        try {
            this.datatype.checkValid(line, null);
            System.out.println(line + ": OK.");
        }
        catch (DatatypeException e) {
            System.out.println(line + ": " + e.getMessage());
        }
    }
}

