/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public final class StringWithoutLineBreaks
extends AbstractDatatype {
    public static final StringWithoutLineBreaks THE_INSTANCE = new StringWithoutLineBreaks();

    private StringWithoutLineBreaks() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        int len = literal.length();
        for (int i = 0; i < len; ++i) {
            char c = literal.charAt(i);
            if (c == '\n') {
                throw this.newDatatypeException(i, "Line feed not allowed.");
            }
            if (c != '\r') continue;
            throw this.newDatatypeException(i, "Carriage return not allowed.");
        }
    }

    @Override
    public String getName() {
        return "string without line breaks";
    }
}

