/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.HashSet;
import java.util.Set;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public final class SandboxAllowList
extends AbstractDatatype {
    public static final SandboxAllowList THE_INSTANCE = new SandboxAllowList();
    private static final HashSet<String> allowedKeywords = new HashSet();
    private static final boolean WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");
    private boolean hasAllowScripts;
    private boolean hasAllowSameOrigin;
    private boolean hasAllowTopNavigation;
    private boolean hasAllowTopNavigationByUserActivation;

    private SandboxAllowList() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        this.hasAllowScripts = false;
        this.hasAllowSameOrigin = false;
        this.hasAllowTopNavigation = false;
        this.hasAllowTopNavigationByUserActivation = false;
        HashSet<String> tokensSeen = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        int len = literal.length();
        for (int i = 0; i < len; ++i) {
            char c = literal.charAt(i);
            if (this.isWhitespace(c) && builder.length() > 0) {
                this.checkToken(literal, builder, i, tokensSeen);
                builder.setLength(0);
                continue;
            }
            if (this.isWhitespace(c)) continue;
            builder.append(SandboxAllowList.toAsciiLowerCase(c));
        }
        if (builder.length() > 0) {
            this.checkToken(literal, builder, len, tokensSeen);
        }
        if (this.hasAllowScripts && this.hasAllowSameOrigin) {
            throw this.newDatatypeException("Setting both \u201callow-scripts\u201d and \u201callow-same-origin\u201d is not recommended, because it effectively enables an embedded page to break out of all sandboxing.", WARN);
        }
        if (this.hasAllowTopNavigation && this.hasAllowTopNavigationByUserActivation) {
            throw this.newDatatypeException("\u201callow-top-navigation-by-user-activation\u201d and \u201callow-top-navigation\u201d must not both be specified at the same time. If both are present, only \u201callow-top-navigation\u201d will have effect.");
        }
    }

    private void checkToken(CharSequence literal, StringBuilder builder, int i, Set<String> tokensSeen) throws DatatypeException {
        String token = builder.toString();
        if (tokensSeen.contains(token)) {
            throw this.newDatatypeException(i - 1, "Duplicate keyword \u201c" + token + "\u201d.");
        }
        tokensSeen.add(token);
        if (!allowedKeywords.contains(token)) {
            throw this.newDatatypeException(i - 1, "The string \u201c" + token + "\u201d is not a valid keyword.");
        }
        if ("allow-scripts".equals(token)) {
            this.hasAllowScripts = true;
        }
        if ("allow-same-origin".equals(token)) {
            this.hasAllowSameOrigin = true;
        }
        if ("allow-top-navigation".equals(token)) {
            this.hasAllowTopNavigation = true;
        }
        if ("allow-top-navigation-by-user-activation".equals(token)) {
            this.hasAllowTopNavigationByUserActivation = true;
        }
    }

    @Override
    public String getName() {
        return "sandbox allow list";
    }

    static {
        allowedKeywords.add("allow-downloads");
        allowedKeywords.add("allow-forms");
        allowedKeywords.add("allow-modals");
        allowedKeywords.add("allow-orientation-lock");
        allowedKeywords.add("allow-pointer-lock");
        allowedKeywords.add("allow-popups");
        allowedKeywords.add("allow-popups-to-escape-sandbox");
        allowedKeywords.add("allow-presentation");
        allowedKeywords.add("allow-same-origin");
        allowedKeywords.add("allow-scripts");
        allowedKeywords.add("allow-top-navigation");
        allowedKeywords.add("allow-top-navigation-by-user-activation");
        allowedKeywords.add("allow-top-navigation-to-custom-protocols");
    }
}

