/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;
import org.apache.commons.text.similarity.LevenshteinDistance;

public final class RelValue
extends AbstractDatatype {
    private static final LevenshteinDistance LEVENSHTEIN = new LevenshteinDistance(3);
    private static final int TYPO_THRESHOLD = 2;
    private static final Set<String> registeredValues = new HashSet<String>(Arrays.asList("about", "acl", "alternate", "amphtml", "api-catalog", "appendix", "apple-touch-icon", "apple-touch-startup-image", "archives", "author", "blocked-by", "bookmark", "c2pa-manifest", "canonical", "chapter", "cite-as", "collection", "compression-dictionary", "contents", "convertedfrom", "copyright", "create-form", "current", "deprecation", "describedby", "describes", "disclosure", "dns-prefetch", "duplicate", "edit", "edit-form", "edit-media", "enclosure", "external", "first", "geofeed", "glossary", "help", "hosts", "hub", "ice-server", "icon", "index", "intervalafter", "intervalbefore", "intervalcontains", "intervaldisjoint", "intervalduring", "intervalequals", "intervalfinishedby", "intervalfinishes", "intervalin", "intervalmeets", "intervalmetby", "intervaloverlappedby", "intervaloverlaps", "intervalstartedby", "intervalstarts", "item", "last", "latest-version", "license", "linkset", "lrdd", "manifest", "mask-icon", "me", "media-feed", "memento", "micropub", "modulepreload", "monitor", "monitor-group", "next", "next-archive", "nofollow", "noopener", "noreferrer", "opener", "openid2.local_id", "openid2.provider", "original", "p3pv1", "payment", "pingback", "preconnect", "predecessor-version", "prefetch", "preload", "prerender", "prev", "prev-archive", "preview", "previous", "privacy-policy", "profile", "publication", "rdap-active", "rdap-bottom", "rdap-down", "rdap-top", "rdap-up", "related", "replies", "restconf", "ruleinput", "search", "section", "self", "service", "service-desc", "service-doc", "service-meta", "sip-trunking-capability", "sponsored", "start", "status", "stylesheet", "subsection", "successor-version", "sunset", "tag", "terms-of-service", "timegate", "timemap", "type", "ugc", "up", "version-history", "via", "webmention", "working-copy", "working-copy-of"));
    public static final RelValue THE_INSTANCE = new RelValue();

    private RelValue() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        HashSet<String> tokensSeen = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        int len = literal.length();
        for (int i = 0; i < len; ++i) {
            char c = literal.charAt(i);
            if (this.isWhitespace(c) && builder.length() > 0) {
                this.checkToken(literal, builder, i, tokensSeen);
                builder.setLength(0);
                continue;
            }
            if (this.isWhitespace(c)) continue;
            builder.append(c);
        }
        if (builder.length() > 0) {
            this.checkToken(literal, builder, len, tokensSeen);
        }
    }

    private void checkToken(CharSequence literal, StringBuilder builder, int i, Set<String> tokensSeen) throws DatatypeException {
        String tokenForValidation;
        String token = builder.toString();
        if (tokensSeen.contains(token)) {
            throw this.newDatatypeException(i - 1, "Duplicate keyword ", token, ".");
        }
        tokensSeen.add(token);
        String string = tokenForValidation = token.startsWith(":") ? token.substring(1) : token;
        if (tokenForValidation.length() <= 3) {
            return;
        }
        if (registeredValues.contains(token.toLowerCase())) {
            return;
        }
        String closestMatch = this.findClosestMatch(tokenForValidation);
        if (closestMatch != null) {
            throw this.newDatatypeException(" Typo for \u201c" + closestMatch + "\u201d?", true);
        }
    }

    private String findClosestMatch(String token) {
        String tokenLower = token.toLowerCase();
        String bestMatch = null;
        int bestDistance = Integer.MAX_VALUE;
        for (String registered : registeredValues) {
            boolean sameEnd;
            int lengthDiff;
            Integer distance;
            String registeredLower = registered.toLowerCase();
            if (registeredLower.length() <= 3 || (distance = LEVENSHTEIN.apply(tokenLower, registeredLower)) == null || distance <= 0 || distance > 2 || (lengthDiff = Math.abs(tokenLower.length() - registeredLower.length())) > 2) continue;
            boolean sameStart = tokenLower.charAt(0) == registeredLower.charAt(0);
            boolean bl = sameEnd = tokenLower.charAt(tokenLower.length() - 1) == registeredLower.charAt(registeredLower.length() - 1);
            if (!sameStart && !sameEnd || distance >= bestDistance) continue;
            bestDistance = distance;
            bestMatch = registered;
        }
        return bestMatch;
    }

    @Override
    public String getName() {
        return "list of link-type keywords";
    }
}

