/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;
import org.htmlunit.csp.Policy;

public class ContentSecurityPolicy
extends AbstractDatatype {
    public static final ContentSecurityPolicy THE_INSTANCE = new ContentSecurityPolicy();
    private static final String DIRECTIVE_NAME = " \\b(child-src|connect-src|default-src|font-src|frame-src|img-src|manifest-src|media-src|object-src|prefetch-src|script-src|style-src|worker-src|allow|options|referrer|report-uri|upgrade-insecure-requests|block-all-mixed-content|report-to)";
    private static final String SANDBOX_KEYWORDS = "(allow-forms|allow-modals|allow-pointer-lock|allow-downloads|allow-orientation-lock|allow-presentation|allow-popups-to-escape-sandbox|allow-popups|allow-same-origin|allow-scripts|allow-top-navigation|allow-top-navigation-by-user-activation|allow-top-navigation-to-custom-protocols)";
    private static final boolean WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");

    protected ContentSecurityPolicy() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        StringBuilder errors = new StringBuilder();
        StringBuilder warnings = new StringBuilder();
        StringBuilder others = new StringBuilder();
        String policyText = literal.toString().replace("allow-downloads", "").replace("allow-presentation", "");
        try {
            if (policyText.contains(",")) {
                Policy.parseSerializedCSPList(policyText, (severity, message, policyIndex, directiveIndex, valueIndex) -> {
                    if (message.contains("experimental directive")) {
                        return;
                    }
                    String formattedMessage = message.replaceAll(SANDBOX_KEYWORDS, "\u201c$1\u201d").replaceAll(DIRECTIVE_NAME, " \u201c$1\u201d ") + " ";
                    switch (severity) {
                        case Error: {
                            errors.append(formattedMessage);
                            break;
                        }
                        case Warning: {
                            warnings.append(formattedMessage);
                            break;
                        }
                        case Info: {
                            others.append(formattedMessage);
                        }
                    }
                });
            } else {
                Policy.parseSerializedCSP(policyText, (severity, message, directiveIndex, valueIndex) -> {
                    if (message.contains("experimental directive")) {
                        return;
                    }
                    String formattedMessage = message.replaceAll(SANDBOX_KEYWORDS, "\u201c$1\u201d").replaceAll(DIRECTIVE_NAME, " \u201c$1\u201d ") + " ";
                    switch (severity) {
                        case Error: {
                            errors.append(formattedMessage);
                            break;
                        }
                        case Warning: {
                            warnings.append(formattedMessage);
                            break;
                        }
                        case Info: {
                            others.append(formattedMessage);
                        }
                    }
                });
            }
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("string is not ascii")) {
                throw this.newDatatypeException("Content Security Policy must contain only ASCII characters.");
            }
            throw this.newDatatypeException(e.getMessage());
        }
        if (errors.length() > 0) {
            throw this.newDatatypeException(errors.toString());
        }
        if (warnings.length() > 0) {
            throw this.newDatatypeException(warnings.toString(), WARN);
        }
        if (others.length() > 0) {
            throw this.newDatatypeException(others.toString(), WARN);
        }
    }

    @Override
    public String getName() {
        return "content security policy";
    }
}

