/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.test;

import java.util.ArrayList;
import java.util.List;
import nu.validator.checker.SpeculationRulesChecker;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class SpeculationRulesCheckerTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) throws Exception {
        System.out.println("Testing valid speculation rules...");
        SpeculationRulesCheckerTest.testValidListRule();
        SpeculationRulesCheckerTest.testValidDocumentRule();
        SpeculationRulesCheckerTest.testValidBothTypes();
        SpeculationRulesCheckerTest.testValidWithEagerness();
        SpeculationRulesCheckerTest.testValidNestedPredicates();
        SpeculationRulesCheckerTest.testValidInferredSourceFromUrls();
        SpeculationRulesCheckerTest.testValidInferredSourceFromWhere();
        System.out.println();
        System.out.println("Testing invalid speculation rules...");
        SpeculationRulesCheckerTest.testInvalidJson();
        SpeculationRulesCheckerTest.testNotJsonObject();
        SpeculationRulesCheckerTest.testMissingPrefetchOrPrerender();
        SpeculationRulesCheckerTest.testInvalidProperty();
        SpeculationRulesCheckerTest.testInvalidSourceValue();
        SpeculationRulesCheckerTest.testListRuleMissingUrls();
        SpeculationRulesCheckerTest.testDocumentRuleMissingWhere();
        SpeculationRulesCheckerTest.testListRuleWithWhere();
        SpeculationRulesCheckerTest.testDocumentRuleWithUrls();
        SpeculationRulesCheckerTest.testInvalidEagerness();
        SpeculationRulesCheckerTest.testEmptyUrlsArray();
        SpeculationRulesCheckerTest.testMissingSourceAndUrlsAndWhere();
        System.out.println();
        System.out.println("Testing document rule predicates...");
        SpeculationRulesCheckerTest.testEmptyPredicate();
        SpeculationRulesCheckerTest.testMultiplePredicates();
        SpeculationRulesCheckerTest.testEmptyAndArray();
        SpeculationRulesCheckerTest.testHrefMatchesNotString();
        SpeculationRulesCheckerTest.testSelectorMatchesEmpty();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testValidListRule() throws Exception {
        String json = "{\"prefetch\": [{\"source\": \"list\", \"urls\": [\"/page1.html\"]}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertTrue("Valid list rule: no errors", errors.isEmpty());
    }

    private static void testValidDocumentRule() throws Exception {
        String json = "{\"prerender\": [{\"source\": \"document\", \"where\": {\"href_matches\": \"/*\"}}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertTrue("Valid document rule: no errors", errors.isEmpty());
    }

    private static void testValidBothTypes() throws Exception {
        String json = "{\"prefetch\": [{\"source\": \"list\", \"urls\": [\"/a.html\"]}],\"prerender\": [{\"source\": \"list\", \"urls\": [\"/b.html\"]}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertTrue("Valid both types: no errors", errors.isEmpty());
    }

    private static void testValidWithEagerness() throws Exception {
        String json = "{\"prefetch\": [{\"source\": \"list\", \"urls\": [\"/page.html\"], \"eagerness\": \"moderate\"}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertTrue("Valid with eagerness: no errors", errors.isEmpty());
    }

    private static void testValidNestedPredicates() throws Exception {
        String json = "{\"prerender\": [{\"source\": \"document\", \"where\": {\"and\": [{\"href_matches\": \"/*\"}, {\"not\": {\"selector_matches\": \".no-prerender\"}}]}}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertTrue("Valid nested predicates: no errors", errors.isEmpty());
    }

    private static void testValidInferredSourceFromUrls() throws Exception {
        String json = "{\"prefetch\": [{\"urls\": [\"/page.html\"]}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertTrue("Valid inferred source from urls: no errors", errors.isEmpty());
    }

    private static void testValidInferredSourceFromWhere() throws Exception {
        String json = "{\"prerender\": [{\"where\": {\"href_matches\": \"/*\"}}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertTrue("Valid inferred source from where: no errors", errors.isEmpty());
    }

    private static void testInvalidJson() throws Exception {
        String json = "not valid json";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Invalid JSON: error about valid JSON", errors, "valid JSON");
    }

    private static void testNotJsonObject() throws Exception {
        String json = "[1, 2, 3]";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Not JSON object: error about JSON object", errors, "JSON object");
    }

    private static void testMissingPrefetchOrPrerender() throws Exception {
        String json = "{}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Missing prefetch/prerender: error about properties", errors, "prefetch");
    }

    private static void testInvalidProperty() throws Exception {
        String json = "{\"prefetch\": [], \"unknown\": true}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Invalid property: error about only prefetch/prerender", errors, "only");
    }

    private static void testInvalidSourceValue() throws Exception {
        String json = "{\"prefetch\": [{\"source\": \"invalid\", \"urls\": [\"/page.html\"]}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Invalid source value: error about list or document", errors, "list");
    }

    private static void testListRuleMissingUrls() throws Exception {
        String json = "{\"prefetch\": [{\"source\": \"list\"}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("List rule missing urls: error about urls property", errors, "urls");
    }

    private static void testDocumentRuleMissingWhere() throws Exception {
        String json = "{\"prerender\": [{\"source\": \"document\"}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Document rule missing where: error about where property", errors, "where");
    }

    private static void testListRuleWithWhere() throws Exception {
        String json = "{\"prefetch\": [{\"source\": \"list\", \"urls\": [\"/a.html\"], \"where\": {}}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("List rule with where: error about where not allowed", errors, "where");
    }

    private static void testDocumentRuleWithUrls() throws Exception {
        String json = "{\"prerender\": [{\"source\": \"document\", \"where\": {\"href_matches\": \"/*\"}, \"urls\": []}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Document rule with urls: error about urls not allowed", errors, "urls");
    }

    private static void testInvalidEagerness() throws Exception {
        String json = "{\"prefetch\": [{\"source\": \"list\", \"urls\": [\"/a.html\"], \"eagerness\": \"invalid\"}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Invalid eagerness: error about valid values", errors, "eager");
    }

    private static void testEmptyUrlsArray() throws Exception {
        String json = "{\"prefetch\": [{\"source\": \"list\", \"urls\": []}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Empty urls array: error about at least one URL", errors, "at least one");
    }

    private static void testMissingSourceAndUrlsAndWhere() throws Exception {
        String json = "{\"prefetch\": [{}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Missing source, urls, where: error", errors, "source");
    }

    private static void testEmptyPredicate() throws Exception {
        String json = "{\"prerender\": [{\"source\": \"document\", \"where\": {}}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Empty predicate: error about predicate properties", errors, "predicate");
    }

    private static void testMultiplePredicates() throws Exception {
        String json = "{\"prerender\": [{\"source\": \"document\", \"where\": {\"href_matches\": \"/*\", \"selector_matches\": \"a\"}}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Multiple predicates: error about only one", errors, "only one");
    }

    private static void testEmptyAndArray() throws Exception {
        String json = "{\"prerender\": [{\"source\": \"document\", \"where\": {\"and\": []}}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("Empty and array: error about at least one item", errors, "at least one");
    }

    private static void testHrefMatchesNotString() throws Exception {
        String json = "{\"prerender\": [{\"source\": \"document\", \"where\": {\"href_matches\": 123}}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("href_matches not string: error about string", errors, "string");
    }

    private static void testSelectorMatchesEmpty() throws Exception {
        String json = "{\"prerender\": [{\"source\": \"document\", \"where\": {\"selector_matches\": \"\"}}]}";
        List<String> errors = SpeculationRulesCheckerTest.validateSpeculationRules(json);
        SpeculationRulesCheckerTest.assertContains("selector_matches empty: error about non-empty", errors, "non-empty");
    }

    private static List<String> validateSpeculationRules(String json) throws SAXException {
        SpeculationRulesChecker checker = new SpeculationRulesChecker();
        TestErrorHandler errorHandler = new TestErrorHandler();
        checker.setErrorHandler(errorHandler);
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "type", "CDATA", "speculationrules");
        checker.startElement("http://www.w3.org/1999/xhtml", "script", "script", atts);
        checker.characters(json.toCharArray(), 0, json.length());
        checker.endElement("http://www.w3.org/1999/xhtml", "script", "script");
        return errorHandler.getErrors();
    }

    private static void assertTrue(String testName, boolean condition) {
        if (condition) {
            SpeculationRulesCheckerTest.pass(testName);
        } else {
            SpeculationRulesCheckerTest.fail(testName);
        }
    }

    private static void assertContains(String testName, List<String> errors, String substring) {
        boolean found = false;
        for (String error : errors) {
            if (!error.toLowerCase().contains(substring.toLowerCase())) continue;
            found = true;
            break;
        }
        if (found) {
            SpeculationRulesCheckerTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected error containing: " + substring);
            System.out.println("  Actual errors: " + String.valueOf(errors));
            ++failed;
        }
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }

    private static void fail(String testName) {
        System.out.println("FAIL: " + testName);
        ++failed;
    }

    private static class TestErrorHandler
    implements ErrorHandler {
        private final List<String> errors = new ArrayList<String>();

        private TestErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) {
            this.errors.add(exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) {
            this.errors.add(exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.errors.add(exception.getMessage());
        }

        public List<String> getErrors() {
            return this.errors;
        }
    }
}

