/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.stream.Collectors;
import nu.validator.checker.NormalizationChecker;
import org.xml.sax.SAXException;

public class NormalizationCheckerTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        System.out.println("Testing startsWithComposingChar...");
        NormalizationCheckerTest.testEmptyString();
        NormalizationCheckerTest.testAsciiCharacters();
        NormalizationCheckerTest.testNonAsciiBaseCharacters();
        NormalizationCheckerTest.testCombiningCharacters();
        NormalizationCheckerTest.testSurrogatePairs();
        NormalizationCheckerTest.testMalformedSurrogates();
        NormalizationCheckerTest.testBytecodeUsesStandardJavaCharacterClass();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testEmptyString() {
        NormalizationCheckerTest.assertFalse("empty string", "");
    }

    private static void testAsciiCharacters() {
        NormalizationCheckerTest.assertFalse("ASCII letter 'a'", "a");
        NormalizationCheckerTest.assertFalse("ASCII letter 'Z'", "Z");
        NormalizationCheckerTest.assertFalse("ASCII digit '0'", "0");
        NormalizationCheckerTest.assertFalse("ASCII space", " ");
        NormalizationCheckerTest.assertFalse("ASCII punctuation", "!");
        NormalizationCheckerTest.assertFalse("ASCII word", "hello");
    }

    private static void testNonAsciiBaseCharacters() {
        NormalizationCheckerTest.assertFalse("Latin e-acute (precomposed)", "\u00e9");
        NormalizationCheckerTest.assertFalse("Greek alpha", "\u03b1");
        NormalizationCheckerTest.assertFalse("Cyrillic a", "\u0430");
        NormalizationCheckerTest.assertFalse("CJK character", "\u4e00");
        NormalizationCheckerTest.assertFalse("Arabic alef", "\u0627");
        NormalizationCheckerTest.assertFalse("Hebrew aleph", "\u05d0");
        NormalizationCheckerTest.assertFalse("Thai ko kai", "\u0e01");
        NormalizationCheckerTest.assertFalse("Devanagari ka", "\u0915");
    }

    private static void testCombiningCharacters() {
        NormalizationCheckerTest.assertTrue("Combining acute accent (U+0301)", "\u0301");
        NormalizationCheckerTest.assertTrue("Combining grave accent (U+0300)", "\u0300");
        NormalizationCheckerTest.assertTrue("Combining diaeresis (U+0308)", "\u0308");
        NormalizationCheckerTest.assertTrue("Combining tilde (U+0303)", "\u0303");
        NormalizationCheckerTest.assertTrue("Combining cedilla (U+0327)", "\u0327");
        NormalizationCheckerTest.assertTrue("Combining macron (U+0304)", "\u0304");
        NormalizationCheckerTest.assertTrue("Combining acute then 'a'", "\u0301a");
        NormalizationCheckerTest.assertTrue("Combining diaeresis then text", "\u0308hello");
        NormalizationCheckerTest.assertTrue("Hebrew point patah (U+05B7)", "\u05b7");
        NormalizationCheckerTest.assertTrue("Arabic fathah (U+064E)", "\u064e");
    }

    private static void testSurrogatePairs() {
        NormalizationCheckerTest.assertTrue("Musical combining stem", "\ud834\udd65");
        NormalizationCheckerTest.assertTrue("Musical combining augmentation dot", "\ud834\udd6d");
        NormalizationCheckerTest.assertFalse("Emoji grinning face", "\ud83d\ude00");
        NormalizationCheckerTest.assertFalse("Linear B syllable", "\ud800\udc00");
    }

    private static void testMalformedSurrogates() {
        NormalizationCheckerTest.assertThrowsSAXException("Lone high surrogate", "\ud800");
        NormalizationCheckerTest.assertThrowsSAXException("High surrogate + non-surrogate", "\ud800a");
    }

    private static void testBytecodeUsesStandardJavaCharacterClass() {
        String classPath;
        try {
            Process checkJavap = Runtime.getRuntime().exec(new String[]{"javap", "-version"});
            checkJavap.waitFor();
            if (checkJavap.exitValue() != 0) {
                System.out.println("SKIP: Bytecode check (javap not available)");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("SKIP: Bytecode check (javap not available)");
            return;
        }
        URL classUrl = NormalizationChecker.class.getResource("NormalizationChecker.class");
        if (classUrl == null) {
            System.out.println("SKIP: Bytecode check (cannot locate class file)");
            return;
        }
        if ("jar".equals(classUrl.getProtocol())) {
            String jarPath = classUrl.getPath();
            int bangIndex = jarPath.indexOf(33);
            if (bangIndex > 0) {
                jarPath = jarPath.substring(0, bangIndex);
            }
            if (jarPath.startsWith("file:")) {
                jarPath = jarPath.substring(5);
            }
            classPath = jarPath;
        } else {
            classPath = classUrl.getPath();
            String className = NormalizationChecker.class.getName();
            int levels = className.split("\\.").length;
            for (int i = 0; i < levels; ++i) {
                classPath = classPath.substring(0, classPath.lastIndexOf(47));
            }
        }
        try {
            String output;
            Process javap = Runtime.getRuntime().exec(new String[]{"javap", "-c", "-classpath", classPath, "nu.validator.checker.NormalizationChecker"});
            javap.waitFor();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(javap.getInputStream()));){
                output = reader.lines().collect(Collectors.joining("\n"));
            }
            boolean usesJavaCharacter = output.contains("java/lang/Character.isHighSurrogate");
            boolean usesIcuUCharacter = output.contains("com/ibm/icu/lang/UCharacter.isHighSurrogate");
            if (usesJavaCharacter && !usesIcuUCharacter) {
                NormalizationCheckerTest.pass("Bytecode uses java.lang.Character (not ICU4J UCharacter)");
            } else if (usesIcuUCharacter) {
                System.out.println("FAIL: Bytecode uses ICU4J UCharacter");
                System.out.println("  The code should use java.lang.Character to avoid ICU4J version compatibility issues.");
                System.out.println("  See: https://github.com/validator/validator/issues/1504");
                ++failed;
            } else {
                System.out.println("SKIP: Bytecode check (no surrogate method calls found)");
            }
        }
        catch (Exception e) {
            System.out.println("SKIP: Bytecode check (javap failed: " + e.getMessage() + ")");
        }
    }

    private static void assertTrue(String testName, String input) {
        try {
            boolean result = NormalizationChecker.startsWithComposingChar(input);
            if (result) {
                NormalizationCheckerTest.pass("startsWithComposingChar: " + testName);
            } else {
                System.out.println("FAIL: startsWithComposingChar: " + testName);
                System.out.println("  Expected: true");
                System.out.println("  Actual: false");
                ++failed;
            }
        }
        catch (SAXException e) {
            System.out.println("FAIL: startsWithComposingChar: " + testName);
            System.out.println("  Expected: true");
            System.out.println("  Got exception: " + e.getMessage());
            ++failed;
        }
    }

    private static void assertFalse(String testName, String input) {
        try {
            boolean result = NormalizationChecker.startsWithComposingChar(input);
            if (!result) {
                NormalizationCheckerTest.pass("startsWithComposingChar: " + testName);
            } else {
                System.out.println("FAIL: startsWithComposingChar: " + testName);
                System.out.println("  Expected: false");
                System.out.println("  Actual: true");
                ++failed;
            }
        }
        catch (SAXException e) {
            System.out.println("FAIL: startsWithComposingChar: " + testName);
            System.out.println("  Expected: false");
            System.out.println("  Got exception: " + e.getMessage());
            ++failed;
        }
    }

    private static void assertThrowsSAXException(String testName, String input) {
        try {
            NormalizationChecker.startsWithComposingChar(input);
            System.out.println("FAIL: startsWithComposingChar: " + testName);
            System.out.println("  Expected: SAXException");
            System.out.println("  Got: no exception");
            ++failed;
        }
        catch (SAXException e) {
            NormalizationCheckerTest.pass("startsWithComposingChar: " + testName + " (throws SAXException)");
        }
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }
}

