/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.test;

import nu.validator.checker.LocatorImpl;
import nu.validator.checker.TaintableLocatorImpl;
import org.xml.sax.Locator;

public class LocatorImplTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        System.out.println("Testing LocatorImpl...");
        LocatorImplTest.testLocatorImplBasic();
        LocatorImplTest.testLocatorImplWithNulls();
        System.out.println();
        System.out.println("Testing TaintableLocatorImpl...");
        LocatorImplTest.testTaintableLocatorImplBasic();
        LocatorImplTest.testTaintableLocatorImplTaintBehavior();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testLocatorImplBasic() {
        MockLocator source = new MockLocator("file:///test.html", "public-id", 10, 25);
        LocatorImpl locator = new LocatorImpl(source);
        LocatorImplTest.assertEquals("LocatorImpl: getSystemId", "file:///test.html", locator.getSystemId());
        LocatorImplTest.assertEquals("LocatorImpl: getPublicId", "public-id", locator.getPublicId());
        LocatorImplTest.assertEquals("LocatorImpl: getLineNumber", 10, locator.getLineNumber());
        LocatorImplTest.assertEquals("LocatorImpl: getColumnNumber", 25, locator.getColumnNumber());
    }

    private static void testLocatorImplWithNulls() {
        MockLocator source = new MockLocator(null, null, -1, -1);
        LocatorImpl locator = new LocatorImpl(source);
        LocatorImplTest.assertNull("LocatorImpl: null systemId", locator.getSystemId());
        LocatorImplTest.assertNull("LocatorImpl: null publicId", locator.getPublicId());
        LocatorImplTest.assertEquals("LocatorImpl: line -1", -1, locator.getLineNumber());
        LocatorImplTest.assertEquals("LocatorImpl: column -1", -1, locator.getColumnNumber());
    }

    private static void testTaintableLocatorImplBasic() {
        MockLocator source = new MockLocator("file:///test.html", "public-id", 5, 15);
        TaintableLocatorImpl locator = new TaintableLocatorImpl(source);
        LocatorImplTest.assertEquals("TaintableLocatorImpl: getSystemId", "file:///test.html", locator.getSystemId());
        LocatorImplTest.assertEquals("TaintableLocatorImpl: getPublicId", "public-id", locator.getPublicId());
        LocatorImplTest.assertEquals("TaintableLocatorImpl: getLineNumber", 5, locator.getLineNumber());
        LocatorImplTest.assertEquals("TaintableLocatorImpl: getColumnNumber", 15, locator.getColumnNumber());
    }

    private static void testTaintableLocatorImplTaintBehavior() {
        MockLocator source = new MockLocator("file:///test.html", null, 1, 1);
        TaintableLocatorImpl locator = new TaintableLocatorImpl(source);
        LocatorImplTest.assertFalse("TaintableLocatorImpl: initially not tainted", locator.isTainted());
        locator.markTainted();
        LocatorImplTest.assertTrue("TaintableLocatorImpl: tainted after markTainted()", locator.isTainted());
        locator.markTainted();
        LocatorImplTest.assertTrue("TaintableLocatorImpl: still tainted after second markTainted()", locator.isTainted());
    }

    private static void assertEquals(String testName, String expected, String actual) {
        if (expected == null && actual == null || expected != null && expected.equals(actual)) {
            LocatorImplTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: " + expected);
            System.out.println("  Actual: " + actual);
            ++failed;
        }
    }

    private static void assertEquals(String testName, int expected, int actual) {
        if (expected == actual) {
            LocatorImplTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: " + expected);
            System.out.println("  Actual: " + actual);
            ++failed;
        }
    }

    private static void assertNull(String testName, Object value) {
        if (value == null) {
            LocatorImplTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: null");
            System.out.println("  Actual: " + String.valueOf(value));
            ++failed;
        }
    }

    private static void assertTrue(String testName, boolean condition) {
        if (condition) {
            LocatorImplTest.pass(testName);
        } else {
            LocatorImplTest.fail(testName);
        }
    }

    private static void assertFalse(String testName, boolean condition) {
        LocatorImplTest.assertTrue(testName, !condition);
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }

    private static void fail(String testName) {
        System.out.println("FAIL: " + testName);
        ++failed;
    }

    private static class MockLocator
    implements Locator {
        private final String systemId;
        private final String publicId;
        private final int lineNumber;
        private final int columnNumber;

        MockLocator(String systemId, String publicId, int lineNumber, int columnNumber) {
            this.systemId = systemId;
            this.publicId = publicId;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getColumnNumber() {
            return this.columnNumber;
        }
    }
}

