/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import nu.validator.checker.Checker;
import nu.validator.checker.LocatorImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HeadingHierarchyChecker
extends Checker {
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";
    private Locator locator;
    private Deque<AncestorInfo> ancestorStack;
    private List<HeadingInfo> headings;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.ancestorStack = new ArrayDeque<AncestorInfo>();
        this.headings = new ArrayList<HeadingInfo>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (HTML_NS != uri) {
            this.ancestorStack.push(new AncestorInfo(0, false));
            return;
        }
        int headingOffset = 0;
        String offsetValue = atts.getValue("", "headingoffset");
        if (offsetValue != null) {
            headingOffset = HeadingHierarchyChecker.parseNonNegativeInteger(offsetValue);
        }
        boolean headingReset = atts.getIndex("", "headingreset") >= 0;
        this.ancestorStack.push(new AncestorInfo(headingOffset, headingReset));
        if (HeadingHierarchyChecker.isHeadingElement(localName)) {
            int baseLevel = localName.charAt(1) - 48;
            int computedLevel = this.computeHeadingLevel(baseLevel);
            this.headings.add(new HeadingInfo(computedLevel, localName, new LocatorImpl(this.locator)));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.ancestorStack.isEmpty()) {
            this.ancestorStack.pop();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.headings.isEmpty()) {
            return;
        }
        HeadingInfo previousHeading = null;
        for (HeadingInfo heading : this.headings) {
            int prevLevel;
            int currLevel;
            if (previousHeading != null && (currLevel = heading.computedLevel) > (prevLevel = previousHeading.computedLevel) + 1) {
                this.err("The heading \u201c" + heading.elementName + "\u201d (with computed level " + currLevel + ") follows the heading \u201c" + previousHeading.elementName + "\u201d (with computed level " + prevLevel + "), skipping " + (currLevel - prevLevel - 1) + " heading level" + (currLevel - prevLevel - 1 > 1 ? "s" : "") + ".", heading.locator);
            }
            previousHeading = heading;
        }
    }

    @Override
    public void reset() {
        this.ancestorStack = null;
        this.headings = null;
    }

    private static boolean isHeadingElement(String localName) {
        return "h1" == localName || "h2" == localName || "h3" == localName || "h4" == localName || "h5" == localName || "h6" == localName;
    }

    private static int parseNonNegativeInteger(String value) {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        try {
            int result = Integer.parseInt(value.trim());
            return result >= 0 ? result : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private int computeHeadingOffset() {
        int offset = 0;
        for (AncestorInfo ancestor : this.ancestorStack) {
            offset += ancestor.headingOffset;
            if (!ancestor.headingReset) continue;
            break;
        }
        return offset;
    }

    private int computeHeadingLevel(int baseLevel) {
        int level = baseLevel + this.computeHeadingOffset();
        return level > 9 ? 9 : level;
    }

    private static class AncestorInfo {
        final int headingOffset;
        final boolean headingReset;

        AncestorInfo(int headingOffset, boolean headingReset) {
            this.headingOffset = headingOffset;
            this.headingReset = headingReset;
        }
    }

    private static class HeadingInfo {
        final int computedLevel;
        final String elementName;
        final Locator locator;

        HeadingInfo(int computedLevel, String elementName, Locator locator) {
            this.computedLevel = computedLevel;
            this.elementName = elementName;
            this.locator = locator;
        }
    }
}

