/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import nu.validator.checker.Checker;
import nu.validator.checker.LocatorImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DuplicateDtChecker
extends Checker {
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";
    private final LinkedList<Map<String, Locator>> dlStack = new LinkedList();
    private final LinkedList<StringBuilder> dtTextStack = new LinkedList();
    private final LinkedList<Locator> dtLocatorStack = new LinkedList();
    private boolean inDt = false;
    private Locator locator = null;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (HTML_NS.equals(uri)) {
            if ("dl".equals(localName)) {
                this.dlStack.addLast(new HashMap());
            } else if ("dt".equals(localName) && !this.dlStack.isEmpty()) {
                this.inDt = true;
                this.dtTextStack.addLast(new StringBuilder());
                this.dtLocatorStack.addLast(new LocatorImpl(this.locator));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (HTML_NS.equals(uri)) {
            if ("dl".equals(localName) && !this.dlStack.isEmpty()) {
                this.dlStack.removeLast();
            } else if ("dt".equals(localName) && this.inDt) {
                this.inDt = false;
                if (!this.dtTextStack.isEmpty() && !this.dtLocatorStack.isEmpty()) {
                    String dtText = this.dtTextStack.removeLast().toString().trim();
                    Locator dtLocator = this.dtLocatorStack.removeLast();
                    if (!dtText.isEmpty() && !this.dlStack.isEmpty()) {
                        Map<String, Locator> dtNames = this.dlStack.getLast();
                        Locator firstOccurrence = dtNames.get(dtText);
                        if (firstOccurrence == null) {
                            dtNames.put(dtText, dtLocator);
                        } else {
                            this.warn("Duplicate \u201cdt\u201d name \u201c" + dtText + "\u201d in \u201cdl\u201d element. Within a single \u201cdl\u201d element, there should not be more than one \u201cdt\u201d element for each name.", dtLocator);
                            this.info("The first occurrence of \u201cdt\u201d name \u201c" + dtText + "\u201d was here.", firstOccurrence);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inDt && !this.dtTextStack.isEmpty()) {
            this.dtTextStack.getLast().append(ch, start, length);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.dlStack.clear();
        this.dtTextStack.clear();
        this.dtLocatorStack.clear();
        this.inDt = false;
    }

    @Override
    public void endDocument() throws SAXException {
        this.dlStack.clear();
        this.dtTextStack.clear();
        this.dtLocatorStack.clear();
        this.inDt = false;
    }

    @Override
    public void reset() {
        this.dlStack.clear();
        this.dtTextStack.clear();
        this.dtLocatorStack.clear();
        this.inDt = false;
    }
}

