/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import com.ibm.icu.text.IDNA;
import io.mola.galimatias.DefaultErrorHandler;
import io.mola.galimatias.ErrorHandler;
import io.mola.galimatias.GalimatiasParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class URLUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final IDNA idna = IDNA.getUTS46Instance(0);
    private static final char[] _hex = "0123456789ABCDEF".toCharArray();
    private static final List<String> RELATIVE_SCHEMES = Arrays.asList("ftp", "file", "http", "https", "ws", "wss");

    private URLUtils() {
    }

    public static String percentDecode(String input) {
        if (input.isEmpty()) {
            return input;
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            int idx = 0;
            while (idx < input.length()) {
                int c;
                boolean isEOF = idx >= input.length();
                int n = c = isEOF ? 0 : input.codePointAt(idx);
                while (!isEOF && c != 37) {
                    if (c <= 127) {
                        bytes.write((byte)c);
                        ++idx;
                    } else {
                        bytes.write(new String(Character.toChars(c)).getBytes(UTF_8));
                        idx += Character.charCount(c);
                    }
                    isEOF = idx >= input.length();
                    c = isEOF ? 0 : input.codePointAt(idx);
                }
                if (!(c != 37 || input.length() > idx + 2 && URLUtils.isASCIIHexDigit(input.charAt(idx + 1)) && URLUtils.isASCIIHexDigit(input.charAt(idx + 2)))) {
                    if (c <= 127) {
                        bytes.write((byte)c);
                        ++idx;
                        continue;
                    }
                    bytes.write(new String(Character.toChars(c)).getBytes(UTF_8));
                    idx += Character.charCount(c);
                    continue;
                }
                while (c == 37 && input.length() > idx + 2 && URLUtils.isASCIIHexDigit(input.charAt(idx + 1)) && URLUtils.isASCIIHexDigit(input.charAt(idx + 2))) {
                    bytes.write(URLUtils.hexToInt(input.charAt(idx + 1), input.charAt(idx + 2)));
                    c = input.length() <= (idx += 3) ? 0 : input.codePointAt(idx);
                }
            }
            return new String(bytes.toByteArray(), UTF_8);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String domainToASCII(String domain) throws GalimatiasParseException {
        return URLUtils.domainToASCII(domain, DefaultErrorHandler.getInstance());
    }

    static String domainToASCII(String domain, ErrorHandler errorHandler) throws GalimatiasParseException {
        IDNA.Info idnaInfo = new IDNA.Info();
        StringBuilder idnaOutput = new StringBuilder();
        idna.nameToASCII(domain, idnaOutput, idnaInfo);
        URLUtils.processIdnaInfo(errorHandler, idnaInfo, false);
        return idnaOutput.toString();
    }

    public static String domainToUnicode(String asciiDomain) throws GalimatiasParseException {
        return URLUtils.domainToUnicode(asciiDomain, DefaultErrorHandler.getInstance());
    }

    static String domainToUnicode(String asciiDomain, ErrorHandler errorHandler) throws GalimatiasParseException {
        IDNA.Info unicodeIdnaInfo = new IDNA.Info();
        StringBuilder unicodeIdnaOutput = new StringBuilder();
        idna.nameToUnicode(asciiDomain, unicodeIdnaOutput, unicodeIdnaInfo);
        URLUtils.processIdnaInfo(errorHandler, unicodeIdnaInfo, false);
        return unicodeIdnaOutput.toString();
    }

    private static void processIdnaInfo(ErrorHandler errorHandler, IDNA.Info idnaInfo, boolean checkHyphens) throws GalimatiasParseException {
        Iterator<IDNA.Error> iterator = idnaInfo.getErrors().iterator();
        if (iterator.hasNext()) {
            String msg;
            IDNA.Error error = iterator.next();
            switch (error) {
                case BIDI: {
                    msg = "A label does not meet the IDNA BiDi requirements (for right-to-left characters).";
                    break;
                }
                case CONTEXTJ: {
                    msg = "A label does not meet the IDNA CONTEXTJ requirements.";
                    break;
                }
                case CONTEXTO_DIGITS: {
                    msg = "A label does not meet the IDNA CONTEXTO requirements for digits.";
                    break;
                }
                case CONTEXTO_PUNCTUATION: {
                    msg = "A label does not meet the IDNA CONTEXTO requirements for punctuation characters.";
                    break;
                }
                case DISALLOWED: {
                    msg = "A label or domain name contains disallowed characters.";
                    break;
                }
                case DOMAIN_NAME_TOO_LONG: {
                    msg = "A domain name is longer than 255 bytes in its storage form.";
                    break;
                }
                case EMPTY_LABEL: {
                    msg = "A non-final domain name label (or the whole domain name) is empty.";
                    break;
                }
                case HYPHEN_3_4: {
                    if (!checkHyphens) {
                        return;
                    }
                    msg = "A label contains hyphen-minus ('-') in the third and fourth positions.";
                    break;
                }
                case INVALID_ACE_LABEL: {
                    msg = "An ACE label does not contain a valid label string.";
                    break;
                }
                case LABEL_HAS_DOT: {
                    msg = "A label contains a dot=full stop.";
                    break;
                }
                case LABEL_TOO_LONG: {
                    msg = "A domain name label is longer than 63 bytes.";
                    break;
                }
                case LEADING_COMBINING_MARK: {
                    msg = "A label starts with a combining mark.";
                    break;
                }
                case LEADING_HYPHEN: {
                    if (!checkHyphens) {
                        return;
                    }
                    msg = "A label starts with a hyphen-minus ('-').";
                    break;
                }
                case PUNYCODE: {
                    msg = "A label starts with \"xn--\" but does not contain valid Punycode.";
                    break;
                }
                case TRAILING_HYPHEN: {
                    if (!checkHyphens) {
                        return;
                    }
                    msg = "A label ends with a hyphen-minus ('-').";
                    break;
                }
                default: {
                    msg = "IDNA error.";
                }
            }
            GalimatiasParseException exception = new GalimatiasParseException(msg);
            errorHandler.fatalError(exception);
            throw exception;
        }
    }

    public static boolean isASCIIHexDigit(int c) {
        return c >= 65 && c <= 70 || c >= 97 && c <= 102 || URLUtils.isASCIIDigit(c);
    }

    public static boolean isASCIIDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isASCIIAlphaUppercase(int c) {
        return c >= 97 && c <= 122;
    }

    public static boolean isASCIIAlphaLowercase(int c) {
        return c >= 65 && c <= 90;
    }

    public static boolean isASCIIAlpha(int c) {
        return URLUtils.isASCIIAlphaLowercase(c) || URLUtils.isASCIIAlphaUppercase(c);
    }

    public static boolean isASCIIAlphanumeric(int c) {
        return URLUtils.isASCIIAlpha(c) || URLUtils.isASCIIDigit(c);
    }

    public static boolean isURLCodePoint(int c) {
        return URLUtils.isASCIIAlphanumeric(c) || c == 33 || c == 36 || c == 38 || c == 39 || c == 40 || c == 41 || c == 42 || c == 43 || c == 44 || c == 45 || c == 46 || c == 47 || c == 58 || c == 59 || c == 61 || c == 63 || c == 64 || c == 95 || c == 126 || c >= 160 && c <= 55295 || c >= 57344 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 65536 && c <= 131069 || c >= 131072 && c <= 196605 || c >= 196608 && c <= 262141 || c >= 262144 && c <= 327677 || c >= 327680 && c <= 393213 || c >= 393216 && c <= 458749 || c >= 458752 && c <= 524285 || c >= 524288 && c <= 589821 || c >= 589824 && c <= 655357 || c >= 655360 && c <= 720893 || c >= 720896 && c <= 786429 || c >= 786432 && c <= 851965 || c >= 851968 && c <= 917501 || c >= 917504 && c <= 983037 || c >= 983040 && c <= 1048573 || c >= 0x100000 && c <= 1114109;
    }

    static void byteToHex(byte b, StringBuilder buffer) {
        int i = b & 0xFF;
        buffer.append(_hex[i >>> 4]);
        buffer.append(_hex[i & 0xF]);
    }

    public static int hexToInt(char c1, char c2) {
        return Integer.parseInt(new String(new char[]{c1, c2}), 16);
    }

    public static void percentEncode(byte b, StringBuilder buffer) {
        buffer.append('%');
        URLUtils.byteToHex(b, buffer);
    }

    public static boolean isRelativeScheme(String scheme) {
        return RELATIVE_SCHEMES.contains(scheme);
    }

    public static String getDefaultPortForScheme(String scheme) {
        if ("ftp".equals(scheme)) {
            return "21";
        }
        if ("file".equals(scheme)) {
            return null;
        }
        if ("gopher".equals(scheme)) {
            return "70";
        }
        if ("http".equals(scheme)) {
            return "80";
        }
        if ("https".equals(scheme)) {
            return "443";
        }
        if ("ws".equals(scheme)) {
            return "80";
        }
        if ("wss".equals(scheme)) {
            return "443";
        }
        return null;
    }
}

