/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.zip.CRC32;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class UpdateTracking {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String ELEMENT_MODULES = "installed_modules";
    public static final String ELEMENT_MODULE = "module";
    public static final String ATTR_CODENAMEBASE = "codename";
    public static final String ELEMENT_VERSION = "module_version";
    public static final String ATTR_VERSION = "specification_version";
    public static final String ATTR_LAST = "last";
    public static final String ATTR_INSTALL = "install_time";
    public static final String ELEMENT_FILE = "file";
    public static final String ATTR_FILE_NAME = "name";
    public static final String ATTR_ORIGIN = "origin";
    public static final String UPDATER_ORIGIN = "updater";
    public static final String INSTALLER_ORIGIN = "installer";
    private static final String ATTR_CRC = "crc";
    private static final String NBM_ORIGIN = "nbm";
    public static final String ELEMENT_ADDITIONAL = "module_additional";
    public static final String ELEMENT_ADDITIONAL_MODULE = "module";
    public static final String ATTR_ADDITIONAL_NBM_NAME = "nbm_name";
    public static final String ATTR_ADDITIONAL_SOURCE = "source-display-name";
    public static final String EXTRA_CLUSTER_NAME = "extra";
    private static final String LOCALE_DIR = FILE_SEPARATOR + "locale" + FILE_SEPARATOR;
    public static final String TRACKING_FILE_NAME = "update_tracking";
    public static final String ADDITIONAL_INFO_FILE_NAME = "additional_information.xml";
    private static final String XML_EXT = ".xml";
    private static final String FORBID_AUTOUPDATE = ".noautoupdate";
    private static final Map<File, UpdateTracking> trackings = new HashMap<File, UpdateTracking>();
    private static final Map<File, AdditionalInfo> infos = new HashMap<File, AdditionalInfo>();
    private LinkedHashMap<File, Module> installedModules = new LinkedHashMap();
    private final File directory;
    private final File trackingFile;
    private String origin = "nbm";
    private final UpdatingContext context;
    private static ErrorHandler DUMMY_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
        }
    };

    private UpdateTracking(File file, UpdatingContext updatingContext) {
        assert (file != null) : "Path cannot be null";
        this.trackingFile = new File(file + FILE_SEPARATOR + TRACKING_FILE_NAME);
        this.directory = file;
        this.origin = UPDATER_ORIGIN;
        this.context = updatingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UpdateTracking getTracking(File file, boolean bl, UpdatingContext updatingContext) {
        Map<File, UpdateTracking> map = trackings;
        synchronized (map) {
            UpdateTracking updateTracking = trackings.get(file);
            if (updateTracking == null) {
                File file2 = new File(file, TRACKING_FILE_NAME);
                if (!bl && !file2.isDirectory()) {
                    return null;
                }
                File file3 = new File(file, FORBID_AUTOUPDATE);
                if (file3.exists()) {
                    return null;
                }
                updateTracking = new UpdateTracking(file, updatingContext);
                trackings.put(file, updateTracking);
                updateTracking.read();
                updateTracking.scanDir();
            }
            return updateTracking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AdditionalInfo getAdditionalInformation(File file, UpdatingContext updatingContext) {
        Map<File, AdditionalInfo> map = infos;
        synchronized (map) {
            AdditionalInfo additionalInfo = infos.get(file);
            if (additionalInfo == null) {
                File file2;
                UpdateTracking.getTracking(file, false, updatingContext);
                File file3 = new File(file, ModuleUpdater.DOWNLOAD_DIR);
                if (file3.exists() && file3.isDirectory() && (file2 = new File(file3, ADDITIONAL_INFO_FILE_NAME)).exists()) {
                    additionalInfo = new AdditionalInfo(file2);
                }
            }
            return additionalInfo;
        }
    }

    public static File getPlatformDir() {
        String string = System.getProperty("netbeans.home");
        return string == null ? null : new File(string);
    }

    public static File getUserDir() {
        String string = System.getProperty("netbeans.user");
        File file = null;
        if (string != null) {
            file = new File(string);
            if (file.getPath().startsWith("\\\\")) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    file = file.getAbsoluteFile();
                }
            } else {
                file = new File(file.toURI().normalize()).getAbsoluteFile();
            }
        }
        return file;
    }

    public static List<File> clusters(boolean bl) {
        File file;
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl && (object2 = UpdateTracking.getUserDir()) != null && !((File)(object = new File((File)object2, FORBID_AUTOUPDATE))).exists()) {
            arrayList.add(object2);
        }
        if ((object2 = System.getProperty("netbeans.dirs")) != null) {
            object = new StringTokenizer((String)object2, File.pathSeparator);
            while (object.hasMoreElements()) {
                file = new File((String)object.nextElement());
                File file2 = new File(file, FORBID_AUTOUPDATE);
                if (file2.exists()) continue;
                arrayList.add(file);
            }
        }
        if ((object = UpdateTracking.getPlatformDir()) != null && !(file = new File((File)object, FORBID_AUTOUPDATE)).exists()) {
            arrayList.add(object);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public boolean isModuleInstalled(String string) {
        for (Module module : this.installedModules.values()) {
            String string2 = module.codenamebase;
            int n = string2.indexOf(47);
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void read() {
        Document document;
        Object object;
        int n = 0;
        try {
            File file = this.trackingFile;
            if (!file.isFile()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            n = ((InputStream)fileInputStream).available();
            object = new InputSource(fileInputStream);
            document = XMLUtil.parse((InputSource)object, false, false, DUMMY_ERROR_HANDLER, XMLUtil.createAUResolver());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            XMLUtil.LOG.log(Level.SEVERE, "Bad update_tracking: " + this.trackingFile + ", available bytes: " + n, sAXException);
            return;
        }
        catch (IOException iOException) {
            XMLUtil.LOG.log(Level.SEVERE, "Missing update_tracking: " + this.trackingFile + ", available bytes: " + n, iOException);
            return;
        }
        object = document.getDocumentElement();
        if (object != null && object.getTagName().equals(ELEMENT_MODULES)) {
            this.scanElement_installed_modules((Element)object);
        }
    }

    void scanElement_installed_modules(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals("module")) continue;
            throw new IllegalStateException("What now!?");
        }
    }

    Module scanElement_module(Element element) {
        Module module = new Module();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getName().startsWith(ATTR_CODENAMEBASE)) continue;
            module.setCodenamebase(attr.getValue());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(ELEMENT_VERSION)) continue;
            this.scanElement_module_version(element2, module);
        }
        return module;
    }

    private void scanElement_module_version(Element element, Module module) {
        Version version = new Version(module);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getName().equals(ATTR_VERSION)) {
                version.setVersion(attr.getValue());
            }
            if (attr.getName().equals(ATTR_ORIGIN)) {
                version.setOrigin(attr.getValue());
            }
            if (attr.getName().equals(ATTR_LAST)) {
                version.setLast(Boolean.valueOf(attr.getValue()));
            }
            if (!attr.getName().equals(ATTR_INSTALL)) continue;
            long l = 0L;
            try {
                l = Long.parseLong(attr.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            version.setInstall_time(l);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(ELEMENT_FILE)) continue;
            this.scanElement_file(element2, version);
        }
        module.addOldVersion(version);
    }

    void scanElement_file(Element element, Version version) {
        ModuleFile moduleFile = new ModuleFile();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getName().equals(ATTR_FILE_NAME)) {
                moduleFile.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_CRC)) {
                moduleFile.setCrc(attr.getValue());
            }
            if (!attr.getName().equals(ATTR_VERSION)) continue;
            moduleFile.setLocaleversion(attr.getValue());
        }
        version.addFile(moduleFile);
    }

    Module readModuleTracking(String string, boolean bl) {
        new File(this.directory, TRACKING_FILE_NAME).mkdirs();
        File file = new File(new File(this.directory, TRACKING_FILE_NAME), UpdateTracking.getTrackingName(string) + XML_EXT);
        try {
            if (file.exists() && file.length() == 0L) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!file.exists()) {
            if (bl) {
                return new Module(string, file);
            }
            return null;
        }
        return this.readModuleFromFile(file, string, bl);
    }

    Version createVersion(String string) {
        Version version = new Version(null);
        version.setVersion(string);
        return version;
    }

    private Module readModuleFromFile(File file, String string, boolean bl) {
        Document document;
        Object object;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            object = new InputSource(fileInputStream);
            document = XMLUtil.parse((InputSource)object, false, false, DUMMY_ERROR_HANDLER, XMLUtil.createAUResolver());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            XMLUtil.LOG.log(Level.SEVERE, "Bad update_tracking", sAXException);
            return null;
        }
        catch (IOException iOException) {
            if (bl) {
                return new Module(string, file);
            }
            return null;
        }
        object = document.getDocumentElement();
        if (object != null && object.getTagName().equals("module")) {
            Module module = this.scanElement_module((Element)object);
            module.setFile(file);
            this.installedModules.put(file, module);
            return module;
        }
        if (bl) {
            return new Module(string, file);
        }
        return null;
    }

    private static String getTrackingName(String string) {
        String string2 = string;
        int n = string2.indexOf(47);
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        return string2.replace('.', '-');
    }

    void deleteUnusedFiles() {
        ArrayList<Module> arrayList = new ArrayList<Module>(this.installedModules.values());
        for (Module module : arrayList) {
            module.deleteUnusedFiles();
        }
        this.scanDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileCRC(File file) throws IOException {
        CRC32 cRC32 = new CRC32();
        try (BufferedInputStream bufferedInputStream = null;){
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                cRC32.update(byArray, 0, n);
            }
        }
        return cRC32.getValue();
    }

    private void scanDir() {
        File file = new File(this.directory, TRACKING_FILE_NAME);
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().toUpperCase().endsWith(".XML");
            }
        });
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.installedModules.containsKey(fileArray[i])) continue;
            this.readModuleFromFile(fileArray[i], null, true);
        }
    }

    public String toString() {
        return "UpdateTracing[" + this.directory + ", origin: " + this.origin + "]";
    }

    public static class AdditionalInfo {
        private Map<String, String> sources;

        private AdditionalInfo(File file) {
            this.sources = this.readAdditionalInfoFile(file);
        }

        public String getSource(String string) {
            return this.sources != null ? this.sources.get(string) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, String> readAdditionalInfoFile(File file) {
            Document document;
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException("AdditionalInfo file " + file + " must exists.");
            }
            Map<String, String> map = null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                document = XMLUtil.parse(new InputSource(fileInputStream), false, false, null, null);
            }
            catch (SAXException sAXException) {
                XMLUtil.LOG.log(Level.WARNING, "Bad additional_information.xml" + file, sAXException);
                Map<String, String> map2 = map;
                return map2;
            }
            catch (IOException iOException) {
                XMLUtil.LOG.log(Level.WARNING, "Missing additional_information.xml" + file, iOException);
                Map<String, String> map3 = map;
                return map3;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        XMLUtil.LOG.log(Level.INFO, "Cannot close stream for file " + file, iOException);
                        return map;
                    }
                }
            }
            Element element = document.getDocumentElement();
            if (element != null && element.getTagName().equals(UpdateTracking.ELEMENT_ADDITIONAL)) {
                map = this.scanModuleAdditional(element);
            }
            return map;
        }

        private Map<String, String> scanModuleAdditional(Element element) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals("module")) continue;
                String string = element2.getAttribute(UpdateTracking.ATTR_ADDITIONAL_NBM_NAME);
                String string2 = element2.getAttribute(UpdateTracking.ATTR_ADDITIONAL_SOURCE);
                hashMap.put(string, string2);
            }
            return hashMap;
        }
    }

    class ModuleFile {
        private String name;
        private String crc;
        private String localeversion = null;

        ModuleFile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String string) {
            this.name = string;
        }

        String getCrc() {
            return this.crc;
        }

        void setCrc(String string) {
            this.crc = string;
        }

        public String getLocaleversion() {
            return this.localeversion;
        }

        public void setLocaleversion(String string) {
            this.localeversion = string;
        }

        public String toString() {
            return "UpdateTracing.ModuleFile[" + this.name + "(" + this.crc + ")]";
        }
    }

    public class Version
    implements Comparable<Version> {
        private final Module module;
        private String version;
        private String origin;
        private boolean last;
        private long install_time = 0L;
        private List<ModuleFile> files = new ArrayList<ModuleFile>();

        Version(Module module) {
            this.module = module;
        }

        String getVersion() {
            return this.version;
        }

        void setVersion(String string) {
            this.version = string;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String string) {
            this.origin = string;
        }

        boolean isLast() {
            return this.last;
        }

        void setLast(boolean bl) {
            this.last = bl;
        }

        long getInstall_time() {
            return this.install_time;
        }

        void setInstall_time(long l) {
            this.install_time = l;
        }

        List<ModuleFile> getFiles() {
            return this.files;
        }

        void addL10NFiles(List<ModuleFile> list) {
            for (ModuleFile moduleFile : list) {
                String string = moduleFile.getName();
                for (int i = this.files.size() - 1; i >= 0; --i) {
                    ModuleFile moduleFile2 = this.files.get(i);
                    if (!moduleFile2.getName().equals(string)) continue;
                    this.files.remove(i);
                }
            }
            this.files.addAll(list);
        }

        void addFile(ModuleFile moduleFile) {
            this.files.add(moduleFile);
        }

        public void addFileWithCrc(String string, String string2) {
            ModuleFile moduleFile = new ModuleFile();
            moduleFile.setName(string);
            moduleFile.setCrc(string2);
            this.files.add(moduleFile);
        }

        public void addL10NFileWithCrc(String string, String string2, String string3) {
            ModuleFile moduleFile = new ModuleFile();
            moduleFile.setName(string);
            moduleFile.setCrc(string2);
            moduleFile.setLocaleversion(string3);
            this.files.add(moduleFile);
        }

        boolean containsFile(ModuleFile moduleFile) {
            for (ModuleFile moduleFile2 : this.files) {
                if (!moduleFile2.getName().equals(moduleFile.getName())) continue;
                return true;
            }
            return false;
        }

        ModuleFile findFile(String string) {
            for (ModuleFile moduleFile : this.files) {
                if (!moduleFile.getName().equals(string)) continue;
                return moduleFile;
            }
            return null;
        }

        String getLocaleVersion(String string) {
            String string2 = null;
            ModuleFile moduleFile = this.findFile(string);
            if (moduleFile != null && (string2 = moduleFile.getLocaleversion()) == null) {
                string2 = this.version;
            }
            return string2;
        }

        @Override
        public int compareTo(Version version) {
            if (this.install_time < version.getInstall_time()) {
                return 1;
            }
            if (this.install_time > version.getInstall_time()) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "UpdateTracing.Version[" + this.module + "/" + this.version + ", last? " + this.isLast() + "]";
        }
    }

    class Module {
        private String codenamebase;
        private List<Version> versions = new ArrayList<Version>();
        private File file = null;
        private Version lastVersion = null;
        private Version newVersion = null;
        private boolean osgi = false;

        public Module() {
        }

        public Module(String string, File file) {
            this.codenamebase = string;
            this.file = file;
        }

        String getCodenamebase() {
            return this.codenamebase;
        }

        void setCodenamebase(String string) {
            this.codenamebase = string;
        }

        void setOSGi(boolean bl) {
            this.osgi = bl;
        }

        boolean isOSGi() {
            return this.osgi;
        }

        List<Version> getVersions() {
            return this.versions;
        }

        void setVersions(List<Version> list) {
            this.versions = list;
        }

        private Version getNewOrLastVersion() {
            if (this.newVersion != null) {
                return this.newVersion;
            }
            return this.lastVersion;
        }

        boolean hasNewVersion() {
            return this.newVersion != null;
        }

        void setFile(File file) {
            this.file = file;
        }

        public Version addNewVersion(String string, String string2) {
            Version version;
            if (this.lastVersion != null) {
                this.lastVersion.setLast(false);
            }
            this.newVersion = version = new Version(this);
            version.setVersion(string);
            version.setOrigin(string2);
            version.setLast(true);
            version.setInstall_time(System.currentTimeMillis());
            this.versions.add(version);
            return version;
        }

        void addOldVersion(Version version) {
            if (version.isLast()) {
                this.lastVersion = version;
            }
            this.versions.add(version);
        }

        void addL10NVersion(Version version) {
            if (this.lastVersion != null) {
                this.lastVersion.addL10NFiles(version.getFiles());
            } else {
                version.setOrigin(UpdateTracking.this.origin);
                version.setLast(true);
                version.setInstall_time(System.currentTimeMillis());
                this.versions.add(version);
            }
        }

        void writeConfigModuleXMLIfMissing() {
            String string;
            File file = new File(new File(UpdateTracking.this.directory, "config"), "Modules");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = this.codenamebase;
            int n = string5.indexOf(47);
            if (n > 0) {
                string5 = string5.substring(0, n);
            }
            String string6 = (string = string5.replace('.', '-')).indexOf("Modules") > 0 ? string + ".jar" : (this.osgi ? string + ".jar" : string.substring(string.lastIndexOf(45) > 0 ? string.lastIndexOf(45) + 1 : 0) + ".jar");
            String string7 = string5.replace('.', '-');
            boolean bl = false;
            boolean bl2 = false;
            for (File file2 : UpdateTracking.clusters(true)) {
                File file3;
                File file4 = new File(new File(new File(file2, "config"), "Modules"), string7 + ".xml_hidden");
                if (file4.exists()) {
                    file4.delete();
                    XMLUtil.LOG.info("File " + file4 + " deleted.");
                }
                if (UpdateTracking.this.directory.equals(file2)) {
                    bl2 = true;
                    continue;
                }
                if (bl2 || !(file3 = new File(new File(new File(file2, "config"), "Modules"), string7 + UpdateTracking.XML_EXT)).exists()) continue;
                bl = this.lastVersion == null;
            }
            if (bl) {
                File file5 = new File(new File(new File(UpdateTracking.getUserDir(), "config"), "Modules"), string7 + UpdateTracking.XML_EXT);
                this.writeModulesConfig(file5, string6, string2, string4, string3, string5);
                return;
            }
            File file6 = new File(file, string7 + UpdateTracking.XML_EXT);
            if (file6.isFile()) {
                return;
            }
            this.writeModulesConfig(file6, string6, string2, string4, string3, string5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write() {
            Document document = XMLUtil.createDocument("module");
            Element element = document.getDocumentElement();
            element.setAttribute(UpdateTracking.ATTR_CODENAMEBASE, this.getCodenamebase());
            for (Version version : this.getVersions()) {
                Element element2 = document.createElement(UpdateTracking.ELEMENT_VERSION);
                if (version.getVersion() != null) {
                    element2.setAttribute(UpdateTracking.ATTR_VERSION, version.getVersion());
                }
                element2.setAttribute(UpdateTracking.ATTR_ORIGIN, version.getOrigin());
                element2.setAttribute(UpdateTracking.ATTR_LAST, Boolean.valueOf(version.isLast()).toString());
                element2.setAttribute(UpdateTracking.ATTR_INSTALL, Long.toString(version.getInstall_time()));
                element.appendChild(element2);
                for (ModuleFile moduleFile : version.getFiles()) {
                    Element element3 = document.createElement(UpdateTracking.ELEMENT_FILE);
                    element3.setAttribute(UpdateTracking.ATTR_FILE_NAME, moduleFile.getName());
                    element3.setAttribute(UpdateTracking.ATTR_CRC, moduleFile.getCrc());
                    if (moduleFile.getLocaleversion() != null) {
                        element3.setAttribute(UpdateTracking.ATTR_VERSION, moduleFile.getLocaleversion());
                    }
                    element2.appendChild(element3);
                }
            }
            document.getDocumentElement().normalize();
            Object object = null;
            try {
                object = UpdateTracking.this.context.createOS(this.file);
            }
            catch (Exception exception) {
                XMLUtil.LOG.log(Level.WARNING, "Cannot read " + this.file, exception);
                if (!this.file.delete()) {
                    XMLUtil.LOG.log(Level.SEVERE, null, new IOException("Corresponding update would not be installed since it is not possible to modify or delete update tracking file " + this.file));
                }
                XMLUtil.LOG.log(Level.SEVERE, null, new IOException("Update tracking file was deleted since permissions does not allow to modify it: " + this.file));
                try {
                    object = UpdateTracking.this.context.createOS(this.file);
                }
                catch (Exception exception2) {
                    XMLUtil.LOG.log(Level.WARNING, "Cannot read", exception2);
                }
            }
            if (object != null) {
                try {
                    XMLUtil.write(document, (OutputStream)object);
                    XMLUtil.LOG.info("File " + this.file + " modified.");
                }
                catch (IOException iOException) {
                    XMLUtil.LOG.log(Level.WARNING, "Cannot write " + this.file, iOException);
                }
                finally {
                    try {
                        ((OutputStream)object).close();
                    }
                    catch (IOException iOException) {
                        XMLUtil.LOG.log(Level.WARNING, "Cannot close " + this.file, iOException);
                    }
                }
            }
        }

        void deleteUnusedFiles() {
            if (this.lastVersion == null || this.newVersion == null) {
                return;
            }
            for (ModuleFile moduleFile : this.lastVersion.getFiles()) {
                if (this.newVersion.containsFile(moduleFile) || moduleFile.getName().indexOf(LOCALE_DIR) != -1) continue;
                this.safeDelete(moduleFile);
            }
        }

        private void safeDelete(ModuleFile moduleFile) {
            File file = new File(this.file.getParentFile().getParent() + FILE_SEPARATOR + moduleFile.getName());
            if (file.exists()) {
                try {
                    if (!Long.toString(UpdateTracking.getFileCRC(file)).equals(moduleFile.getCrc())) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    return;
                }
                UpdateTracking.this.scanDir();
                boolean bl = false;
                Iterator iterator = UpdateTracking.this.installedModules.values().iterator();
                while (!bl && iterator.hasNext()) {
                    Version version;
                    Module module = (Module)iterator.next();
                    if (module.equals(this) || (version = module.getNewOrLastVersion()) == null || !version.containsFile(moduleFile)) continue;
                    bl = true;
                }
                if (!bl) {
                    XMLUtil.LOG.info("Deleting file: " + file);
                    boolean bl2 = file.delete();
                    XMLUtil.LOG.info(".... " + file + " was deleted? " + bl2);
                }
            }
        }

        String getL10NSpecificationVersion(String string) {
            Collections.sort(this.versions);
            for (Version version : this.versions) {
                String string2 = version.getLocaleVersion(string);
                if (string2 == null) continue;
                return string2;
            }
            return null;
        }

        private void writeModulesConfig(File file, String string, String string2, String string3, String string4, String string5) {
            Object object;
            file.getParentFile().mkdirs();
            Boolean bl = null;
            Boolean bl2 = null;
            Iterator<ModuleFile> iterator = this.newVersion.getFiles().iterator();
            boolean bl3 = false;
            while (iterator.hasNext()) {
                object = iterator.next();
                String string6 = ((ModuleFile)object).getName();
                File file2 = new File(((ModuleFile)object).getName()).getParentFile();
                String string7 = file2 != null ? file2.getName() : "";
                boolean bl4 = bl3 = bl3 || string6.indexOf("Modules") >= 0 || this.osgi;
                if (string6.endsWith(".jar") && !string7.equals("ext")) {
                    string2 = ((ModuleFile)object).getName();
                    if (string.endsWith(string2) || string2.endsWith(string)) {
                        string3 = string2;
                        string4 = null;
                        bl = "autoload".equals(string7) ? Boolean.TRUE : Boolean.FALSE;
                        bl2 = "eager".equals(string7) ? Boolean.TRUE : Boolean.FALSE;
                    } else if (string3 == null) {
                        string4 = (string4 == null ? "" : string4 + ", ") + string2;
                    }
                }
                if (bl == null && "autoload".equals(string7)) {
                    bl = Boolean.TRUE;
                }
                if (bl2 != null || !"eager".equals(string7)) continue;
                bl2 = Boolean.TRUE;
            }
            if (!bl3) {
                XMLUtil.LOG.log(Level.WARNING, "No config file written for module {0}. No jar file present in \"modules\" directory.", this.codenamebase);
                return;
            }
            assert (string3 != null || string4 != null) : "No jar file present!";
            if (string3 == null) {
                assert (string4.equals(string2)) : "More files look as module: " + string4;
                if (!string4.equals(string2)) {
                    XMLUtil.LOG.log(Level.WARNING, "More files look as module: {0}", string4);
                    string4 = string2;
                }
            }
            object = string3 == null ? string4 : string3;
            boolean bl5 = bl != null && bl != false;
            boolean bl6 = bl2 != null && bl2 != false;
            boolean bl7 = !bl5 && !bl6;
            String string8 = this.newVersion.getVersion();
            try {
                OutputStream outputStream = UpdateTracking.this.context.createOS(file);
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                printWriter.println("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"");
                printWriter.println("                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">");
                printWriter.println("<module name=\"" + string5 + "\">");
                printWriter.println("    <param name=\"autoload\">" + bl5 + "</param>");
                printWriter.println("    <param name=\"eager\">" + bl6 + "</param>");
                if (bl7) {
                    printWriter.println("    <param name=\"enabled\">" + bl7 + "</param>");
                }
                printWriter.println("    <param name=\"jar\">" + (String)object + "</param>");
                printWriter.println("    <param name=\"reloadable\">false</param>");
                printWriter.println("    <param name=\"specversion\">" + string8 + "</param>");
                printWriter.println("</module>");
                printWriter.flush();
                printWriter.close();
                XMLUtil.LOG.info("New config was written in " + file);
            }
            catch (IOException iOException) {
                XMLUtil.LOG.log(Level.INFO, null, iOException);
            }
        }

        public String toString() {
            return "UpdateTracing.Module[" + this.codenamebase + "(" + this.file + "), OSGI? " + this.osgi + "]";
        }
    }
}

