/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.internal.UserAgentUtils;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse;

public class ListPhoneNumbersOptedOutPublisher
implements SdkPublisher<ListPhoneNumbersOptedOutResponse> {
    private final SnsAsyncClient client;
    private final ListPhoneNumbersOptedOutRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPhoneNumbersOptedOutPublisher(SnsAsyncClient client, ListPhoneNumbersOptedOutRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPhoneNumbersOptedOutPublisher(SnsAsyncClient client, ListPhoneNumbersOptedOutRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPhoneNumbersOptedOutResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPhoneNumbersOptedOutResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> phoneNumbers() {
        return this.flatMapIterable(response -> response.phoneNumbers());
    }

    private class ListPhoneNumbersOptedOutResponseFetcher
    implements AsyncPageFetcher<ListPhoneNumbersOptedOutResponse> {
        private ListPhoneNumbersOptedOutResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumbersOptedOutResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPhoneNumbersOptedOutResponse> nextPage(ListPhoneNumbersOptedOutResponse previousPage) {
            if (previousPage == null) {
                return ListPhoneNumbersOptedOutPublisher.this.client.listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutPublisher.this.firstRequest);
            }
            return ListPhoneNumbersOptedOutPublisher.this.client.listPhoneNumbersOptedOut((ListPhoneNumbersOptedOutRequest)((Object)ListPhoneNumbersOptedOutPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

