/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.util.KeyValue;

public class HotkeysInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TRACKING_ACTIVE = "tracking-active";
    public static final String SAMPLE_RATIO = "sample-ratio";
    public static final String SELECTED_SLOTS = "selected-slots";
    public static final String SAMPLED_COMMANDS_SELECTED_SLOTS_US = "sampled-commands-selected-slots-us";
    public static final String ALL_COMMANDS_SELECTED_SLOTS_US = "all-commands-selected-slots-us";
    public static final String ALL_COMMANDS_ALL_SLOTS_US = "all-commands-all-slots-us";
    public static final String NET_BYTES_SAMPLED_COMMANDS_SELECTED_SLOTS = "net-bytes-sampled-commands-selected-slots";
    public static final String NET_BYTES_ALL_COMMANDS_SELECTED_SLOTS = "net-bytes-all-commands-selected-slots";
    public static final String NET_BYTES_ALL_COMMANDS_ALL_SLOTS = "net-bytes-all-commands-all-slots";
    public static final String COLLECTION_START_TIME_UNIX_MS = "collection-start-time-unix-ms";
    public static final String COLLECTION_DURATION_MS = "collection-duration-ms";
    public static final String TOTAL_CPU_TIME_USER_MS = "total-cpu-time-user-ms";
    public static final String TOTAL_CPU_TIME_SYS_MS = "total-cpu-time-sys-ms";
    public static final String TOTAL_NET_BYTES = "total-net-bytes";
    public static final String BY_CPU_TIME_US = "by-cpu-time-us";
    public static final String BY_NET_BYTES = "by-net-bytes";
    private final boolean trackingActive;
    private final long sampleRatio;
    private final List<int[]> selectedSlots;
    private final Long sampledCommandSelectedSlotsUs;
    private final Long allCommandsSelectedSlotsUs;
    private final long allCommandsAllSlotsUs;
    private final Long netBytesSampledCommandsSelectedSlots;
    private final Long netBytesAllCommandsSelectedSlots;
    private final long netBytesAllCommandsAllSlots;
    private final long collectionStartTimeUnixMs;
    private final long collectionDurationMs;
    private final long totalCpuTimeUserMs;
    private final long totalCpuTimeSysMs;
    private final long totalNetBytes;
    private final Map<String, Long> byCpuTimeUs;
    private final Map<String, Long> byNetBytes;
    public static final Builder<HotkeysInfo> HOTKEYS_INFO_BUILDER = new Builder<HotkeysInfo>(){

        @Override
        public HotkeysInfo build(Object data) {
            if (data == null) {
                return null;
            }
            List list = (List)data;
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() == 1 && list.get(0) instanceof List && (list = (List)list.get(0)).isEmpty()) {
                return null;
            }
            boolean trackingActive = false;
            long sampleRatio = 1L;
            List selectedSlots = Collections.emptyList();
            Long sampledCommandSelectedSlotsUs = null;
            Long allCommandsSelectedSlotsUs = null;
            long allCommandsAllSlotsUs = 0L;
            Long netBytesSampledCommandsSelectedSlots = null;
            Long netBytesAllCommandsSelectedSlots = null;
            long netBytesAllCommandsAllSlots = 0L;
            long collectionStartTimeUnixMs = 0L;
            long collectionDurationMs = 0L;
            long totalCpuTimeUserMs = 0L;
            long totalCpuTimeSysMs = 0L;
            long totalNetBytes = 0L;
            Map byCpuTimeUs = Collections.emptyMap();
            Map byNetBytes = Collections.emptyMap();
            if (list.get(0) instanceof KeyValue) {
                for (KeyValue kv : list) {
                    String key = BuilderFactory.STRING.build(kv.getKey());
                    Object value = kv.getValue();
                    switch (key) {
                        case "tracking-active": {
                            trackingActive = BuilderFactory.LONG.build(value) == 1L;
                            break;
                        }
                        case "sample-ratio": {
                            sampleRatio = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "selected-slots": {
                            selectedSlots = HotkeysInfo.parseSlotRanges(value);
                            break;
                        }
                        case "sampled-commands-selected-slots-us": {
                            sampledCommandSelectedSlotsUs = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "all-commands-selected-slots-us": {
                            allCommandsSelectedSlotsUs = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "all-commands-all-slots-us": {
                            allCommandsAllSlotsUs = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "net-bytes-sampled-commands-selected-slots": {
                            netBytesSampledCommandsSelectedSlots = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "net-bytes-all-commands-selected-slots": {
                            netBytesAllCommandsSelectedSlots = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "net-bytes-all-commands-all-slots": {
                            netBytesAllCommandsAllSlots = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "collection-start-time-unix-ms": {
                            collectionStartTimeUnixMs = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "collection-duration-ms": {
                            collectionDurationMs = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "total-cpu-time-user-ms": {
                            totalCpuTimeUserMs = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "total-cpu-time-sys-ms": {
                            totalCpuTimeSysMs = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "total-net-bytes": {
                            totalNetBytes = BuilderFactory.LONG.build(value);
                            break;
                        }
                        case "by-cpu-time-us": {
                            byCpuTimeUs = HotkeysInfo.parseKeyValueMap(value);
                            break;
                        }
                        case "by-net-bytes": {
                            byNetBytes = HotkeysInfo.parseKeyValueMap(value);
                        }
                    }
                }
            } else {
                block73: for (int i = 0; i < list.size(); i += 2) {
                    String key = BuilderFactory.STRING.build(list.get(i));
                    Object value = list.get(i + 1);
                    switch (key) {
                        case "tracking-active": {
                            trackingActive = BuilderFactory.LONG.build(value) == 1L;
                            continue block73;
                        }
                        case "sample-ratio": {
                            sampleRatio = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "selected-slots": {
                            selectedSlots = HotkeysInfo.parseSlotRanges(value);
                            continue block73;
                        }
                        case "sampled-commands-selected-slots-us": {
                            sampledCommandSelectedSlotsUs = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "all-commands-selected-slots-us": {
                            allCommandsSelectedSlotsUs = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "all-commands-all-slots-us": {
                            allCommandsAllSlotsUs = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "net-bytes-sampled-commands-selected-slots": {
                            netBytesSampledCommandsSelectedSlots = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "net-bytes-all-commands-selected-slots": {
                            netBytesAllCommandsSelectedSlots = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "net-bytes-all-commands-all-slots": {
                            netBytesAllCommandsAllSlots = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "collection-start-time-unix-ms": {
                            collectionStartTimeUnixMs = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "collection-duration-ms": {
                            collectionDurationMs = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "total-cpu-time-user-ms": {
                            totalCpuTimeUserMs = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "total-cpu-time-sys-ms": {
                            totalCpuTimeSysMs = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "total-net-bytes": {
                            totalNetBytes = BuilderFactory.LONG.build(value);
                            continue block73;
                        }
                        case "by-cpu-time-us": {
                            byCpuTimeUs = HotkeysInfo.parseKeyValueMap(value);
                            continue block73;
                        }
                        case "by-net-bytes": {
                            byNetBytes = HotkeysInfo.parseKeyValueMap(value);
                        }
                    }
                }
            }
            return new HotkeysInfo(trackingActive, sampleRatio, selectedSlots, sampledCommandSelectedSlotsUs, allCommandsSelectedSlotsUs, allCommandsAllSlotsUs, netBytesSampledCommandsSelectedSlots, netBytesAllCommandsSelectedSlots, netBytesAllCommandsAllSlots, collectionStartTimeUnixMs, collectionDurationMs, totalCpuTimeUserMs, totalCpuTimeSysMs, totalNetBytes, byCpuTimeUs, byNetBytes);
        }
    };

    public HotkeysInfo(boolean trackingActive, long sampleRatio, List<int[]> selectedSlots, Long sampledCommandSelectedSlotsUs, Long allCommandsSelectedSlotsUs, long allCommandsAllSlotsUs, Long netBytesSampledCommandsSelectedSlots, Long netBytesAllCommandsSelectedSlots, long netBytesAllCommandsAllSlots, long collectionStartTimeUnixMs, long collectionDurationMs, long totalCpuTimeUserMs, long totalCpuTimeSysMs, long totalNetBytes, Map<String, Long> byCpuTimeUs, Map<String, Long> byNetBytes) {
        this.trackingActive = trackingActive;
        this.sampleRatio = sampleRatio;
        this.selectedSlots = selectedSlots;
        this.sampledCommandSelectedSlotsUs = sampledCommandSelectedSlotsUs;
        this.allCommandsSelectedSlotsUs = allCommandsSelectedSlotsUs;
        this.allCommandsAllSlotsUs = allCommandsAllSlotsUs;
        this.netBytesSampledCommandsSelectedSlots = netBytesSampledCommandsSelectedSlots;
        this.netBytesAllCommandsSelectedSlots = netBytesAllCommandsSelectedSlots;
        this.netBytesAllCommandsAllSlots = netBytesAllCommandsAllSlots;
        this.collectionStartTimeUnixMs = collectionStartTimeUnixMs;
        this.collectionDurationMs = collectionDurationMs;
        this.totalCpuTimeUserMs = totalCpuTimeUserMs;
        this.totalCpuTimeSysMs = totalCpuTimeSysMs;
        this.totalNetBytes = totalNetBytes;
        this.byCpuTimeUs = byCpuTimeUs;
        this.byNetBytes = byNetBytes;
    }

    public boolean isTrackingActive() {
        return this.trackingActive;
    }

    public long getSampleRatio() {
        return this.sampleRatio;
    }

    public List<int[]> getSelectedSlots() {
        return this.selectedSlots;
    }

    public Long getSampledCommandSelectedSlotsUs() {
        return this.sampledCommandSelectedSlotsUs;
    }

    public Long getAllCommandsSelectedSlotsUs() {
        return this.allCommandsSelectedSlotsUs;
    }

    public long getAllCommandsAllSlotsUs() {
        return this.allCommandsAllSlotsUs;
    }

    public Long getNetBytesSampledCommandsSelectedSlots() {
        return this.netBytesSampledCommandsSelectedSlots;
    }

    public Long getNetBytesAllCommandsSelectedSlots() {
        return this.netBytesAllCommandsSelectedSlots;
    }

    public long getNetBytesAllCommandsAllSlots() {
        return this.netBytesAllCommandsAllSlots;
    }

    public long getCollectionStartTimeUnixMs() {
        return this.collectionStartTimeUnixMs;
    }

    public long getCollectionDurationMs() {
        return this.collectionDurationMs;
    }

    public long getTotalCpuTimeUserMs() {
        return this.totalCpuTimeUserMs;
    }

    public long getTotalCpuTimeSysMs() {
        return this.totalCpuTimeSysMs;
    }

    public long getTotalNetBytes() {
        return this.totalNetBytes;
    }

    public Map<String, Long> getByCpuTimeUs() {
        return this.byCpuTimeUs;
    }

    public Map<String, Long> getByNetBytes() {
        return this.byNetBytes;
    }

    private static Map<String, Long> parseKeyValueMap(Object data) {
        if (data == null) {
            return Collections.emptyMap();
        }
        List list = (List)data;
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        if (list.get(0) instanceof KeyValue) {
            for (KeyValue kv : list) {
                result.put(BuilderFactory.STRING.build(kv.getKey()), BuilderFactory.LONG.build(kv.getValue()));
            }
        } else {
            for (int i = 0; i < list.size(); i += 2) {
                result.put(BuilderFactory.STRING.build(list.get(i)), BuilderFactory.LONG.build(list.get(i + 1)));
            }
        }
        return result;
    }

    private static List<int[]> parseSlotRanges(Object data) {
        if (data == null) {
            return Collections.emptyList();
        }
        List list = (List)data;
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<int[]> result = new ArrayList<int[]>(list.size());
        for (Object item : list) {
            if (!(item instanceof List)) continue;
            List range = (List)item;
            if (range.size() == 1) {
                int slot = BuilderFactory.LONG.build(range.get(0)).intValue();
                result.add(new int[]{slot});
                continue;
            }
            if (range.size() != 2) continue;
            int start = BuilderFactory.LONG.build(range.get(0)).intValue();
            int end = BuilderFactory.LONG.build(range.get(1)).intValue();
            result.add(new int[]{start, end});
        }
        return result;
    }
}

