/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionConfig;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.output.HierarchicalOutputUnitFormatter;
import com.networknt.schema.output.ListOutputUnitFormatter;
import com.networknt.schema.output.OutputFlag;
import com.networknt.schema.output.OutputUnit;
import com.networknt.schema.output.OutputUnitData;
import java.util.function.Function;

public interface OutputFormat<T> {
    public static final Default DEFAULT = new Default();
    public static final Boolean BOOLEAN = new Boolean();
    public static final Flag FLAG = new Flag();
    public static final List LIST = new List();
    public static final Hierarchical HIERARCHICAL = new Hierarchical();
    public static final Result RESULT = new Result();

    default public void customize(ExecutionContext executionContext, SchemaContext schemaContext) {
    }

    public T format(Schema var1, ExecutionContext var2, SchemaContext var3);

    public static class Default
    implements OutputFormat<java.util.List<Error>> {
        @Override
        public void customize(ExecutionContext executionContext, SchemaContext schemaContext) {
            executionContext.executionConfig(executionConfig -> executionConfig.annotationCollectionEnabled(false));
        }

        @Override
        public java.util.List<Error> format(Schema jsonSchema, ExecutionContext executionContext, SchemaContext schemaContext) {
            return executionContext.getErrors();
        }
    }

    public static class Boolean
    implements OutputFormat<java.lang.Boolean> {
        @Override
        public void customize(ExecutionContext executionContext, SchemaContext schemaContext) {
            executionContext.executionConfig(executionConfig -> ((ExecutionConfig.Builder)executionConfig.annotationCollectionEnabled(false)).failFast(true));
        }

        @Override
        public java.lang.Boolean format(Schema jsonSchema, ExecutionContext executionContext, SchemaContext schemaContext) {
            return executionContext.getErrors().isEmpty();
        }
    }

    public static class Flag
    implements OutputFormat<OutputFlag> {
        @Override
        public void customize(ExecutionContext executionContext, SchemaContext schemaContext) {
            executionContext.executionConfig(executionConfig -> ((ExecutionConfig.Builder)executionConfig.annotationCollectionEnabled(false)).failFast(true));
        }

        @Override
        public OutputFlag format(Schema jsonSchema, ExecutionContext executionContext, SchemaContext schemaContext) {
            return new OutputFlag(executionContext.getErrors().isEmpty());
        }
    }

    public static class List
    implements OutputFormat<OutputUnit> {
        private final Function<Error, Object> errorMapper;

        public List() {
            this(OutputUnitData::formatError);
        }

        public List(Function<Error, Object> errorMapper) {
            this.errorMapper = errorMapper;
        }

        @Override
        public void customize(ExecutionContext executionContext, SchemaContext schemaContext) {
        }

        @Override
        public OutputUnit format(Schema jsonSchema, ExecutionContext executionContext, SchemaContext schemaContext) {
            return ListOutputUnitFormatter.format(executionContext.getErrors(), executionContext, schemaContext, this.errorMapper);
        }
    }

    public static class Hierarchical
    implements OutputFormat<OutputUnit> {
        private final Function<Error, Object> errorMapper;

        public Hierarchical() {
            this(OutputUnitData::formatError);
        }

        public Hierarchical(Function<Error, Object> errorMapper) {
            this.errorMapper = errorMapper;
        }

        @Override
        public void customize(ExecutionContext executionContext, SchemaContext schemaContext) {
        }

        @Override
        public OutputUnit format(Schema jsonSchema, ExecutionContext executionContext, SchemaContext schemaContext) {
            return HierarchicalOutputUnitFormatter.format(jsonSchema, executionContext.getErrors(), executionContext, schemaContext, this.errorMapper);
        }
    }

    public static class Result
    implements OutputFormat<com.networknt.schema.Result> {
        @Override
        public void customize(ExecutionContext executionContext, SchemaContext schemaContext) {
        }

        @Override
        public com.networknt.schema.Result format(Schema jsonSchema, ExecutionContext executionContext, SchemaContext schemaContext) {
            return new com.networknt.schema.Result(executionContext);
        }
    }
}

