/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.SQLException;
import java.time.Duration;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.datasources.AbstractConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

final class CPDSConnectionFactory
extends AbstractConnectionFactory
implements PooledObjectFactory<PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private ObjectPool<PooledConnectionAndInfo> pool;
    private UserPassKey userPassKey;

    CPDSConnectionFactory(ConnectionPoolDataSource cpds, String validationQuery, Duration validationQueryTimeoutDuration, boolean rollbackAfterValidation, String userName, char[] userPassword) {
        super(cpds, validationQuery, validationQueryTimeoutDuration, rollbackAfterValidation);
        this.userPassKey = new UserPassKey(userName, userPassword);
    }

    @Override
    public void activateObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePool(String userName) throws SQLException {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (userName == null || !userName.equals(this.userPassKey.getUserName())) {
                return;
            }
        }
        try {
            this.pool.close();
        }
        catch (Exception ex) {
            throw new SQLException("Error closing connection pool", ex);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingSet.contains(pc)) {
            PooledConnectionAndInfo pci = (PooledConnectionAndInfo)this.pcMap.get(pc);
            if (pci == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this.pool.returnObject(pci);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pc.removeConnectionEventListener(this);
                try {
                    this.doDestroyObject(pci);
                }
                catch (Exception e2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pci);
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (null != event.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
        }
        pc.removeConnectionEventListener(this);
        PooledConnectionAndInfo pci = (PooledConnectionAndInfo)this.pcMap.get(pc);
        if (pci == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pci);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pci);
            e.printStackTrace();
        }
    }

    @Override
    public void destroyObject(PooledObject<PooledConnectionAndInfo> p) throws SQLException {
        this.doDestroyObject(p.getObject());
    }

    private void doDestroyObject(PooledConnectionAndInfo pci) throws SQLException {
        PooledConnection pc = pci.getPooledConnection();
        pc.removeConnectionEventListener(this);
        this.pcMap.remove(pc);
        pc.close();
    }

    char[] getPasswordCharArray() {
        return this.userPassKey.getPasswordCharArray();
    }

    public ObjectPool<PooledConnectionAndInfo> getPool() {
        return this.pool;
    }

    @Override
    public void invalidate(PooledConnection pc) throws SQLException {
        PooledConnectionAndInfo pci = (PooledConnectionAndInfo)this.pcMap.get(pc);
        if (pci == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.close();
            this.pool.invalidateObject(pci);
        }
        catch (Exception ex) {
            throw new SQLException("Error invalidating connection", ex);
        }
    }

    @Override
    public synchronized PooledObject<PooledConnectionAndInfo> makeObject() throws SQLException {
        PooledConnection pc = null;
        pc = this.userPassKey.getUserName() == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(this.userPassKey.getUserName(), this.userPassKey.getPassword());
        if (pc == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pc.addConnectionEventListener(this);
        PooledConnectionAndInfo pci = new PooledConnectionAndInfo(pc, this.userPassKey);
        this.pcMap.put(pc, pci);
        return new DefaultPooledObject<PooledConnectionAndInfo>(pci);
    }

    @Override
    public void passivateObject(PooledObject<PooledConnectionAndInfo> p) throws SQLException {
        this.validateLifetime(p);
    }

    @Override
    public synchronized void setPassword(char[] userPassword) {
        this.userPassKey = new UserPassKey(this.userPassKey.getUserName(), userPassword);
    }

    @Override
    public synchronized void setPassword(String userPassword) {
        this.userPassKey = new UserPassKey(this.userPassKey.getUserName(), userPassword);
    }

    public void setPool(ObjectPool<PooledConnectionAndInfo> pool) {
        this.pool = pool;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[cpds=");
        builder.append(this.cpds);
        builder.append(", validationQuery=");
        builder.append(this.validationQuery);
        builder.append(", validationQueryTimeoutDuration=");
        builder.append(this.validationQueryTimeoutDuration);
        builder.append(", rollbackAfterValidation=");
        builder.append(this.rollbackAfterValidation);
        builder.append(", pool=");
        builder.append(this.pool);
        builder.append(", maxConnDuration=");
        builder.append(this.maxConnDuration);
        builder.append(", validatingSet=");
        builder.append(this.validatingSet);
        builder.append(", pcMap=");
        builder.append(this.pcMap);
        builder.append("]");
        return builder.toString();
    }
}

