/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.AbstractIterator;
import scala.collection.IterableFactory$;
import scala.collection.Iterator;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.util.hashing.package$;

public interface HashTable<A, B, Entry extends HashEntry<A, Entry>>
extends HashUtils<A> {
    public static int capacity(int n) {
        return HashTable$.MODULE$.capacity(n);
    }

    public static int defaultLoadFactor() {
        return HashTable$.MODULE$.defaultLoadFactor();
    }

    public static int loadFactorDenum() {
        return HashTable$.MODULE$.loadFactorDenum();
    }

    public static int newThreshold(int n, int n2) {
        return HashTable$.MODULE$.newThreshold(n, n2);
    }

    public static int nextPositivePowerOfTwo(int n) {
        return HashTable$.MODULE$.nextPositivePowerOfTwo(n);
    }

    public static int sizeForThreshold(int n, int n2) {
        return HashTable$.MODULE$.sizeForThreshold(n, n2);
    }

    public static void $init$(HashTable $this) {
        $this._loadFactor_$eq(HashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new HashEntry[$this.initialCapacity()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq($this.initialThreshold($this._loadFactor()));
        $this.sizemap_$eq(null);
        $this.seedvalue_$eq($this.tableSizeSeed());
    }

    public int _loadFactor();

    public void _loadFactor_$eq(int var1);

    public HashEntry<A, Entry>[] table();

    public void table_$eq(HashEntry<A, Entry>[] var1);

    public int tableSize();

    public void tableSize_$eq(int var1);

    public static int size$(HashTable $this) {
        return $this.size();
    }

    default public int size() {
        return this.tableSize();
    }

    public int threshold();

    public void threshold_$eq(int var1);

    public int[] sizemap();

    public void sizemap_$eq(int[] var1);

    public int seedvalue();

    public void seedvalue_$eq(int var1);

    public static int tableSizeSeed$(HashTable $this) {
        return $this.tableSizeSeed();
    }

    default public int tableSizeSeed() {
        return Integer.bitCount(this.table().length - 1);
    }

    public static int initialSize$(HashTable $this) {
        return $this.initialSize();
    }

    default public int initialSize() {
        return 16;
    }

    private int initialThreshold(int _loadFactor) {
        return HashTable$.MODULE$.newThreshold(_loadFactor, this.initialCapacity());
    }

    private int initialCapacity() {
        return HashTable$.MODULE$.capacity(this.initialSize());
    }

    public static int scala$collection$mutable$HashTable$$lastPopulatedIndex$(HashTable $this) {
        return $this.scala$collection$mutable$HashTable$$lastPopulatedIndex();
    }

    default public int scala$collection$mutable$HashTable$$lastPopulatedIndex() {
        int idx;
        for (idx = this.table().length - 1; this.table()[idx] == null && idx > 0; --idx) {
        }
        return idx;
    }

    public static void init$(HashTable $this, ObjectInputStream in, Function0 readEntry) {
        $this.init(in, readEntry);
    }

    default public void init(ObjectInputStream in, Function0<Entry> readEntry) {
        this._loadFactor_$eq(in.readInt());
        if (this._loadFactor() <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        int size = in.readInt();
        this.tableSize_$eq(0);
        if (size < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.seedvalue_$eq(in.readInt());
        boolean smDefined = in.readBoolean();
        this.table_$eq(new HashEntry[HashTable$.MODULE$.capacity(HashTable$.MODULE$.sizeForThreshold(this._loadFactor(), size))]);
        this.threshold_$eq(HashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
        if (smDefined) {
            this.sizeMapInit(this.table().length);
        } else {
            this.sizemap_$eq(null);
        }
        for (int index = 0; index < size; ++index) {
            this.addEntry((HashEntry)readEntry.apply());
        }
    }

    public static void serializeTo$(HashTable $this, ObjectOutputStream out, Function1 writeEntry) {
        $this.serializeTo(out, writeEntry);
    }

    default public void serializeTo(ObjectOutputStream out, Function1<Entry, BoxedUnit> writeEntry) {
        out.writeInt(this._loadFactor());
        out.writeInt(this.tableSize());
        out.writeInt(this.seedvalue());
        out.writeBoolean(this.isSizeMapDefined());
        this.foreachEntry(writeEntry);
    }

    public static HashEntry findEntry$(HashTable $this, Object key) {
        return $this.findEntry(key);
    }

    default public Entry findEntry(A key) {
        return this.findEntry0(key, this.index(this.elemHashCode(key)));
    }

    public static HashEntry findEntry0$(HashTable $this, Object key, int h) {
        return $this.findEntry0(key, h);
    }

    default public Entry findEntry0(A key, int h) {
        HashEntry<A, Object> e;
        for (e = this.table()[h]; e != null && !this.elemEquals(e.key(), key); e = e.next()) {
        }
        return (Entry)e;
    }

    public static void addEntry$(HashTable $this, HashEntry e) {
        $this.addEntry(e);
    }

    default public void addEntry(Entry e) {
        this.addEntry0(e, this.index(this.elemHashCode(e.key())));
    }

    public static void addEntry0$(HashTable $this, HashEntry e, int h) {
        $this.addEntry0(e, h);
    }

    default public void addEntry0(Entry e, int h) {
        e.next_$eq(this.table()[h]);
        this.table()[h] = e;
        this.tableSize_$eq(this.tableSize() + 1);
        this.nnSizeMapAdd(h);
        if (this.tableSize() > this.threshold()) {
            this.resize(2 * this.table().length);
            return;
        }
    }

    public static HashEntry findOrAddEntry$(HashTable $this, Object key, Object value) {
        return $this.findOrAddEntry(key, value);
    }

    default public Entry findOrAddEntry(A key, B value) {
        int h = this.index(this.elemHashCode(key));
        Entry e = this.findEntry0(key, h);
        if (!(e == null)) {
            return e;
        }
        this.addEntry0(this.createNewEntry(key, value), h);
        return null;
    }

    public Entry createNewEntry(A var1, B var2);

    public static HashEntry removeEntry$(HashTable $this, Object key) {
        return $this.removeEntry(key);
    }

    default public Entry removeEntry(A key) {
        return this.removeEntry0(key, this.index(this.elemHashCode(key)));
    }

    public static HashEntry removeEntry0$(HashTable $this, Object key, int h) {
        return $this.removeEntry0(key, h);
    }

    default public Entry removeEntry0(A key, int h) {
        HashEntry<A, Object> e = this.table()[h];
        if (e != null) {
            Object e1;
            if (this.elemEquals(e.key(), key)) {
                this.table()[h] = e.next();
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h);
                e.next_$eq(null);
                return (Entry)e;
            }
            for (e1 = e.next(); e1 != null && !this.elemEquals(e1.key(), key); e1 = e1.next()) {
                e = e1;
            }
            if (e1 != null) {
                e.next_$eq(e1.next());
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h);
                e1.next_$eq(null);
                return (Entry)e1;
            }
        }
        return null;
    }

    public static Iterator entriesIterator$(HashTable $this) {
        return $this.entriesIterator();
    }

    default public Iterator<Entry> entriesIterator() {
        return new AbstractIterator<Entry>(this){
            private final HashEntry[] iterTable;
            private int idx;
            private HashEntry es;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.iterTable = $outer.table();
                this.idx = $outer.scala$collection$mutable$HashTable$$lastPopulatedIndex();
                this.es = this.iterTable()[this.idx()];
            }

            public HashEntry[] iterTable() {
                return this.iterTable;
            }

            public int idx() {
                return this.idx;
            }

            public void idx_$eq(int x$1) {
                this.idx = x$1;
            }

            public HashEntry es() {
                return this.es;
            }

            public void es_$eq(HashEntry x$1) {
                this.es = x$1;
            }

            public boolean hasNext() {
                return this.es() != null;
            }

            public HashEntry next() {
                HashEntry res = this.es();
                HashEntry x$proxy1 = this.es();
                if (x$proxy1 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                this.es_$eq((HashEntry)x$proxy1.next());
                while (this.es() == null && this.idx() > 0) {
                    this.idx_$eq(this.idx() - 1);
                    this.es_$eq(this.iterTable()[this.idx()]);
                }
                return res;
            }
        };
    }

    public static void foreachEntry$(HashTable $this, Function1 f) {
        $this.foreachEntry(f);
    }

    default public <U> void foreachEntry(Function1<Entry, U> f) {
        HashEntry<A, Entry>[] iterTable = this.table();
        int idx = this.scala$collection$mutable$HashTable$$lastPopulatedIndex();
        HashEntry<A, Object> es = iterTable[idx];
        while (es != null) {
            Entry next = es.next();
            f.apply(es);
            es = next;
            while (es == null && idx > 0) {
                es = iterTable[--idx];
            }
        }
    }

    public static void clearTable$(HashTable $this) {
        $this.clearTable();
    }

    default public void clearTable() {
        for (int i = this.table().length - 1; i >= 0; --i) {
            this.table()[i] = null;
        }
        this.tableSize_$eq(0);
        this.nnSizeMapReset(0);
    }

    private void resize(int newSize) {
        HashEntry<A, Entry>[] oldTable = this.table();
        this.table_$eq(new HashEntry[newSize]);
        this.nnSizeMapReset(this.table().length);
        for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry<A, Object> e = oldTable[i];
            while (e != null) {
                int h = this.index(this.elemHashCode(e.key()));
                Entry e1 = e.next();
                e.next_$eq(this.table()[h]);
                this.table()[h] = e;
                e = e1;
                this.nnSizeMapAdd(h);
            }
        }
        this.threshold_$eq(HashTable$.MODULE$.newThreshold(this._loadFactor(), newSize));
    }

    public static void nnSizeMapAdd$(HashTable $this, int h) {
        $this.nnSizeMapAdd(h);
    }

    default public void nnSizeMapAdd(int h) {
        if (!(this.sizemap() == null)) {
            int[] nArray = this.sizemap();
            int n = h >> this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] + 1;
            return;
        }
    }

    public static void nnSizeMapRemove$(HashTable $this, int h) {
        $this.nnSizeMapRemove(h);
    }

    default public void nnSizeMapRemove(int h) {
        if (!(this.sizemap() == null)) {
            int[] nArray = this.sizemap();
            int n = h >> this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
            return;
        }
    }

    public static void nnSizeMapReset$(HashTable $this, int tableLength) {
        $this.nnSizeMapReset(tableLength);
    }

    default public void nnSizeMapReset(int tableLength) {
        if (!(this.sizemap() == null)) {
            int nsize = this.calcSizeMapSize(tableLength);
            if (this.sizemap().length != nsize) {
                this.sizemap_$eq(new int[nsize]);
                return;
            }
            Arrays.fill(this.sizemap(), 0);
            return;
        }
    }

    public static int totalSizeMapBuckets$(HashTable $this) {
        return $this.totalSizeMapBuckets();
    }

    default public int totalSizeMapBuckets() {
        if (this.sizeMapBucketSize() < this.table().length) {
            return 1;
        }
        return this.table().length / this.sizeMapBucketSize();
    }

    public static int calcSizeMapSize$(HashTable $this, int tableLength) {
        return $this.calcSizeMapSize(tableLength);
    }

    default public int calcSizeMapSize(int tableLength) {
        return (tableLength >> this.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit$(HashTable $this, int tableLength) {
        $this.sizeMapInit(tableLength);
    }

    default public void sizeMapInit(int tableLength) {
        this.sizemap_$eq(new int[this.calcSizeMapSize(tableLength)]);
    }

    public static void sizeMapInitAndRebuild$(HashTable $this) {
        $this.sizeMapInitAndRebuild();
    }

    default public void sizeMapInitAndRebuild() {
        this.sizeMapInit(this.table().length);
        int tableidx = 0;
        HashEntry<A, Entry>[] tbl = this.table();
        int tableuntil = 0;
        tableuntil = tbl.length < this.sizeMapBucketSize() ? tbl.length : this.sizeMapBucketSize();
        int totalbuckets = this.totalSizeMapBuckets();
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsize = 0;
            while (tableidx < tableuntil) {
                HashEntry<A, Object> e = tbl[tableidx];
                while (!(e == null)) {
                    ++currbucketsize;
                    e = e.next();
                }
                ++tableidx;
            }
            int[] x$proxy10 = this.sizemap();
            if (x$proxy10 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy10[bucketidx] = currbucketsize;
            tableuntil += this.sizeMapBucketSize();
        }
    }

    public static void printSizeMap$(HashTable $this) {
        $this.printSizeMap();
    }

    /*
     * WARNING - void declaration
     */
    default public void printSizeMap() {
        void var1_1;
        int[] x$proxy11 = this.sizemap();
        if (x$proxy11 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        Predef$.MODULE$.println(Predef$.MODULE$.wrapIntArray((int[])var1_1).to(IterableFactory$.MODULE$.toFactory(List$.MODULE$)));
    }

    public static void sizeMapDisable$(HashTable $this) {
        $this.sizeMapDisable();
    }

    default public void sizeMapDisable() {
        this.sizemap_$eq(null);
    }

    public static boolean isSizeMapDefined$(HashTable $this) {
        return $this.isSizeMapDefined();
    }

    default public boolean isSizeMapDefined() {
        return !(this.sizemap() == null);
    }

    public static boolean alwaysInitSizeMap$(HashTable $this) {
        return $this.alwaysInitSizeMap();
    }

    default public boolean alwaysInitSizeMap() {
        return false;
    }

    public static boolean elemEquals$(HashTable $this, Object key1, Object key2) {
        return $this.elemEquals(key1, key2);
    }

    default public boolean elemEquals(A key1, A key2) {
        return BoxesRunTime.equals(key1, key2);
    }

    public static int index$(HashTable $this, int hcode) {
        return $this.index(hcode);
    }

    default public int index(int hcode) {
        int ones = this.table().length - 1;
        int exponent = Integer.numberOfLeadingZeros(ones);
        return this.improve(hcode, this.seedvalue()) >>> exponent & ones;
    }

    public static interface HashUtils<KeyType> {
        public static void $init$(HashUtils $this) {
        }

        public static int sizeMapBucketBitSize$(HashUtils $this) {
            return $this.sizeMapBucketBitSize();
        }

        default public int sizeMapBucketBitSize() {
            return 5;
        }

        public static int sizeMapBucketSize$(HashUtils $this) {
            return $this.sizeMapBucketSize();
        }

        default public int sizeMapBucketSize() {
            return 1 << this.sizeMapBucketBitSize();
        }

        public static int elemHashCode$(HashUtils $this, Object key) {
            return $this.elemHashCode(key);
        }

        default public int elemHashCode(KeyType key) {
            return Statics.anyHash(key);
        }

        public static int improve$(HashUtils $this, int hcode, int seed) {
            return $this.improve(hcode, seed);
        }

        default public int improve(int hcode, int seed) {
            return Integer.rotateRight(package$.MODULE$.byteswap32(hcode), seed);
        }
    }
}

