/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) * mat2(1.6, 1.53, 0.76, -1.0)) => vec2(-1.996, 1.1240001)
 * (vec2(-0.1, -1.2) * mat2(-0.13, -1.4, -0.87, 1.4)) => vec2(1.6930001, -1.593)
 * (vec2(-0.42, 0.48) * mat2(1.6, 1.53, 0.76, -1.0)) => vec2(0.06239998, -0.7992)
 * (vec2(-0.42, 0.48) * mat2(-0.13, -1.4, -0.87, 1.4)) => vec2(-0.6174, 1.0374)
 */
#version 150

void main()
{
  float[distance((vec2(-0.1, -1.2) * mat2(1.6, 1.53, 0.76, -1.0)), vec2(-1.996, 1.1240001)) <= 2.2907187e-05 ? 1 : -1] array0;
  float[distance((vec2(-0.1, -1.2) * mat2(-0.13, -1.4, -0.87, 1.4)), vec2(1.6930001, -1.593)) <= 2.3246286e-05 ? 1 : -1] array1;
  float[distance((vec2(-0.42, 0.48) * mat2(1.6, 1.53, 0.76, -1.0)), vec2(0.06239998, -0.7992)) <= 8.016323e-06 ? 1 : -1] array2;
  float[distance((vec2(-0.42, 0.48) * mat2(-0.13, -1.4, -0.87, 1.4)), vec2(-0.6174, 1.0374)) <= 1.2072205e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
