/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * reflect(vec2(-0.1, -1.2), vec2(-0.08304548, -0.99654573)) => vec2(0.10000001, 1.1999999)
 * reflect(vec2(-0.1, -1.2), vec2(-0.6585046, 0.7525767)) => vec2(-1.202655, 0.060177047)
 * reflect(vec2(-0.42, 0.48), vec2(-0.08304548, -0.99654573)) => vec2(-0.49365515, -0.403862)
 * reflect(vec2(-0.42, 0.48), vec2(-0.6585046, 0.7525767)) => vec2(0.42, -0.48000002)
 */
#version 120

void main()
{
  float[distance(reflect(vec2(-0.1, -1.2), vec2(-0.08304548, -0.99654573)), vec2(0.10000001, 1.1999999)) <= 1.2041593e-05 ? 1 : -1] array0;
  float[distance(reflect(vec2(-0.1, -1.2), vec2(-0.6585046, 0.7525767)), vec2(-1.202655, 0.060177047)) <= 1.2041595e-05 ? 1 : -1] array1;
  float[distance(reflect(vec2(-0.42, 0.48), vec2(-0.08304548, -0.99654573)), vec2(-0.49365515, -0.403862)) <= 6.378087e-06 ? 1 : -1] array2;
  float[distance(reflect(vec2(-0.42, 0.48), vec2(-0.6585046, 0.7525767)), vec2(0.42, -0.48000002)) <= 6.3780876e-06 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
