/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.monitor.internal.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.io.monitor.internal.metrics.OpenhabCoreMeterBinder;
import org.openhab.core.items.events.ItemCommandEvent;
import org.openhab.core.items.events.ItemStateEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EventCountMetric
implements OpenhabCoreMeterBinder,
EventSubscriber {
    public static final String METRIC_NAME = "event_count";
    private final Logger logger = LoggerFactory.getLogger(EventCountMetric.class);
    private static final Tag CORE_EVENT_COUNT_METRIC_TAG = Tag.of("metric", "openhab.core.metric.eventcount");
    private static final String TOPIC_TAG_NAME = "topic";
    private @Nullable MeterRegistry meterRegistry;
    private final Set<Tag> tags = new HashSet<Tag>();
    private @Nullable ServiceRegistration<?> eventSubscriberRegistration;
    private BundleContext bundleContext;

    public EventCountMetric(BundleContext bundleContext, Collection<Tag> tags) {
        this.tags.addAll(tags);
        this.tags.add(CORE_EVENT_COUNT_METRIC_TAG);
        this.bundleContext = bundleContext;
    }

    @Override
    public void bindTo(@NonNullByDefault(value={}) MeterRegistry meterRegistry) {
        this.unbind();
        this.logger.debug("EventCountMetric is being bound...");
        this.meterRegistry = meterRegistry;
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
    }

    @Override
    public void unbind() {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            return;
        }
        for (Meter meter : meterRegistry.getMeters()) {
            if (!meter.getId().getTags().contains(CORE_EVENT_COUNT_METRIC_TAG)) continue;
            meterRegistry.remove(meter);
        }
        this.meterRegistry = null;
        ServiceRegistration<?> eventSubscriberRegistration = this.eventSubscriberRegistration;
        if (eventSubscriberRegistration != null) {
            eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of(ItemCommandEvent.TYPE, ItemStateEvent.TYPE);
    }

    public void receive(Event event) {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            this.logger.trace("Measurement not started. Skipping event processing");
            return;
        }
        String topic = event.getTopic();
        this.logger.debug("Received event on topic {}.", (Object)topic);
        HashSet<Tag> tagsWithTopic = new HashSet<Tag>(this.tags);
        tagsWithTopic.add(Tag.of(TOPIC_TAG_NAME, topic));
        meterRegistry.counter(METRIC_NAME, tagsWithTopic).increment();
    }
}

