/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ChangeImageCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeImageCompartmentRequest
extends BmcRequest<ChangeImageCompartmentDetails> {
    private String imageId;
    private ChangeImageCompartmentDetails changeImageCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getImageId() {
        return this.imageId;
    }

    public ChangeImageCompartmentDetails getChangeImageCompartmentDetails() {
        return this.changeImageCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeImageCompartmentDetails getBody$() {
        return this.changeImageCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().imageId(this.imageId).changeImageCompartmentDetails(this.changeImageCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",imageId=").append(String.valueOf(this.imageId));
        sb.append(",changeImageCompartmentDetails=").append(String.valueOf((Object)this.changeImageCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeImageCompartmentRequest)) {
            return false;
        }
        ChangeImageCompartmentRequest other = (ChangeImageCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.imageId, other.imageId) && Objects.equals((Object)this.changeImageCompartmentDetails, (Object)other.changeImageCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.changeImageCompartmentDetails == null ? 43 : this.changeImageCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeImageCompartmentRequest, ChangeImageCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String imageId = null;
        private ChangeImageCompartmentDetails changeImageCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder changeImageCompartmentDetails(ChangeImageCompartmentDetails changeImageCompartmentDetails) {
            this.changeImageCompartmentDetails = changeImageCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeImageCompartmentRequest o) {
            this.imageId(o.getImageId());
            this.changeImageCompartmentDetails(o.getChangeImageCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeImageCompartmentRequest build() {
            ChangeImageCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeImageCompartmentDetails body) {
            this.changeImageCompartmentDetails(body);
            return this;
        }

        public ChangeImageCompartmentRequest buildWithoutInvocationCallback() {
            ChangeImageCompartmentRequest request = new ChangeImageCompartmentRequest();
            request.imageId = this.imageId;
            request.changeImageCompartmentDetails = this.changeImageCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

