/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.testrunner.api.CommonUtils;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.openide.util.Parameters;

public class TestSession {
    private long failuresCount = 0L;
    private final LineConvertors.FileLocator fileLocator;
    private final SessionType sessionType;
    private final String name;
    private WeakReference<Project> project;
    private final URI projectURI;
    private final List<TestSuite> testSuites = new ArrayList<TestSuite>();
    private final Stack<Integer> suiteIdxs = new Stack();
    private final List<String> output = new ArrayList<String>();
    private String startingMsg;
    private RerunHandler rerunHandler;

    public TestSession(String name, Project project, SessionType sessionType) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.name = name;
        this.project = new WeakReference<Project>(project);
        this.projectURI = project.getProjectDirectory().toURI();
        this.fileLocator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        this.sessionType = sessionType;
    }

    public RerunHandler getRerunHandler() {
        return this.rerunHandler;
    }

    public void setRerunHandler(RerunHandler rerunHandler) {
        Parameters.notNull((CharSequence)"rerunHandler", (Object)rerunHandler);
        this.rerunHandler = rerunHandler;
    }

    public void setStartingMsg(String startingMsg) {
        this.startingMsg = startingMsg;
    }

    public String getStartingMsg() {
        return this.startingMsg;
    }

    public Project getProject() {
        Project prj = (Project)this.project.get();
        if (prj == null) {
            prj = FileOwnerQuery.getOwner((URI)this.projectURI);
            assert (prj != null) : "Project was null for projectURI: " + this.projectURI;
            this.project = new WeakReference<Project>(prj);
        }
        return prj;
    }

    public Testcase getCurrentTestCase() {
        if (this.getCurrentSuite() == null) {
            return null;
        }
        List<Testcase> testcases = this.getCurrentSuite().getTestcases();
        return testcases.isEmpty() ? null : testcases.get(testcases.size() - 1);
    }

    public List<Testcase> getAllTestCases() {
        ArrayList<Testcase> all = new ArrayList<Testcase>();
        for (TestSuite suite : this.testSuites) {
            all.addAll(suite.getTestcases());
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuite(TestSuite suite) {
        Testcase testcase;
        Parameters.notNull((CharSequence)"suite", (Object)suite);
        if (!this.output.isEmpty() && this.getCurrentSuite() != null && (testcase = this.getCurrentSuite().getLastTestCase()) != null) {
            testcase.addOutputLines(this.output);
            this.output.clear();
        }
        TestSession testSession = this;
        synchronized (testSession) {
            this.suiteIdxs.push(this.testSuites.size());
            this.testSuites.add(suite);
        }
    }

    public synchronized void finishSuite(TestSuite suite) {
        if (!this.suiteIdxs.isEmpty() && suite == this.getCurrentSuite()) {
            this.suiteIdxs.pop();
        }
    }

    public void addOutput(String line) {
        this.output.add(line);
    }

    public void addTestCase(Testcase testCase) {
        assert (!this.testSuites.isEmpty()) : "No suites running";
        testCase.addOutputLines(this.output);
        this.output.clear();
        this.getCurrentSuite().addTestcase(testCase);
    }

    public synchronized TestSuite getCurrentSuite() {
        return this.testSuites.isEmpty() ? null : this.testSuites.get(this.suiteIdxs.isEmpty() ? this.testSuites.size() - 1 : this.suiteIdxs.peek());
    }

    public Report getReport(long timeInMillis) {
        TestSuite currentSuite = this.getCurrentSuite();
        assert (currentSuite != null) : "Currently running suite was null for projectURI: " + this.projectURI;
        Report report = new Report(currentSuite.getName(), this.getProject());
        report.setElapsedTimeMillis(timeInMillis);
        boolean isTestNG = CommonUtils.getInstance().getTestingFramework().equals("testng");
        for (Testcase testcase : currentSuite.getTestcases()) {
            report.reportTest(testcase);
            if (this.isTestNGConfigMethod(testcase, isTestNG)) continue;
            report.setTotalTests(report.getTotalTests() + 1);
            if (testcase.getStatus() == Status.PASSED) {
                report.setPassed(report.getPassed() + 1);
                continue;
            }
            if (testcase.getStatus() == Status.PASSEDWITHERRORS) {
                report.setPassedWithErrors(report.getPassedWithErrors() + 1);
                continue;
            }
            if (testcase.getStatus() == Status.ERROR) {
                report.setErrors(report.getErrors() + 1);
                continue;
            }
            if (testcase.getStatus() == Status.FAILED) {
                report.setFailures(report.getFailures() + 1);
                continue;
            }
            if (testcase.getStatus() == Status.PENDING) {
                report.setPending(report.getPending() + 1);
                continue;
            }
            if (testcase.getStatus() == Status.SKIPPED) {
                report.setSkipped(report.getSkipped() + 1);
                report.setSkipped(true);
                continue;
            }
            if (testcase.getStatus() != Status.ABORTED) continue;
            report.setAborted(report.getAborted() + 1);
            report.setAborted(true);
        }
        return report;
    }

    private boolean isTestNGConfigMethod(Testcase testcase, boolean isTestNG) {
        return isTestNG && (testcase.getName().startsWith("@AfterMethod ") || testcase.getName().startsWith("@BeforeMethod ") || testcase.getName().startsWith("@AfterClass ") || testcase.getName().startsWith("@BeforeClass "));
    }

    private SessionResult getUpdatedSessionStats() {
        boolean isTestNG = CommonUtils.getInstance().getTestingFramework().equals("testng");
        long totalTime = 0L;
        SessionResult result = new SessionResult();
        for (Testcase testcase : this.getAllTestCases()) {
            if (this.isTestNGConfigMethod(testcase, isTestNG)) continue;
            totalTime += testcase.getTimeMillis();
            if (testcase.getStatus() == Status.PASSED) {
                result.passed(1);
                continue;
            }
            if (testcase.getStatus() == Status.PASSEDWITHERRORS) {
                result.passedWithErrors(1);
                continue;
            }
            if (testcase.getStatus() == Status.ERROR) {
                result.errors(1);
                continue;
            }
            if (testcase.getStatus() == Status.FAILED) {
                result.failed(1);
                continue;
            }
            if (testcase.getStatus() == Status.PENDING) {
                result.pending(1);
                continue;
            }
            if (testcase.getStatus() == Status.SKIPPED) {
                result.skipped(1);
                continue;
            }
            if (testcase.getStatus() != Status.ABORTED) continue;
            result.aborted(1);
        }
        result.elapsedTime(totalTime);
        return result;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public synchronized long incrementFailuresCount() {
        return ++this.failuresCount;
    }

    public LineConvertors.FileLocator getFileLocator() {
        return this.fileLocator;
    }

    public String getName() {
        return this.name.length() != 0 ? this.name : ProjectUtils.getInformation((Project)this.getProject()).getDisplayName();
    }

    public SessionResult getSessionResult() {
        return this.getUpdatedSessionStats();
    }

    public static enum SessionType {
        TEST,
        DEBUG;

    }

    public static final class SessionResult {
        private int passed;
        private int passedWithErrors;
        private int failed;
        private int errors;
        private int pending;
        private int skipped;
        private int aborted;
        private long elapsedTime;

        private int failed(int failedCount) {
            return this.failed += failedCount;
        }

        private int errors(int errorCount) {
            return this.errors += errorCount;
        }

        private int passed(int passedCount) {
            return this.passed += passedCount;
        }

        private int passedWithErrors(int passedWithErrorsCount) {
            return this.passedWithErrors += passedWithErrorsCount;
        }

        private int pending(int pendingCount) {
            return this.pending += pendingCount;
        }

        private int skipped(int skippedCount) {
            return this.skipped += skippedCount;
        }

        private int aborted(int abortedCount) {
            return this.aborted += abortedCount;
        }

        private long elapsedTime(long time) {
            return this.elapsedTime += time;
        }

        public int getErrors() {
            return this.errors;
        }

        public int getFailed() {
            return this.failed;
        }

        public int getPassed() {
            return this.passed;
        }

        public int getPassedWithErrors() {
            return this.passedWithErrors;
        }

        public int getPending() {
            return this.pending;
        }

        public int getTotal() {
            return this.getPassed() + this.getPassedWithErrors() + this.getFailed() + this.getErrors() + this.getPending() + this.skipped + this.aborted;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }
}

