/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.impl.ClassItemFactory;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.SimpleClassItem;
import org.netbeans.modules.javafx2.editor.completion.model.FxClassUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.text.NbDocument;

final class ValueClassItem
extends SimpleClassItem {
    private static final Logger LOG = Logger.getLogger(ValueClassItem.class.getName());
    private boolean shouldClose;

    public ValueClassItem(CompletionContext ctx, String text, boolean close) {
        super(ctx, text);
        this.shouldClose = close;
    }

    protected boolean isValueAttributePresent() {
        String n = this.ctx.fxAttributeName(this.getAttributeName());
        if (n == null) {
            return false;
        }
        return this.ctx.value(n) != null;
    }

    protected String getAttributeName() {
        return "value";
    }

    @Override
    protected String getSubstituteText() {
        return super.getSubstituteText();
    }

    @Override
    protected void doSubstituteText(JTextComponent c, BaseDocument d, String text) throws BadLocationException {
        super.doSubstituteText(c, d, text);
        if (!this.isValueAttributePresent()) {
            this.addAttribute(c, (Document)d, text);
        } else if (!this.ctx.isTagFinished()) {
            int off = this.getStartOffset() + text.length();
            d.insertString(off, ">", null);
        }
    }

    private void addAttribute(JTextComponent c, Document d, String text) throws BadLocationException {
        String nsPrefix = this.ctx.findFxmlNsPrefix();
        boolean addNsDecl = false;
        if (nsPrefix == null) {
            nsPrefix = this.ctx.findPrefixString("http://javafx.com/fxml/1", "fx");
            addNsDecl = true;
        }
        int start = this.getStartOffset() + text.length();
        Position startPos = NbDocument.createPosition((Document)d, (int)start, (Position.Bias)Position.Bias.Backward);
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        if (this.ctx.isRootElement() && addNsDecl) {
            sb.append(this.createNsDecl(nsPrefix));
        }
        sb.append(this.ctx.createNSName(nsPrefix, this.getAttributeName())).append("=\"");
        int l = sb.length();
        sb.append("\"");
        if (!this.ctx.isTagFinished()) {
            if (this.shouldClose) {
                sb.append("/>");
            } else {
                sb.append(">");
            }
        }
        d.insertString(start, sb.toString(), null);
        if (!this.ctx.isRootElement() && addNsDecl) {
            d.insertString(this.ctx.getRootAttrInsertOffset(), this.createNsDecl(nsPrefix), null);
        }
        c.setCaretPosition(startPos.getOffset() + l);
    }

    private String createNsDecl(String nsPrefix) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(" xmlns:").append(nsPrefix).append("=\"").append("http://javafx.com/fxml/1").append("\" ");
        return sb2.toString();
    }

    protected String getValue() {
        return "";
    }

    static boolean acceptsType(TypeElement elem, CompilationInfo ci) {
        LOG.log(Level.FINE, "Checking class: {0}", elem.getQualifiedName());
        return FxClassUtils.findValueOf(elem, ci) != null;
    }

    @Override
    public String toString() {
        return "value-class[" + this.getFullClassName() + "]";
    }

    public static class Factory
    implements ClassItemFactory {
        @Override
        public CompletionItem convert(TypeElement elem, CompletionContext ctx, int priorityHint) {
            CompilationInfo ci = ctx.getCompilationInfo();
            if (!ValueClassItem.acceptsType(elem, ci)) {
                return null;
            }
            String fqn = elem.getQualifiedName().toString();
            FxBean bean = ctx.getBeanInfo(fqn);
            String n = ctx.getSimpleClassName(fqn);
            if (n == null) {
                n = fqn;
            }
            return SimpleClassItem.setup(new ValueClassItem(ctx, n, bean != null && bean.getPropertyNames().isEmpty()), elem, ctx, priorityHint);
        }
    }
}

