/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.ui;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.jaxb.ui.JAXBBindingInfoPnl;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JAXBWizBindingCfgPanel
implements WizardDescriptor.Panel,
WizardDescriptor.ValidatingPanel,
WizardDescriptor.FinishablePanel {
    public static final int MODE_WIZARD = 0;
    public static final int MODE_EDITING = 1;
    private static final String WIZ_NEW_FILE_TITLE = "NewFileWizard_Title";
    private WizardDescriptor wd = null;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private JAXBBindingInfoPnl bindingInfoPnl = null;
    private List<String> existingSchemaNames = null;
    private File projDir = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public JAXBWizBindingCfgPanel() {
        this.initUI();
    }

    private void initUI() {
        this.bindingInfoPnl = new JAXBBindingInfoPnl(this);
        this.bindingInfoPnl.setName(NbBundle.getMessage(this.getClass(), (String)"LBL_JAXBWizTitle"));
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    public void addChangeListener(ChangeListener cl) {
        this.listeners.add(cl);
    }

    public void validate() throws WizardValidationException {
        this.logger.log(Level.FINEST, "validate() called.");
    }

    private boolean isEmpty(String str) {
        boolean ret = true;
        if (str != null && !"".equals(str.trim())) {
            ret = false;
        }
        return ret;
    }

    private void setError(String msg) {
        this.wd.putProperty("WizardPanel_errorMessage", (Object)msg);
    }

    private boolean isValid(StringBuffer sb) {
        String packageName;
        String url;
        this.logger.log(Level.FINEST, "isValidate() called.");
        boolean valid = true;
        if (this.isEmpty(this.bindingInfoPnl.getSchemaName())) {
            sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_EnterSchemaName"));
            valid = false;
            this.setError(sb.toString());
            return valid;
        }
        String schemaName = this.bindingInfoPnl.getSchemaName();
        if (this.existingSchemaNames != null && this.existingSchemaNames.contains(schemaName)) {
            sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_SchemaNameExists"));
            valid = false;
            this.setError(sb.toString());
            return valid;
        }
        if (schemaName.indexOf(",") > -1 || schemaName.indexOf(".") > -1 || schemaName.indexOf("\\") > -1 || schemaName.indexOf("/") > -1 || schemaName.indexOf(";") > -1 || schemaName.indexOf(":") > -1) {
            sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_InvalidCharInSchemaName"));
            valid = false;
            this.setError(sb.toString());
            return valid;
        }
        if (this.isEmpty(this.bindingInfoPnl.getSchemaFile()) && this.isEmpty(this.bindingInfoPnl.getSchemaURL())) {
            sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_EnterSchemaFileOrURL"));
            valid = false;
            this.setError(sb.toString());
            return valid;
        }
        if (this.bindingInfoPnl.isFromURLSelected() && (this.isEmpty(url = (url = this.bindingInfoPnl.getSchemaURL()) != null ? url.trim() : "") || "http://".equalsIgnoreCase(url))) {
            sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_EnterSchemaFileOrURL"));
            valid = false;
            this.setError(sb.toString());
            return valid;
        }
        if (this.bindingInfoPnl.isFromFSSelected()) {
            String schFl = this.bindingInfoPnl.getSchemaFile();
            schFl = schFl != null ? schFl.trim() : "";
            if (this.isEmpty(schFl)) {
                sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_EnterSchemaFileOrURL"));
                valid = false;
                this.setError(sb.toString());
                return valid;
            }
            File file = null;
            file = schFl.startsWith("\\") || schFl.startsWith("/") || schFl.indexOf(":") == 1 ? new File(schFl) : new File(this.projDir, schFl);
            if (schFl.startsWith(".") || schFl.startsWith("..")) {
                // empty if block
            }
            if (!file.exists()) {
                sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_enterValidSchemaFile"));
                valid = false;
                this.setError(sb.toString());
                return valid;
            }
            if (!file.isFile()) {
                sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_enterValidSchemaFile"));
                valid = false;
                this.setError(sb.toString());
                return valid;
            }
        }
        if (!(this.isEmpty(this.bindingInfoPnl.getPackageName()) || (packageName = this.bindingInfoPnl.getPackageName()).indexOf(",") <= -1 && packageName.indexOf("\\") <= -1 && packageName.indexOf("/") <= -1 && packageName.indexOf(";") <= -1 && packageName.indexOf(":") <= -1)) {
            sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_InvalidCharInPackageName"));
            valid = false;
            this.setError(sb.toString());
            return valid;
        }
        Map<String, Boolean> options = this.bindingInfoPnl.getOptions();
        if (Boolean.TRUE.equals(options.get("-quiet")) && Boolean.TRUE.equals(options.get("-verbose"))) {
            valid = false;
            sb.append(NbBundle.getMessage(this.getClass(), (String)"MSG_CanNotSelectQuietAndVerbose"));
            this.setError(sb.toString());
            return valid;
        }
        if (valid) {
            this.setError(null);
            return valid;
        }
        this.setError(sb.toString());
        return valid;
    }

    public boolean isValid() {
        StringBuffer sb = new StringBuffer();
        return this.isValid(sb);
    }

    public boolean isFinishPanel() {
        return true;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(JAXBWizBindingCfgPanel.class);
    }

    public Component getComponent() {
        return this.bindingInfoPnl;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1: {
                break;
            }
        }
    }

    public void fireChangeEvent() {
        ChangeEvent che = new ChangeEvent(this);
        try {
            for (ChangeListener cl : this.listeners) {
                cl.stateChanged(che);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "fireChangeEvent()", ex);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wdNew = (WizardDescriptor)settings;
        wdNew.putProperty(WIZ_NEW_FILE_TITLE, null);
        if (this.bindingInfoPnl.getSchemaName() != null) {
            wdNew.putProperty("schema.name", (Object)this.bindingInfoPnl.getSchemaName());
        }
        if (this.bindingInfoPnl.getPackageName() != null) {
            wdNew.putProperty("xsd.package.name", (Object)this.bindingInfoPnl.getPackageName());
        }
        if (this.bindingInfoPnl.getSchemaType() != null) {
            wdNew.putProperty("jaxb.schema.type", (Object)this.bindingInfoPnl.getSchemaType());
        }
        Map<String, Boolean> options = this.bindingInfoPnl.getOptions();
        wdNew.putProperty("jaxb.xjc.options", options);
        ArrayList<String> xsdFileList = new ArrayList<String>();
        String schemaLoc = this.bindingInfoPnl.getSchemaFile();
        if (schemaLoc == null) {
            xsdFileList.add(this.bindingInfoPnl.getSchemaURL());
            wdNew.putProperty("xsd.locatiom.type", (Object)"url");
        } else {
            xsdFileList.add(this.bindingInfoPnl.getSchemaFile());
            wdNew.putProperty("xsd.locatiom.type", (Object)"fileSystem");
        }
        wdNew.putProperty("xsd.file.list", xsdFileList);
        List<String> bindings = this.bindingInfoPnl.getBindingFiles();
        wdNew.putProperty("jaxb.binding.files", bindings);
        String catalogFile = this.bindingInfoPnl.getCatalogFile();
        wdNew.putProperty("jaxb.catalog.file", (Object)catalogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings(Object settings) {
        try {
            String catalog;
            List bindingFileList;
            Map options;
            this.wd = (WizardDescriptor)settings;
            this.bindingInfoPnl.setInitializing(true);
            if (this.wd.getProperty("schema.name") != null) {
                this.bindingInfoPnl.setSchemaName((String)this.wd.getProperty("schema.name"));
            }
            if (this.wd.getProperty("project.name") != null) {
                this.bindingInfoPnl.setProjectName((String)this.wd.getProperty("project.name"));
            }
            if (this.wd.getProperty("project.dir") != null) {
                this.bindingInfoPnl.setProjectDir((File)this.wd.getProperty("project.dir"));
                this.projDir = (File)this.wd.getProperty("project.dir");
            }
            if (this.wd.getProperty("xsd.package.name") != null) {
                this.bindingInfoPnl.setPackageName((String)this.wd.getProperty("xsd.package.name"));
            }
            if (this.wd.getProperty("jaxb.schema.type") != null) {
                this.bindingInfoPnl.setSchemaType((String)this.wd.getProperty("jaxb.schema.type"));
            }
            if ((options = (Map)this.wd.getProperty("jaxb.xjc.options")) != null) {
                this.bindingInfoPnl.setOptions(options);
            }
            String origSrcLocType = (String)this.wd.getProperty("xsd.locatiom.type");
            List xsdFileList = (List)this.wd.getProperty("xsd.file.list");
            if (origSrcLocType != null && "url".equals(origSrcLocType)) {
                if (xsdFileList != null && xsdFileList.size() > 0) {
                    itr = xsdFileList.iterator();
                    file = (String)itr.next();
                    this.bindingInfoPnl.setSchemaURL(file);
                }
            } else if (xsdFileList != null && xsdFileList.size() > 0) {
                itr = xsdFileList.iterator();
                file = (String)itr.next();
                this.bindingInfoPnl.setSchemaFile(file);
            }
            if ((bindingFileList = (List)this.wd.getProperty("jaxb.binding.files")) != null) {
                this.bindingInfoPnl.setBindingFiles(bindingFileList);
            }
            if ((catalog = (String)this.wd.getProperty("jaxb.catalog.file")) != null) {
                this.bindingInfoPnl.setCatalogFile(catalog);
            }
            this.existingSchemaNames = (List)this.wd.getProperty("jaxb.cfg.existingSchemaNames");
            if (this.wd instanceof TemplateWizard) {
                this.wd.putProperty(WIZ_NEW_FILE_TITLE, (Object)NbBundle.getMessage(this.getClass(), (String)"LBL_TemplateWizardTitle"));
            }
        }
        finally {
            this.bindingInfoPnl.setInitializing(false);
        }
    }
}

