/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import java.io.Serializable;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;

public class ExternalIdentifierImpl
extends RegistryObjectImpl
implements ExternalIdentifier,
Serializable {
    private String value;
    private RegistryObject registryObject;
    private ClassificationScheme identificationScheme;

    public ExternalIdentifierImpl() {
    }

    public ExternalIdentifierImpl(Key key, String name, String value) {
        this();
        this.key = key;
        this.name = new InternationalStringImpl(name);
        this.value = value;
        try {
            if (this.keyFieldsSet()) {
                this.createKey();
            }
        }
        catch (JAXRException jAXRException) {
            // empty catch block
        }
    }

    public ExternalIdentifierImpl(ClassificationScheme identificationScheme, String name, String value) {
        this();
        this.identificationScheme = identificationScheme;
        this.name = new InternationalStringImpl(name);
        this.value = value;
        try {
            if (this.keyFieldsSet()) {
                this.createKey();
            }
        }
        catch (JAXRException jAXRException) {
            // empty catch block
        }
    }

    public RegistryObject getRegistryObject() throws JAXRException {
        return this.registryObject;
    }

    public void setRegistryObject(RegistryObject registryObject) throws JAXRException {
        this.registryObject = registryObject;
        if (this.keyFieldsSet()) {
            this.createKey();
        }
    }

    public String getValue() throws JAXRException {
        return this.value;
    }

    public void setValue(String value) throws JAXRException {
        this.value = value;
        this.setIsModified(true);
        if (this.keyFieldsSet()) {
            this.createKey();
        }
    }

    public ClassificationScheme getIdentificationScheme() throws JAXRException {
        return this.identificationScheme;
    }

    public void setIdentificationScheme(ClassificationScheme classificationScheme) throws JAXRException {
        this.identificationScheme = classificationScheme;
        this.setIsModified(true);
        if (this.keyFieldsSet()) {
            this.createKey();
        }
    }

    boolean keyFieldsSet() throws JAXRException {
        boolean set = true;
        if (this.isRetrieved() && (this.registryObject == null || this.identificationScheme == null || this.value == null)) {
            set = false;
            if (this.registryObject.getKey() == null || this.identificationScheme.getKey() == null) {
                set = false;
            }
        }
        return set;
    }

    Key createKey() throws JAXRException {
        String registryObjectId = null;
        String identificationSchemeId = null;
        if (this.isRetrieved()) {
            if (this.registryObject != null) {
                registryObjectId = this.registryObject.getKey().getId();
            }
            if (this.identificationScheme != null) {
                identificationSchemeId = this.identificationScheme.getKey().getId();
            }
        }
        StringBuffer buf = new StringBuffer(400);
        buf.append(registryObjectId);
        buf.append(":");
        buf.append(identificationSchemeId);
        buf.append(":");
        buf.append(this.value);
        this.key = new KeyImpl(buf.toString());
        return this.key;
    }
}

