/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.print.provider.ComponentLine;
import org.netbeans.modules.print.util.Config;

final class ComponentDocument
extends JComponent {
    private int[] myCorrection;
    private int[] myAscent;
    private int[] myDescent;
    private int[] myLeading;
    private int myMinOffset;
    private Font myTextFont;
    private int myWidth;
    private int myHeight;
    private Color myBackgroundColor;
    private Color myTextColor;
    private double myLineSpacing;
    private boolean myWrapLines;
    private boolean myLineNumbers;
    private List<ComponentLine> myLines;

    ComponentDocument(String text) {
        this.init();
        this.prepare(text);
        this.perform();
    }

    ComponentDocument(AttributedCharacterIterator[] iterators) {
        this.init();
        this.prepare(iterators);
        this.perform();
    }

    private void init() {
        this.myWrapLines = Config.getDefault().isWrapLines();
        this.myLineNumbers = Config.getDefault().isLineNumbers();
        this.myTextColor = Config.getDefault().getTextColor();
        this.myTextFont = Config.getDefault().getTextFont();
        this.myBackgroundColor = Config.getDefault().getBackgroundColor();
        this.myLineSpacing = Config.getDefault().getLineSpacing();
        this.myLines = new ArrayList<ComponentLine>();
    }

    private void prepare(String text) {
        LineTokenizer stk = new LineTokenizer(text);
        while (stk.hasMoreTokens()) {
            ComponentLine line = new ComponentLine(this.trimEnded(stk.nextToken()), this.myTextFont, this.myTextColor);
            this.myLines.add(line);
        }
    }

    private void prepare(AttributedCharacterIterator[] iterators) {
        for (AttributedCharacterIterator iterator : iterators) {
            ComponentLine line = new ComponentLine(iterator, this.myTextFont, this.myTextColor);
            this.myLines.add(line);
        }
    }

    private void perform() {
        this.removeEmptyLinesAtTheEnd();
        if (this.myLineNumbers) {
            this.prepareLineNumbering();
        }
        this.calculateOffset();
        if (this.myWrapLines) {
            this.prepareWrapLines();
        } else {
            this.prepareNoWrapLines();
        }
        this.calculateMetrics();
    }

    private void removeEmptyLinesAtTheEnd() {
        ComponentLine line;
        int i = this.myLines.size() - 1;
        while (i >= 0 && (line = this.myLines.get(i--)).isEmpty()) {
            this.myLines.remove(line);
        }
    }

    private String trimEnded(String value) {
        int i;
        for (i = value.length() - 1; i >= 0 && value.charAt(i) == ' '; --i) {
        }
        return value.substring(0, i + 1);
    }

    private void prepareLineNumbering() {
        int length = ("" + this.myLines.size()).length();
        int number = 1;
        for (ComponentLine line : this.myLines) {
            line.prepend(this.getNumber(number++, length));
        }
    }

    private void prepareNoWrapLines() {
        int maxWidth = 0;
        for (ComponentLine line : this.myLines) {
            int width = line.getWidth();
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        this.myWidth = maxWidth + this.myMinOffset;
    }

    private void prepareWrapLines() {
        this.myWidth = Config.getDefault().getPageWidth();
        ArrayList<ComponentLine> lines = new ArrayList<ComponentLine>();
        for (ComponentLine line : this.myLines) {
            if (line.getWidth() + this.myMinOffset <= this.myWidth) {
                lines.add(line);
                continue;
            }
            this.addWordWrappedLine(lines, line);
        }
        this.myLines = lines;
    }

    private void addWordWrappedLine(List<ComponentLine> lines, ComponentLine line) {
        block5: {
            int k;
            ComponentLine part;
            if (line.getWidth() + this.myMinOffset <= this.myWidth) {
                lines.add(line);
                return;
            }
            int last = line.length();
            do {
                if ((k = line.lastIndexOf(' ', last - 1)) == -1) {
                    this.addCharWrappedLine(lines, line);
                    break block5;
                }
                last = k;
                part = line.substring(0, k);
                this.checkOffset(part);
            } while (part.getWidth() + this.myMinOffset > this.myWidth);
            if (part.isEmpty()) {
                this.addCharWrappedLine(lines, line);
            } else {
                lines.add(part);
                part = line.substring(k + 1);
                this.checkOffset(part);
                this.addWordWrappedLine(lines, part);
            }
        }
    }

    private void addCharWrappedLine(List<ComponentLine> lines, ComponentLine line) {
        if (line.getWidth() + this.myMinOffset <= this.myWidth) {
            lines.add(line);
            return;
        }
        for (int k = line.length(); k >= 0; --k) {
            ComponentLine part = line.substring(0, k);
            this.checkOffset(part);
            if (part.getWidth() + this.myMinOffset > this.myWidth) continue;
            lines.add(part);
            part = line.substring(k);
            this.checkOffset(part);
            this.addCharWrappedLine(lines, part);
            break;
        }
    }

    private void checkOffset(ComponentLine line) {
        int offset = -line.getOffset();
        if (offset > this.myMinOffset) {
            this.myMinOffset = offset;
        }
    }

    private void calculateOffset() {
        this.myMinOffset = 0;
        for (ComponentLine line : this.myLines) {
            this.checkOffset(line);
        }
    }

    private void calculateMetrics() {
        int pageHeight;
        this.myHeight = 0;
        int size = this.myLines.size();
        this.myAscent = new int[size];
        this.myDescent = new int[size];
        this.myLeading = new int[size];
        this.myCorrection = new int[size];
        int breakPosition = pageHeight = Config.getDefault().getPageHeight();
        for (int i = 0; i < size; ++i) {
            ComponentLine line = this.myLines.get(i);
            this.myAscent[i] = (int)Math.round((double)line.getAscent() * this.myLineSpacing);
            this.myDescent[i] = line.getDescent();
            this.myCorrection[i] = 0;
            int prevPos = this.myHeight;
            this.myHeight += this.myAscent[i] + this.myDescent[i];
            if (this.myHeight > breakPosition && prevPos < breakPosition) {
                this.myCorrection[i] = breakPosition - prevPos;
                this.myHeight += this.myCorrection[i];
                breakPosition += pageHeight;
            }
            if (i == size - 1) continue;
            this.myLeading[i] = line.getLeading();
            this.myHeight += this.myLeading[i];
        }
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public int getHeight() {
        return this.myHeight;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = Config.getDefault().getGraphics(graphics);
        g.setColor(this.myBackgroundColor);
        g.fillRect(0, 0, this.myWidth, this.myHeight);
        int y = 0;
        for (int i = 0; i < this.myLines.size(); ++i) {
            ComponentLine line = this.myLines.get(i);
            line.draw(g, this.myMinOffset, y += this.myCorrection[i] + this.myAscent[i]);
            y += this.myDescent[i] + this.myLeading[i];
        }
    }

    private String getNumber(int number, int length) {
        StringBuilder builder = new StringBuilder();
        builder.append(number);
        for (int i = builder.length(); i < length; ++i) {
            builder.insert(0, " ");
        }
        builder.append(" ");
        return builder.toString();
    }

    private static final class LineTokenizer {
        private int myPos;
        private int myLength;
        private String myValue;
        private StringBuilder myBuilder;

        public LineTokenizer(String value) {
            this.myValue = value;
            this.myLength = value.length();
            this.myBuilder = new StringBuilder();
        }

        public boolean hasMoreTokens() {
            return this.myPos < this.myLength;
        }

        public String nextToken() {
            this.myBuilder.setLength(0);
            String separator = "";
            while (this.myPos < this.myLength) {
                char c = this.myValue.charAt(this.myPos);
                ++this.myPos;
                if (c == '\r' || c == '\n') {
                    if (c != '\r' || this.myPos >= this.myLength || this.myValue.charAt(this.myPos) != '\n') break;
                    ++this.myPos;
                    break;
                }
                this.myBuilder.append(c);
            }
            return this.myBuilder.toString();
        }
    }
}

