/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.analysis.AnalysisProblem;
import org.netbeans.modules.analysis.AnalysisResult;
import org.netbeans.modules.analysis.Bundle;
import org.netbeans.modules.analysis.Configuration;
import org.netbeans.modules.analysis.RunAnalysisAction;
import org.netbeans.modules.analysis.RunAnalysisPanel;
import org.netbeans.modules.analysis.SPIAccessor;
import org.netbeans.modules.analysis.spi.AnalysisScopeProvider;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.analysis.ui.AnalysisProblemNode;
import org.netbeans.modules.analysis.ui.AnalysisResultTopComponent;
import org.netbeans.modules.analysis.ui.RequiredPluginsNode;
import org.netbeans.modules.parsing.spi.indexing.PathRecognizer;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class RunAnalysis {
    private static final Logger LOG = Logger.getLogger(RunAnalysis.class.getName());
    private static final RequestProcessor WORKER = new RequestProcessor(RunAnalysisAction.class.getName(), 1, false, false);
    private static final int MAX_WORK = 1000;

    public static void showDialogAndRunAnalysis() {
        RunAnalysis.showDialogAndRunAnalysis(Lookups.fixed((Object[])Utilities.actionsGlobalContext().lookupAll(Object.class).toArray(new Object[0])), null);
    }

    public static void showDialogAndRunAnalysis(final Lookup context, RunAnalysisPanel.DialogState startingState) {
        final ProgressHandle progress = ProgressHandle.createHandle((String)"Analyzing...", null, null);
        final JButton runAnalysis = new JButton(Bundle.BN_Inspect());
        final RunAnalysisPanel rap = new RunAnalysisPanel(progress, context, runAnalysis, startingState);
        JButton cancel = new JButton(Bundle.BN_Cancel());
        HelpCtx helpCtx = new HelpCtx("org.netbeans.modules.analysis.RunAnalysis");
        DialogDescriptor dd = new DialogDescriptor((Object)rap, Bundle.TL_Inspect(), true, new Object[]{runAnalysis, cancel}, (Object)runAnalysis, 0, helpCtx, null);
        dd.setClosingOptions(new Object[0]);
        final Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        final AtomicBoolean doCancel = new AtomicBoolean();
        final AtomicReference currentlyRunning = new AtomicReference();
        runAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final long analysisStart = System.currentTimeMillis();
                runAnalysis.setEnabled(false);
                final Analyzer.AnalyzerFactory toRun = rap.getSelectedAnalyzer();
                final Configuration configuration = rap.getConfiguration();
                final String singleWarningId = rap.getSingleWarningId();
                final Collection<? extends Analyzer.AnalyzerFactory> analyzers = rap.getAnalyzers();
                final RunAnalysisPanel.DialogState dialogState = rap.getDialogState();
                final RunAnalysisPanel.FutureWarnings analyzerId2Description = rap.getAnalyzerId2Description();
                rap.started();
                progress.start();
                WORKER.post(new Runnable(){

                    @Override
                    public void run() {
                        dialogState.save();
                        Scope scope = rap.getSelectedScope(doCancel);
                        progress.switchToDeterminate(1000);
                        final HashMap<Analyzer.AnalyzerFactory, List<ErrorDescription>> result = new HashMap<Analyzer.AnalyzerFactory, List<ErrorDescription>>();
                        final IdentityHashMap<ErrorDescription, Project> errorsToProjects = new IdentityHashMap<ErrorDescription, Project>();
                        ArrayList<Analyzer.MissingPlugin> missingPlugins = new ArrayList<Analyzer.MissingPlugin>();
                        ArrayList<AnalysisProblem> additionalProblems = new ArrayList<AnalysisProblem>();
                        if (toRun == null) {
                            int doneSoFar = 0;
                            int bucketSize = 1000 / analyzers.size();
                            for (Analyzer.AnalyzerFactory analyzer : analyzers) {
                                if (!doCancel.get()) {
                                    this.doRunAnalyzer(analyzer, scope, progress, doneSoFar, bucketSize, result, errorsToProjects, missingPlugins, additionalProblems);
                                    doneSoFar += bucketSize;
                                    continue;
                                }
                                break;
                            }
                        } else if (!doCancel.get()) {
                            this.doRunAnalyzer(toRun, scope, progress, 0, 1000, result, errorsToProjects, missingPlugins, additionalProblems);
                        }
                        final ArrayList<AbstractNode> extraNodes = new ArrayList<AbstractNode>();
                        if (!missingPlugins.isEmpty()) {
                            extraNodes.add(new RequiredPluginsNode(missingPlugins));
                        }
                        for (AnalysisProblem p : additionalProblems) {
                            extraNodes.add(new AnalysisProblemNode(p));
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!doCancel.get()) {
                                    AnalysisResultTopComponent resultWindow = AnalysisResultTopComponent.findInstance();
                                    resultWindow.setData(context, dialogState, new AnalysisResult(result, errorsToProjects, analyzerId2Description, extraNodes));
                                    resultWindow.open();
                                    resultWindow.requestActive();
                                }
                                d.setVisible(false);
                                d.dispose();
                                LOG.log(Level.FINE, "Total analysis time: {0}", System.currentTimeMillis() - analysisStart);
                            }
                        });
                    }

                    private void doRunAnalyzer(Analyzer.AnalyzerFactory analyzer, Scope scope, ProgressHandle handle, int bucketStart, int bucketSize, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>> result, Map<ErrorDescription, Project> errorsToProjects, Collection<Analyzer.MissingPlugin> missingPlugins, Collection<AnalysisProblem> additionalProblems) {
                        ArrayList<ErrorDescription> current = new ArrayList<ErrorDescription>();
                        Preferences settings = configuration != null ? configuration.getPreferences().node(SPIAccessor.ACCESSOR.getAnalyzerId(analyzer)) : null;
                        Analyzer.Context context = SPIAccessor.ACCESSOR.createContext(scope, settings, singleWarningId, handle, bucketStart, bucketSize);
                        Analyzer.Result resCollector = SPIAccessor.ACCESSOR.createResult(current, errorsToProjects, additionalProblems);
                        Collection<? extends Analyzer.MissingPlugin> requiredPlugins = analyzer.requiredPlugins(context);
                        if (!requiredPlugins.isEmpty()) {
                            missingPlugins.addAll(requiredPlugins);
                            return;
                        }
                        Analyzer a = analyzer.createAnalyzer(context, resCollector);
                        currentlyRunning.set(a);
                        if (doCancel.get()) {
                            return;
                        }
                        long s = System.currentTimeMillis();
                        for (ErrorDescription errorDescription : a.analyze()) {
                            current.add(errorDescription);
                        }
                        LOG.log(Level.FINE, "Analysis by {0} took {1}", new Object[]{SPIAccessor.ACCESSOR.getAnalyzerDisplayName(analyzer), System.currentTimeMillis() - s});
                        currentlyRunning.set(null);
                        if (!current.isEmpty()) {
                            result.put(analyzer, current);
                        }
                        additionalProblems.addAll(SPIAccessor.ACCESSOR.getAnalysisProblems(context));
                    }
                });
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                doCancel.set(true);
                Analyzer a = (Analyzer)currentlyRunning.get();
                if (a != null) {
                    a.cancel();
                }
                d.setVisible(false);
                d.dispose();
            }
        });
        d.setVisible(true);
    }

    static Map<Project, Map<FileObject, ClassPath>> projects2RegisteredContent(AtomicBoolean cancel) {
        HashSet sourceIds = new HashSet();
        for (PathRecognizer pr : Lookup.getDefault().lookupAll(PathRecognizer.class)) {
            Set ids = pr.getSourcePathIds();
            if (ids == null) continue;
            sourceIds.addAll(ids);
        }
        IdentityHashMap<Project, Map<FileObject, ClassPath>> sourceRoots = new IdentityHashMap<Project, Map<FileObject, ClassPath>>();
        for (String id : sourceIds) {
            for (ClassPath sCP : GlobalPathRegistry.getDefault().getPaths(id)) {
                for (FileObject root : sCP.getRoots()) {
                    if (cancel.get()) {
                        return null;
                    }
                    Project owner = FileOwnerQuery.getOwner((FileObject)root);
                    if (owner == null) continue;
                    HashMap<FileObject, ClassPath> projectSources = (HashMap<FileObject, ClassPath>)sourceRoots.get(owner);
                    if (projectSources == null) {
                        projectSources = new HashMap<FileObject, ClassPath>();
                        sourceRoots.put(owner, projectSources);
                    }
                    projectSources.put(root, sCP);
                }
            }
        }
        return sourceRoots;
    }

    static Scope addProjectToScope(Project p, Scope target, AtomicBoolean cancel, Map<Project, Map<FileObject, ClassPath>> projects2RegisteredContent) {
        Scope projectScope = (Scope)p.getLookup().lookup(Scope.class);
        if (projectScope == null) {
            AnalysisScopeProvider scopeProvider = (AnalysisScopeProvider)p.getLookup().lookup(AnalysisScopeProvider.class);
            Scope scope = projectScope = scopeProvider != null ? scopeProvider.getScope() : null;
        }
        if (projectScope != null) {
            return RunAnalysis.augment(target, projectScope.getSourceRoots(), projectScope.getFolders(), projectScope.getFiles());
        }
        Map<FileObject, ClassPath> roots = projects2RegisteredContent.get(p);
        if (roots != null) {
            for (Map.Entry<FileObject, ClassPath> e : roots.entrySet()) {
                if (cancel.get()) {
                    return null;
                }
                target = RunAnalysis.augment(target, Collections.singletonList(e.getKey()), null, null);
            }
        }
        return target;
    }

    @NonNull
    private static Scope augment(@NonNull Scope source, @NullAllowed Collection<FileObject> sourceRoots, @NullAllowed Collection<NonRecursiveFolder> folders, @NullAllowed Collection<FileObject> files) {
        HashSet<FileObject> sourceRootsSet = new HashSet<FileObject>(source.getSourceRoots());
        if (sourceRoots != null) {
            sourceRootsSet.addAll(sourceRoots);
        }
        HashSet<FileObject> filesSet = new HashSet<FileObject>(source.getFiles());
        if (files != null) {
            filesSet.addAll(files);
        }
        HashSet<NonRecursiveFolder> foldersSet = new HashSet<NonRecursiveFolder>(source.getFolders());
        if (folders != null) {
            foldersSet.addAll(folders);
        }
        return Scope.create(sourceRootsSet, foldersSet, filesSet);
    }
}

