/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.tools.JavaFileObject;

class WarningAggregator {
    private final Log log;
    private final Source source;
    private final String prefix;
    private Set<JavaFileObject> sourcesWithReportedWarnings;
    private DeferredDiagnosticKind deferredDiagnosticKind;
    private JavaFileObject deferredDiagnosticSource;
    private Object deferredDiagnosticArg;
    private boolean anyWarningEmitted;
    private final Lint.LintCategory lintCategory;

    public WarningAggregator(Log log, Source source, Lint.LintCategory lc) {
        this(log, source, lc, null);
    }

    public WarningAggregator(Log log, Source source, Lint.LintCategory lc, String prefix) {
        this.log = log;
        this.source = source;
        this.prefix = prefix != null ? prefix : lc.option;
        this.lintCategory = lc;
    }

    public boolean aggregate(JCDiagnostic diagnostic, boolean verbose) {
        Assert.check(diagnostic.getLintCategory() == this.lintCategory);
        JavaFileObject currentSource = this.log.currentSourceFile();
        if (verbose) {
            if (this.sourcesWithReportedWarnings == null) {
                this.sourcesWithReportedWarnings = new HashSet<JavaFileObject>();
            }
            if (this.log.nwarnings < this.log.MaxWarnings) {
                this.sourcesWithReportedWarnings.add(currentSource);
                this.anyWarningEmitted = true;
                return true;
            }
            if (this.deferredDiagnosticKind == null) {
                this.deferredDiagnosticKind = this.sourcesWithReportedWarnings.contains(currentSource) ? DeferredDiagnosticKind.ADDITIONAL_IN_FILE : DeferredDiagnosticKind.IN_FILE;
                this.deferredDiagnosticSource = currentSource;
                this.deferredDiagnosticArg = currentSource;
            } else if (!(this.deferredDiagnosticKind != DeferredDiagnosticKind.IN_FILE && this.deferredDiagnosticKind != DeferredDiagnosticKind.ADDITIONAL_IN_FILE || Objects.equals(this.deferredDiagnosticSource, currentSource))) {
                this.deferredDiagnosticKind = DeferredDiagnosticKind.ADDITIONAL_IN_FILES;
                this.deferredDiagnosticArg = null;
            }
        } else if (this.deferredDiagnosticKind == null) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILE;
            this.deferredDiagnosticSource = currentSource;
            this.deferredDiagnosticArg = currentSource;
        } else if (this.deferredDiagnosticKind == DeferredDiagnosticKind.IN_FILE && !Objects.equals(this.deferredDiagnosticSource, currentSource)) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILES;
            this.deferredDiagnosticArg = null;
        }
        return false;
    }

    public List<JCDiagnostic> aggregationNotes() {
        ArrayList<JCDiagnostic> list = new ArrayList<JCDiagnostic>(2);
        if (this.deferredDiagnosticKind != null) {
            if (this.deferredDiagnosticArg == null) {
                if (this.source != null) {
                    this.addNote(list, this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[]{this.source});
                } else {
                    this.addNote(list, this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[0]);
                }
            } else if (this.source != null) {
                this.addNote(list, this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[]{this.deferredDiagnosticArg, this.source});
            } else {
                this.addNote(list, this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), this.deferredDiagnosticArg);
            }
            if (!this.anyWarningEmitted) {
                this.addNote(list, this.deferredDiagnosticSource, this.prefix + ".recompile", new Object[0]);
            }
        }
        return list;
    }

    private void addNote(List<JCDiagnostic> list, JavaFileObject file, String msg, Object ... args) {
        list.add(this.log.diags.note(JCDiagnostic.DiagnosticFlag.MANDATORY, this.log.getSource(file), null, new JCDiagnostic.Note(null, "compiler", msg, args)));
    }

    public void clear() {
        this.sourcesWithReportedWarnings = null;
        this.deferredDiagnosticKind = null;
        this.deferredDiagnosticSource = null;
        this.deferredDiagnosticArg = null;
    }

    private static enum DeferredDiagnosticKind {
        IN_FILE(".filename"),
        ADDITIONAL_IN_FILE(".filename.additional"),
        IN_FILES(".plural"),
        ADDITIONAL_IN_FILES(".plural.additional");

        private final String value;

        private DeferredDiagnosticKind(String v) {
            this.value = v;
        }

        String getKey(String prefix) {
            return prefix + this.value;
        }
    }
}

