/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.LintMapper;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.util.AbstractLog;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.RawDiagnosticFormatter;
import com.sun.tools.javac.util.WarningAggregator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class Log
extends AbstractLog {
    public static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public static final Context.Key<PrintWriter> errKey = new Context.Key();
    private final Map<WriterKind, PrintWriter> writers;
    protected int MaxErrors;
    protected int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean suppressNotes;
    public boolean dumpOnError;
    protected DiagnosticListener<? super JavaFileObject> diagListener;
    private DiagnosticFormatter<JCDiagnostic> diagFormatter;
    public Set<String> expectDiagKeys;
    public boolean compressedOutput;
    private JavacMessages messages;
    private final Context context;
    private final Options options;
    private final LintMapper lintMapper;
    private Lint rootLint;
    private DiagnosticHandler diagnosticHandler;
    public int nerrors = 0;
    public int nwarnings = 0;
    public final EnumSet<Lint.LintCategory> lintWarnings = Lint.LintCategory.newEmptySet();
    public int nsuppressederrors = 0;
    public int nsuppressedwarns = 0;
    protected Set<Pair<JavaFileObject, Integer>> recorded = new HashSet<Pair<JavaFileObject, Integer>>();
    protected Set<Pair<JavaFileObject, List<String>>> recordedSourceLevelErrors = new HashSet<Pair<JavaFileObject, List<String>>>();
    private final EnumMap<Lint.LintCategory, WarningAggregator> aggregators = new EnumMap(Lint.LintCategory.class);
    private final EnumSet<Lint.LintCategory> suppressedDeferredMandatory = EnumSet.noneOf(Lint.LintCategory.class);
    private static boolean useRawMessages = false;

    public static Log instance(Context context) {
        Log instance = context.get(logKey);
        if (instance == null) {
            instance = new Log(context);
        }
        return instance;
    }

    public static void preRegister(Context context, PrintWriter w) {
        context.put(Log.class, c -> new Log(c, w));
    }

    protected Log(Context context) {
        this(context, Log.initWriters(context));
    }

    private static Map<WriterKind, PrintWriter> initWriters(Context context) {
        PrintWriter out = context.get(outKey);
        PrintWriter err = context.get(errKey);
        if (out == null && err == null) {
            out = new PrintWriter(System.out, true);
            err = new PrintWriter(System.err, true);
            return Log.initWriters(out, err);
        }
        if (out == null || err == null) {
            PrintWriter pw = out != null ? out : err;
            return Log.initWriters(pw, pw);
        }
        return Log.initWriters(out, err);
    }

    protected Log(Context context, PrintWriter writer) {
        this(context, Log.initWriters(writer, writer));
    }

    protected Log(Context context, PrintWriter out, PrintWriter err) {
        this(context, Log.initWriters(out, err));
    }

    private static Map<WriterKind, PrintWriter> initWriters(PrintWriter out, PrintWriter err) {
        EnumMap<WriterKind, PrintWriter> writers = new EnumMap<WriterKind, PrintWriter>(WriterKind.class);
        writers.put(WriterKind.ERROR, err);
        writers.put(WriterKind.WARNING, err);
        writers.put(WriterKind.NOTICE, err);
        writers.put(WriterKind.STDOUT, out);
        writers.put(WriterKind.STDERR, err);
        return writers;
    }

    private Log(Context context, Map<WriterKind, PrintWriter> writers) {
        super(JCDiagnostic.Factory.instance(context));
        DiagnosticListener dl;
        context.put(logKey, this);
        this.context = context;
        this.options = Options.instance(context);
        this.lintMapper = LintMapper.instance(context);
        this.writers = writers;
        this.diagListener = dl = context.get(DiagnosticListener.class);
        this.diagnosticHandler = new DefaultDiagnosticHandler();
        this.messages = JavacMessages.instance(context);
        this.messages.add("com.sun.tools.javac.resources.javac");
        this.emitWarnings = true;
        this.MaxErrors = this.getDefaultMaxErrors();
        this.MaxWarnings = this.getDefaultMaxWarnings();
        this.diagFormatter = new BasicDiagnosticFormatter(this.messages);
        this.options.whenReady(this::initOptions);
    }

    private void initOptions(Options options) {
        this.dumpOnError = options.isSet(Option.DOE);
        this.promptOnError = options.isSet(Option.PROMPT);
        this.emitWarnings = options.isUnset(Option.NOWARN);
        this.suppressNotes = options.isSet("suppressNotes");
        this.MaxErrors = this.getIntOption(options, Option.XMAXERRS, this.getDefaultMaxErrors());
        this.MaxWarnings = this.getIntOption(options, Option.XMAXWARNS, this.getDefaultMaxWarnings());
        boolean rawDiagnostics = options.isSet("rawDiagnostics");
        this.diagFormatter = rawDiagnostics ? new RawDiagnosticFormatter(options) : new BasicDiagnosticFormatter(options, this.messages);
        String ek = options.get("expectKeys");
        if (ek != null) {
            this.expectDiagKeys = new HashSet<String>(Arrays.asList(ek.split(", *")));
        }
    }

    private int getIntOption(Options options, Option option, int defaultValue) {
        String s = options.get(option);
        try {
            if (s != null) {
                int n = Integer.parseInt(s);
                return n <= 0 ? Integer.MAX_VALUE : n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    protected int getDefaultMaxErrors() {
        return 100;
    }

    protected int getDefaultMaxWarnings() {
        return 100;
    }

    public boolean hasDiagnosticListener() {
        return this.diagListener != null;
    }

    public void setEndPosTable(JavaFileObject name, EndPosTable endPosTable) {
        Assert.checkNonNull(name);
        this.getSource(name).setEndPosTable(endPosTable);
    }

    public JavaFileObject currentSourceFile() {
        return this.source == null ? null : this.source.getFile();
    }

    public DiagnosticFormatter<JCDiagnostic> getDiagnosticFormatter() {
        return this.diagFormatter;
    }

    public void setDiagnosticFormatter(DiagnosticFormatter<JCDiagnostic> diagFormatter) {
        this.diagFormatter = diagFormatter;
    }

    public PrintWriter getWriter(WriterKind kind) {
        return this.writers.get((Object)kind);
    }

    public void setWriter(WriterKind kind, PrintWriter pw) {
        Assert.checkNonNull(pw);
        this.writers.put(kind, pw);
    }

    public void setWriters(PrintWriter pw) {
        Assert.checkNonNull(pw);
        for (WriterKind k : WriterKind.values()) {
            this.writers.put(k, pw);
        }
    }

    public void popDiagnosticHandler(DiagnosticHandler h) {
        Assert.check(this.diagnosticHandler == h);
        Assert.check(h.prev != null);
        this.diagnosticHandler = h.prev;
    }

    public void flush() {
        for (PrintWriter pw : this.writers.values()) {
            pw.flush();
        }
    }

    public void flush(WriterKind kind) {
        this.getWriter(kind).flush();
    }

    protected boolean shouldReport(JavaFileObject file, int pos) {
        boolean shouldReport;
        if (file == null) {
            return true;
        }
        Pair<JavaFileObject, Integer> coords = new Pair<JavaFileObject, Integer>(file, pos);
        boolean bl = shouldReport = !this.recorded.contains(coords);
        if (shouldReport) {
            this.recorded.add(coords);
        }
        return shouldReport;
    }

    private boolean shouldReport(JCDiagnostic d) {
        boolean shouldReport;
        JavaFileObject file = d.getSource();
        if (file == null) {
            return true;
        }
        if (!this.shouldReport(file, d.getIntPosition())) {
            return false;
        }
        if (!d.isFlagSet(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL)) {
            return true;
        }
        Pair<JavaFileObject, List<String>> coords = new Pair<JavaFileObject, List<String>>(file, this.getCode(d));
        boolean bl = shouldReport = !this.recordedSourceLevelErrors.contains(coords);
        if (shouldReport) {
            this.recordedSourceLevelErrors.add(coords);
        }
        return shouldReport;
    }

    private List<String> getCode(JCDiagnostic d) {
        ListBuffer<String> buf = new ListBuffer<String>();
        this.getCodeRecursive(buf, d);
        return buf.toList();
    }

    private void getCodeRecursive(ListBuffer<String> buf, JCDiagnostic d) {
        buf.add(d.getCode());
        for (Object o : d.getArgs()) {
            if (!(o instanceof JCDiagnostic)) continue;
            JCDiagnostic diagnostic = (JCDiagnostic)o;
            this.getCodeRecursive(buf, diagnostic);
        }
    }

    public boolean hasErrorOn(JCDiagnostic.DiagnosticPosition pos) {
        JavaFileObject file = this.source != null ? this.source.fileObject : null;
        return file != null && this.recorded.contains(new Pair<JavaFileObject, Integer>(file, pos.getPreferredPosition()));
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(this.localize("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int pos, PrintWriter writer) {
        String line;
        String string = line = this.source == null ? null : this.source.getLine(pos);
        if (line == null) {
            return;
        }
        int col = this.source.getColumnNumber(pos, false);
        Log.printRawLines(writer, line);
        for (int i = 0; i < col - 1; ++i) {
            writer.print(line.charAt(i) == '\t' ? "\t" : " ");
        }
        writer.println("^");
        writer.flush();
    }

    public void printNewline() {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        noticeWriter.println();
    }

    public void printNewline(WriterKind wk) {
        this.getWriter(wk).println();
    }

    public void printLines(String key, Object ... args) {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(noticeWriter, this.localize(key, args));
    }

    public void printLines(JCDiagnostic.DiagnosticInfo diag) {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(noticeWriter, this.localize(diag));
    }

    public void printLines(PrefixKind pk, String key, Object ... args) {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(noticeWriter, this.localize(pk, key, args));
    }

    public void printLines(WriterKind wk, String key, Object ... args) {
        Log.printRawLines(this.getWriter(wk), this.localize(key, args));
    }

    public void printLines(WriterKind wk, PrefixKind pk, String key, Object ... args) {
        Log.printRawLines(this.getWriter(wk), this.localize(pk, key, args));
    }

    public void printRawLines(String msg) {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(noticeWriter, msg);
    }

    public void printRawLines(WriterKind kind, String msg) {
        Log.printRawLines(this.getWriter(kind), msg);
    }

    public static void printRawLines(PrintWriter writer, String msg) {
        int nl;
        while ((nl = msg.indexOf(10)) != -1) {
            writer.println(msg.substring(0, nl));
            msg = msg.substring(nl + 1);
        }
        if (msg.length() != 0) {
            writer.println(msg);
        }
    }

    public void printVerbose(String key, Object ... args) {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(noticeWriter, this.localize("verbose." + key, args));
    }

    @Override
    protected void directError(String key, Object ... args) {
        PrintWriter errWriter = this.writers.get((Object)WriterKind.ERROR);
        Log.printRawLines(errWriter, this.localize(key, args));
        errWriter.flush();
    }

    @Override
    public void report(JCDiagnostic diagnostic) {
        this.diagnosticHandler.report(diagnostic);
    }

    public void reportOutstandingWarnings() {
        this.diagnosticHandler.flushLintWaiters();
    }

    private Lint lintFor(JCDiagnostic diag) {
        Assert.check(diag.getLintCategory() != null);
        return this.lintMapper.lintAt(diag.getSource(), diag.getDiagnosticPosition()).orElse(null);
    }

    private Lint rootLint() {
        if (this.rootLint == null) {
            this.rootLint = Lint.instance(this.context);
        }
        return this.rootLint;
    }

    public void suppressAggregatedWarningNotes(Lint.LintCategory category) {
        this.suppressedDeferredMandatory.add(category);
    }

    public void reportOutstandingNotes() {
        this.aggregators.entrySet().stream().filter(entry -> !this.suppressedDeferredMandatory.contains(entry.getKey())).map(Map.Entry::getValue).map(WarningAggregator::aggregationNotes).flatMap(Collection::stream).forEach(this::report);
        this.aggregators.clear();
    }

    private WarningAggregator aggregatorFor(Lint.LintCategory lc) {
        WarningAggregator warningAggregator;
        switch (lc) {
            case PREVIEW: {
                warningAggregator = this.aggregators.computeIfAbsent(lc, c -> new WarningAggregator(this, Source.instance(this.context), (Lint.LintCategory)((Object)c)));
                break;
            }
            case DEPRECATION: {
                warningAggregator = this.aggregators.computeIfAbsent(lc, c -> new WarningAggregator(this, null, (Lint.LintCategory)((Object)c), "deprecated"));
                break;
            }
            default: {
                warningAggregator = this.aggregators.computeIfAbsent(lc, c -> new WarningAggregator(this, null, (Lint.LintCategory)((Object)c)));
            }
        }
        return warningAggregator;
    }

    public void clear() {
        this.recorded.clear();
        this.sourceMap.clear();
        this.lintWarnings.clear();
        this.nerrors = 0;
        this.nwarnings = 0;
        this.nsuppressederrors = 0;
        this.nsuppressedwarns = 0;
        while (this.diagnosticHandler.prev != null) {
            this.popDiagnosticHandler(this.diagnosticHandler);
        }
        this.aggregators.clear();
        this.suppressedDeferredMandatory.clear();
    }

    protected void writeDiagnostic(JCDiagnostic diag) {
        switch (diag.getType()) {
            case WARNING: {
                ++this.nwarnings;
                Optional.of(diag).map(JCDiagnostic::getLintCategory).ifPresent(this.lintWarnings::add);
                break;
            }
            case ERROR: {
                ++this.nerrors;
                break;
            }
        }
        if (this.diagListener != null) {
            this.diagListener.report(diag);
            return;
        }
        PrintWriter writer = this.getWriterForDiagnosticType(diag.getType());
        Log.printRawLines(writer, this.diagFormatter.format(diag, this.messages.getCurrentLocale()));
        if (this.promptOnError) {
            switch (diag.getType()) {
                case WARNING: 
                case ERROR: {
                    this.prompt();
                }
            }
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(writer);
        }
        writer.flush();
    }

    protected PrintWriter getWriterForDiagnosticType(JCDiagnostic.DiagnosticType dt) {
        switch (dt) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                return this.writers.get((Object)WriterKind.NOTICE);
            }
            case WARNING: {
                return this.writers.get((Object)WriterKind.WARNING);
            }
            case ERROR: {
                return this.writers.get((Object)WriterKind.ERROR);
            }
        }
        throw new Error();
    }

    public static String getLocalizedString(String key, Object ... args) {
        return JavacMessages.getDefaultLocalizedString(PrefixKind.COMPILER_MISC.key(key), args);
    }

    public String localize(String key, Object ... args) {
        return this.localize(PrefixKind.COMPILER_MISC, key, args);
    }

    public String localize(JCDiagnostic.DiagnosticInfo diagInfo) {
        if (useRawMessages) {
            return diagInfo.key();
        }
        return this.messages.getLocalizedString(diagInfo);
    }

    public String localize(PrefixKind pk, String key, Object ... args) {
        if (useRawMessages) {
            return pk.key(key);
        }
        return this.messages.getLocalizedString(pk.key(key), args);
    }

    private void printRawDiag(PrintWriter pw, String prefix, int pos, String msg) {
        if (this.source == null || pos == -1) {
            Log.printRawLines(pw, prefix + msg);
        } else {
            int line = this.source.getLineNumber(pos);
            JavaFileObject file = this.source.getFile();
            if (file != null) {
                Log.printRawLines(pw, file.getName() + ":" + line + ": " + msg);
            }
            this.printErrLine(pos, pw);
        }
        pw.flush();
    }

    public void rawError(int pos, String msg) {
        PrintWriter errWriter = this.writers.get((Object)WriterKind.ERROR);
        if (this.nerrors < this.MaxErrors && this.shouldReport(this.currentSourceFile(), pos)) {
            this.printRawDiag(errWriter, "error: ", pos, msg);
            this.prompt();
            ++this.nerrors;
        } else {
            ++this.nsuppressederrors;
        }
        errWriter.flush();
    }

    public void rawWarning(int pos, String msg) {
        PrintWriter warnWriter = this.writers.get((Object)WriterKind.ERROR);
        if (this.emitWarnings) {
            if (this.nwarnings < this.MaxWarnings) {
                this.printRawDiag(warnWriter, "warning: ", pos, msg);
            } else {
                ++this.nsuppressedwarns;
            }
        }
        this.prompt();
        ++this.nwarnings;
        warnWriter.flush();
    }

    public static String format(String fmt, Object ... args) {
        return String.format((Locale)null, fmt, args);
    }

    public abstract class DiagnosticHandler {
        protected final DiagnosticHandler prev;
        protected Map<JavaFileObject, List<JCDiagnostic>> lintWaitersMap = new LinkedHashMap<JavaFileObject, List<JCDiagnostic>>();

        protected DiagnosticHandler() {
            this.prev = Log.this.diagnosticHandler;
            Log.this.diagnosticHandler = this;
        }

        public final void report(JCDiagnostic diag) {
            Lint lint = null;
            Lint.LintCategory category = diag.getLintCategory();
            if (category != null) {
                JCDiagnostic.DiagnosticPosition pos = diag.getDiagnosticPosition();
                if (pos != null && category.annotationSuppression) {
                    if (!(Log.this.rootLint().isEnabled(category) || diag.isFlagSet(JCDiagnostic.DiagnosticFlag.DEFAULT_ENABLED) || diag.getCode().equals(CompilerProperties.LintWarnings.RequiresTransitiveAutomatic.key()))) {
                        return;
                    }
                    lint = Log.this.lintFor(diag);
                    if (lint == null) {
                        this.addLintWaiter(Log.this.currentSourceFile(), diag);
                        return;
                    }
                } else {
                    lint = Log.this.rootLint();
                }
            }
            this.reportWithLint(diag, lint);
        }

        public final void reportWithLint(JCDiagnostic diag, Lint lint) {
            if (diag.getCode().equals(CompilerProperties.LintWarnings.RequiresTransitiveAutomatic.key()) && !lint.isEnabled(Lint.LintCategory.REQUIRES_TRANSITIVE_AUTOMATIC)) {
                this.reportWithLint(Log.this.diags.warning(null, diag.getDiagnosticSource(), diag.getDiagnosticPosition(), CompilerProperties.LintWarnings.RequiresAutomatic), lint);
                return;
            }
            if (lint != null) {
                boolean emit;
                Lint.LintCategory category = diag.getLintCategory();
                boolean bl = !diag.isFlagSet(JCDiagnostic.DiagnosticFlag.DEFAULT_ENABLED) ? lint.isEnabled(category) : (category.annotationSuppression ? !lint.isSuppressed(category) : (emit = !Log.this.options.isDisabled(Option.XLINT, category)));
                if (!emit) {
                    return;
                }
            }
            this.reportReady(diag);
        }

        protected abstract void reportReady(JCDiagnostic var1);

        protected void addLintWaiter(JavaFileObject sourceFile, JCDiagnostic diagnostic) {
            this.lintWaitersMap.computeIfAbsent(sourceFile, s -> new LinkedList()).add(diagnostic);
        }

        public void flushLintWaiters() {
            this.lintWaitersMap.entrySet().removeIf(entry -> {
                JavaFileObject sourceFile = (JavaFileObject)entry.getKey();
                if (!Log.this.lintMapper.isKnown(sourceFile)) {
                    return true;
                }
                List diagnosticList = (List)entry.getValue();
                JavaFileObject prevSourceFile = Log.this.useSource(sourceFile);
                try {
                    diagnosticList.removeIf(diag -> {
                        Lint lint = Log.this.lintFor(diag);
                        if (lint != null) {
                            this.reportWithLint((JCDiagnostic)diag, lint);
                            return true;
                        }
                        return false;
                    });
                }
                finally {
                    Log.this.useSource(prevSourceFile);
                }
                return diagnosticList.isEmpty();
            });
        }
    }

    public static enum WriterKind {
        NOTICE,
        WARNING,
        ERROR,
        STDOUT,
        STDERR;

    }

    private class DefaultDiagnosticHandler
    extends DiagnosticHandler {
        private DefaultDiagnosticHandler() {
        }

        @Override
        protected void reportReady(JCDiagnostic diagnostic) {
            if (Log.this.expectDiagKeys != null) {
                Log.this.expectDiagKeys.remove(diagnostic.getCode());
            }
            if (diagnostic.hasRewriter()) {
                JCDiagnostic rewrittenDiag = diagnostic.rewrite();
                diagnostic = rewrittenDiag != null ? rewrittenDiag : diagnostic;
            }
            switch (diagnostic.getType()) {
                case FRAGMENT: {
                    throw new IllegalArgumentException();
                }
                case NOTE: {
                    if (!Log.this.emitWarnings && !diagnostic.isMandatory() || Log.this.suppressNotes) break;
                    Log.this.writeDiagnostic(diagnostic);
                    break;
                }
                case WARNING: {
                    if (diagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.AGGREGATE)) {
                        Lint.LintCategory category = diagnostic.getLintCategory();
                        boolean verbose = Log.this.lintFor(diagnostic).isEnabled(category);
                        if (!Log.this.aggregatorFor(category).aggregate(diagnostic, verbose)) {
                            return;
                        }
                    }
                    if (diagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.STRICT)) {
                        Log.this.writeDiagnostic(diagnostic);
                        return;
                    }
                    if (!Log.this.emitWarnings && !diagnostic.isMandatory()) break;
                    if (Log.this.nwarnings < Log.this.MaxWarnings) {
                        Log.this.writeDiagnostic(diagnostic);
                        break;
                    }
                    ++Log.this.nsuppressedwarns;
                    break;
                }
                case ERROR: {
                    if (!diagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.API) && !Log.this.shouldReport(diagnostic)) break;
                    if (Log.this.nerrors < Log.this.MaxErrors) {
                        Log.this.writeDiagnostic(diagnostic);
                        break;
                    }
                    ++Log.this.nsuppressederrors;
                }
            }
            if (diagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.COMPRESSED)) {
                Log.this.compressedOutput = true;
            }
        }
    }

    public static enum PrefixKind {
        JAVAC("javac."),
        COMPILER_MISC("compiler.misc.");

        final String value;

        private PrefixKind(String v) {
            this.value = v;
        }

        public String key(String k) {
            return this.value + k;
        }
    }

    public class DeferredDiagnosticHandler
    extends DiagnosticHandler {
        private List<JCDiagnostic> deferred = new ArrayList<JCDiagnostic>();
        private final Predicate<JCDiagnostic> filter;
        private final boolean passOnNonDeferrable;

        public DeferredDiagnosticHandler() {
            this(null);
        }

        public DeferredDiagnosticHandler(Predicate<JCDiagnostic> filter) {
            this(filter, true);
        }

        public DeferredDiagnosticHandler(Predicate<JCDiagnostic> filter, boolean passOnNonDeferrable) {
            this.filter = Optional.ofNullable(filter).orElse(d -> true);
            this.passOnNonDeferrable = passOnNonDeferrable;
        }

        private boolean deferrable(JCDiagnostic diag) {
            return (!diag.isFlagSet(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE) || !this.passOnNonDeferrable) && this.filter.test(diag);
        }

        @Override
        protected void reportReady(JCDiagnostic diag) {
            if (this.deferrable(diag)) {
                this.deferred.add(diag);
            } else {
                this.prev.reportReady(diag);
            }
        }

        @Override
        protected void addLintWaiter(JavaFileObject sourceFile, JCDiagnostic diag) {
            if (this.deferrable(diag)) {
                super.addLintWaiter(sourceFile, diag);
            } else {
                this.prev.addLintWaiter(sourceFile, diag);
            }
        }

        public List<JCDiagnostic> getDiagnostics() {
            return this.deferred;
        }

        public void reportDeferredDiagnostics() {
            this.reportDeferredDiagnostics((JCDiagnostic d) -> true);
        }

        public void reportDeferredDiagnostics(Predicate<JCDiagnostic> accepter) {
            this.deferred.stream().filter(accepter).forEach(this.prev::report);
            this.deferred = null;
            this.lintWaitersMap.forEach((sourceFile, diagnostics) -> diagnostics.stream().filter(accepter).forEach(diagnostic -> this.prev.addLintWaiter((JavaFileObject)sourceFile, (JCDiagnostic)diagnostic)));
            this.lintWaitersMap = null;
        }

        public void reportDeferredDiagnostics(Comparator<JCDiagnostic> order) {
            this.deferred.sort(order);
            this.reportDeferredDiagnostics();
        }
    }

    public class DiscardDiagnosticHandler
    extends DiagnosticHandler {
        @Override
        protected void addLintWaiter(JavaFileObject sourceFile, JCDiagnostic diagnostic) {
        }

        @Override
        protected void reportReady(JCDiagnostic diag) {
        }
    }
}

