/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.doclint.DocLint;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.platform.PlatformProvider;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.StringUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.SourceVersion;
import nbjavac.ModuleWrapper;
import nbjavac.ServiceLoaderWrapper;
import nbjavac.VMWrapper;

public enum Option {
    G("-g", "opt.g", OptionKind.STANDARD, OptionGroup.BASIC),
    G_NONE("-g:none", "opt.g.none", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option) {
            helper.put("-g:", Option.LINT_CUSTOM_NONE);
        }
    }
    ,
    G_CUSTOM("-g:", "opt.g.lines.vars.source", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ANYOF, "lines", "vars", "source"),
    XLINT("-Xlint", "opt.Xlint", OptionKind.EXTENDED, OptionGroup.BASIC),
    XLINT_CUSTOM("-Xlint:", "opt.arg.Xlint", "opt.Xlint.custom", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ANYOF, Option.getXLintChoices()),
    XDOCLINT("-Xdoclint", "opt.Xdoclint", OptionKind.EXTENDED, OptionGroup.BASIC),
    XDOCLINT_CUSTOM("-Xdoclint:", "opt.Xdoclint.subopts", "opt.Xdoclint.custom", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public boolean matches(String option) {
            return DocLint.newDocLint().isValidOption(option.replace(2.XDOCLINT_CUSTOM.primaryName, "-Xmsgs:"));
        }

        @Override
        public void process(OptionHelper helper, String option, String arg) {
            String prev = helper.get(XDOCLINT_CUSTOM);
            String next = prev == null ? arg : prev + " " + arg;
            helper.put(2.XDOCLINT_CUSTOM.primaryName, next);
        }
    }
    ,
    XDOCLINT_PACKAGE("-Xdoclint/package:", "opt.Xdoclint.package.args", "opt.Xdoclint.package.desc", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public boolean matches(String option) {
            return DocLint.newDocLint().isValidOption(option.replace(3.XDOCLINT_PACKAGE.primaryName, "-XcheckPackage:"));
        }

        @Override
        public void process(OptionHelper helper, String option, String arg) {
            String prev = helper.get(XDOCLINT_PACKAGE);
            String next = prev == null ? arg : prev + "," + arg;
            helper.put(3.XDOCLINT_PACKAGE.primaryName, next);
        }
    }
    ,
    NOWARN("-nowarn", "opt.nowarn", OptionKind.STANDARD, OptionGroup.BASIC),
    VERBOSE("-verbose", "opt.verbose", OptionKind.STANDARD, OptionGroup.BASIC),
    DEPRECATION("-deprecation", "opt.deprecation", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option) {
            helper.put("-Xlint:deprecation", option);
        }
    }
    ,
    CLASS_PATH("--class-path -classpath -cp", "opt.arg.path", "opt.classpath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    SOURCE_PATH("--source-path -sourcepath", "opt.arg.path", "opt.sourcepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    MODULE_SOURCE_PATH("--module-source-path", "opt.arg.mspath", "opt.modulesourcepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            if (arg.length() == 0) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(option));
            }
            Pattern moduleSpecificForm = this.getPattern();
            String prev = helper.get(MODULE_SOURCE_PATH);
            if (prev == null) {
                super.process(helper, option, arg);
            } else if (moduleSpecificForm.matcher(arg).matches()) {
                String argModule = arg.substring(0, arg.indexOf(61));
                boolean isRepeated = Arrays.stream(prev.split("\u0000")).filter(s -> moduleSpecificForm.matcher((CharSequence)s).matches()).map(s -> s.substring(0, s.indexOf(61))).anyMatch(s -> s.equals(argModule));
                if (isRepeated) {
                    throw helper.newInvalidValueException(CompilerProperties.Errors.RepeatedValueForModuleSourcePath(argModule));
                }
                super.process(helper, option, prev + '\u0000' + arg);
            } else {
                boolean isPresent = Arrays.stream(prev.split("\u0000")).anyMatch(s -> !moduleSpecificForm.matcher((CharSequence)s).matches());
                if (isPresent) {
                    throw helper.newInvalidValueException(CompilerProperties.Errors.MultipleValuesForModuleSourcePath);
                }
                super.process(helper, option, prev + '\u0000' + arg);
            }
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("([\\p{Alnum}$_.]+)=(.*)");
        }
    }
    ,
    MODULE_PATH("--module-path -p", "opt.arg.path", "opt.modulepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    UPGRADE_MODULE_PATH("--upgrade-module-path", "opt.arg.path", "opt.upgrademodulepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    SYSTEM("--system", "opt.arg.jdk", "opt.system", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    PATCH_MODULE("--patch-module", "opt.arg.patch", "opt.patch", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            if (arg.length() == 0) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(option));
            }
            if (this.getPattern().matcher(arg).matches()) {
                String prev = helper.get(PATCH_MODULE);
                if (prev == null) {
                    super.process(helper, option, arg);
                } else {
                    String argModulePackage = arg.substring(0, arg.indexOf(61));
                    boolean isRepeated = Arrays.stream(prev.split("\u0000")).map(s -> s.substring(0, s.indexOf(61))).collect(Collectors.toSet()).contains(argModulePackage);
                    if (isRepeated) {
                        throw helper.newInvalidValueException(CompilerProperties.Errors.RepeatedValueForPatchModule(argModulePackage));
                    }
                    super.process(helper, option, prev + '\u0000' + arg);
                }
            } else {
                throw helper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(option, arg));
            }
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("([^/]+)=(,*[^,].*)");
        }
    }
    ,
    BOOT_CLASS_PATH("--boot-class-path -bootclasspath", "opt.arg.path", "opt.bootclasspath", OptionKind.STANDARD, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            helper.remove("-Xbootclasspath/p:");
            helper.remove("-Xbootclasspath/a:");
            super.process(helper, option, arg);
        }
    }
    ,
    XBOOTCLASSPATH_PREPEND("-Xbootclasspath/p:", "opt.arg.path", "opt.Xbootclasspath.p", OptionKind.EXTENDED, OptionGroup.FILEMANAGER),
    XBOOTCLASSPATH_APPEND("-Xbootclasspath/a:", "opt.arg.path", "opt.Xbootclasspath.a", OptionKind.EXTENDED, OptionGroup.FILEMANAGER),
    XBOOTCLASSPATH("-Xbootclasspath:", "opt.arg.path", "opt.bootclasspath", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            helper.remove("-Xbootclasspath/p:");
            helper.remove("-Xbootclasspath/a:");
            super.process(helper, "-bootclasspath", arg);
        }
    }
    ,
    EXTDIRS("-extdirs", "opt.arg.dirs", "opt.extdirs", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    DJAVA_EXT_DIRS("-Djava.ext.dirs=", "opt.arg.dirs", "opt.extdirs", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            EXTDIRS.process(helper, "-extdirs", arg);
        }
    }
    ,
    ENDORSEDDIRS("-endorseddirs", "opt.arg.dirs", "opt.endorseddirs", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    DJAVA_ENDORSED_DIRS("-Djava.endorsed.dirs=", "opt.arg.dirs", "opt.endorseddirs", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            ENDORSEDDIRS.process(helper, "-endorseddirs", arg);
        }
    }
    ,
    PROC("-proc:", "opt.proc.none.only", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ONEOF, "none", "only", "full"),
    PROCESSOR("-processor", "opt.arg.class.list", "opt.processor", OptionKind.STANDARD, OptionGroup.BASIC),
    PROCESSOR_PATH("--processor-path -processorpath", "opt.arg.path", "opt.processorpath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    PROCESSOR_MODULE_PATH("--processor-module-path", "opt.arg.path", "opt.processormodulepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    PARAMETERS("-parameters", "opt.parameters", OptionKind.STANDARD, OptionGroup.BASIC),
    D("-d", "opt.arg.directory", "opt.d", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    S("-s", "opt.arg.directory", "opt.sourceDest", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    H("-h", "opt.arg.directory", "opt.headerDest", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    IMPLICIT("-implicit:", "opt.implicit", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ONEOF, "none", "class"),
    ENCODING("-encoding", "opt.arg.encoding", "opt.encoding", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    SOURCE("--source -source", "opt.arg.release", "opt.source", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String operand) throws InvalidValueException {
            Source source = Source.lookup(operand);
            if (source == null) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.InvalidSource(operand));
            }
            super.process(helper, option, operand);
        }

        @Override
        protected void help(Log log) {
            ArrayList<String> releases = new ArrayList<String>();
            for (Source source : Source.values()) {
                if (!source.isSupported()) continue;
                releases.add(source.name);
            }
            String formatted = Option.formatAbbreviatedList(releases);
            super.help(log, log.localize(Log.PrefixKind.JAVAC, this.descrKey, formatted));
        }
    }
    ,
    TARGET("--target -target", "opt.arg.release", "opt.target", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String operand) throws InvalidValueException {
            Target target = Target.lookup(operand);
            if (target == null) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.InvalidTarget(operand));
            }
            super.process(helper, option, operand);
        }

        @Override
        protected void help(Log log) {
            ArrayList<String> releases = new ArrayList<String>();
            for (Target target : Target.values()) {
                if (!target.isSupported()) continue;
                releases.add(target.name);
            }
            String formatted = Option.formatAbbreviatedList(releases);
            super.help(log, log.localize(Log.PrefixKind.JAVAC, this.descrKey, formatted));
        }
    }
    ,
    RELEASE("--release", "opt.arg.release", "opt.release", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        protected void help(Log log) {
            ServiceLoader<PlatformProvider> providers = ServiceLoaderWrapper.loadTool(PlatformProvider.class);
            Set platforms = StreamSupport.stream(providers.spliterator(), false).flatMap(provider -> StreamSupport.stream(provider.getSupportedPlatformNames().spliterator(), false)).collect(Collectors.toCollection(LinkedHashSet::new));
            String formatted = Option.formatAbbreviatedList(platforms);
            super.help(log, log.localize(Log.PrefixKind.JAVAC, this.descrKey, formatted));
        }
    }
    ,
    PREVIEW("--enable-preview", "opt.preview", OptionKind.STANDARD, OptionGroup.BASIC),
    DISABLE_LINE_DOC_COMMENTS("--disable-line-doc-comments", "opt.lineDocComments", OptionKind.EXTENDED, OptionGroup.BASIC),
    PROFILE("-profile", "opt.arg.profile", "opt.profile", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String operand) throws InvalidValueException {
            Profile profile = Profile.lookup(operand);
            if (profile == null) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.InvalidProfile(operand));
            }
            super.process(helper, option, operand);
        }
    }
    ,
    VERSION("--version -version", "opt.version", OptionKind.STANDARD, OptionGroup.INFO){

        @Override
        public void process(OptionHelper helper, String option) throws InvalidValueException {
            Log log = helper.getLog();
            String ownName = helper.getOwnName();
            log.printLines(Log.WriterKind.STDOUT, Log.PrefixKind.JAVAC, "version", ownName, JavaCompiler.version());
            super.process(helper, option);
        }
    }
    ,
    FULLVERSION("--full-version -fullversion", null, OptionKind.HIDDEN, OptionGroup.INFO){

        @Override
        public void process(OptionHelper helper, String option) throws InvalidValueException {
            Log log = helper.getLog();
            String ownName = helper.getOwnName();
            log.printLines(Log.WriterKind.STDOUT, Log.PrefixKind.JAVAC, "fullVersion", ownName, JavaCompiler.fullVersion());
            super.process(helper, option);
        }
    }
    ,
    HELP("--help -help -?", "opt.help", OptionKind.STANDARD, OptionGroup.INFO){

        @Override
        public void process(OptionHelper helper, String option) throws InvalidValueException {
            Log log = helper.getLog();
            String ownName = helper.getOwnName();
            log.printLines(Log.WriterKind.STDOUT, Log.PrefixKind.JAVAC, "msg.usage.header", ownName);
            Option.showHelp(log, OptionKind.STANDARD);
            log.printNewline(Log.WriterKind.STDOUT);
            super.process(helper, option);
        }
    }
    ,
    A("-A", "opt.arg.key.equals.value", "opt.A", OptionKind.STANDARD, OptionGroup.BASIC, ArgKind.ADJACENT){

        @Override
        public boolean matches(String arg) {
            return arg.startsWith("-A");
        }

        @Override
        public boolean hasArg() {
            return false;
        }

        @Override
        public void process(OptionHelper helper, String option) throws InvalidValueException {
            int argLength = option.length();
            if (argLength == 2) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.EmptyAArgument);
            }
            int sepIndex = option.indexOf(61);
            String key = option.substring(2, sepIndex != -1 ? sepIndex : argLength);
            if (!JavacProcessingEnvironment.isValidOptionName(key)) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.InvalidAKey(option));
            }
            helper.put(option, option);
        }
    }
    ,
    DEFAULT_MODULE_FOR_CREATED_FILES("--default-module-for-created-files", "opt.arg.default.module.for.created.files", "opt.default.module.for.created.files", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            String prev = helper.get(DEFAULT_MODULE_FOR_CREATED_FILES);
            if (prev != null) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.OptionTooMany(19.DEFAULT_MODULE_FOR_CREATED_FILES.primaryName));
            }
            if (arg.length() == 0) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(option));
            }
            if (!this.getPattern().matcher(arg).matches()) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(option, arg));
            }
            helper.put(19.DEFAULT_MODULE_FOR_CREATED_FILES.primaryName, arg);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("[^,].*");
        }
    }
    ,
    X("--help-extra -X", "opt.X", OptionKind.STANDARD, OptionGroup.INFO){

        @Override
        public void process(OptionHelper helper, String option) throws InvalidValueException {
            Log log = helper.getLog();
            Option.showHelp(log, OptionKind.EXTENDED);
            log.printNewline(Log.WriterKind.STDOUT);
            log.printLines(Log.WriterKind.STDOUT, Log.PrefixKind.JAVAC, "msg.usage.nonstandard.footer", new Object[0]);
            super.process(helper, option);
        }
    }
    ,
    HELP_LINT("--help-lint", "opt.help.lint", OptionKind.EXTENDED, OptionGroup.INFO){
        private final String HELP_INDENT = "    ";
        private final String LINT_KEY_FORMAT = "    %-" + (28 - "        ".length()) + "s %s";

        @Override
        public void process(OptionHelper helper, String option) throws InvalidValueException {
            Log log = helper.getLog();
            log.printRawLines(Log.WriterKind.STDOUT, log.localize(Log.PrefixKind.JAVAC, "opt.help.lint.header", new Object[0]));
            log.printRawLines(Log.WriterKind.STDOUT, String.format(this.LINT_KEY_FORMAT, Option.LINT_CUSTOM_ALL, log.localize(Log.PrefixKind.JAVAC, "opt.Xlint.all", new Object[0])));
            TreeMap keyMap = new TreeMap();
            Stream.of(Lint.LintCategory.values()).forEach(lc -> lc.optionList.stream().forEach(key -> keyMap.put(key, String.format(this.LINT_KEY_FORMAT, key, key.equals(lc.option) ? log.localize(Log.PrefixKind.JAVAC, "opt.Xlint.desc." + key, new Object[0]) : log.localize(Log.PrefixKind.JAVAC, "opt.Xlint.alias.of", lc.option, key)))));
            keyMap.values().forEach(desc -> log.printRawLines(Log.WriterKind.STDOUT, (String)desc));
            log.printRawLines(Log.WriterKind.STDOUT, String.format(this.LINT_KEY_FORMAT, Option.LINT_CUSTOM_NONE, log.localize(Log.PrefixKind.JAVAC, "opt.Xlint.none", new Object[0])));
            log.printRawLines(Log.WriterKind.STDOUT, log.localize(Log.PrefixKind.JAVAC, "opt.help.lint.enabled.by.default", new Object[0]));
            String defaults = Stream.of(Lint.LintCategory.values()).filter(lc -> lc.enabledByDefault).map(lc -> lc.option).sorted().collect(Collectors.joining(", "));
            log.printRawLines(Log.WriterKind.STDOUT, String.format("%s%s.", "    ", defaults));
            List<String> aliasExample = Lint.LintCategory.IDENTITY.optionList;
            log.printRawLines(Log.WriterKind.STDOUT, log.localize(Log.PrefixKind.JAVAC, "opt.help.lint.footer", aliasExample.get(0), aliasExample.get(1)));
            super.process(helper, option);
        }
    }
    ,
    J("-J", "opt.arg.flag", "opt.J", OptionKind.STANDARD, OptionGroup.INFO, ArgKind.ADJACENT){

        @Override
        public void process(OptionHelper helper, String option) {
            throw new AssertionError((Object)"the -J flag should be caught by the launcher.");
        }

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            throw helper.newInvalidValueException(CompilerProperties.Errors.InvalidFlag(option + arg));
        }
    }
    ,
    MOREINFO("-moreinfo", null, OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option) throws InvalidValueException {
            Type.moreInfo = true;
            super.process(helper, option);
        }
    }
    ,
    WERROR("-Werror", "opt.Werror", OptionKind.STANDARD, OptionGroup.BASIC),
    WERROR_CUSTOM("-Werror:", "opt.arg.Werror", "opt.Werror.custom", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ANYOF, Option.getXLintChoices()),
    PROMPT("-prompt", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    DOE("-doe", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    PRINTSOURCE("-printsource", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    WARNUNCHECKED("-warnunchecked", null, OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option) {
            helper.put("-Xlint:unchecked", option);
        }
    }
    ,
    XMAXERRS("-Xmaxerrs", "opt.arg.number", "opt.maxerrs", OptionKind.EXTENDED, OptionGroup.BASIC),
    XMAXWARNS("-Xmaxwarns", "opt.arg.number", "opt.maxwarns", OptionKind.EXTENDED, OptionGroup.BASIC),
    XSTDOUT("-Xstdout", "opt.arg.file", "opt.Xstdout", OptionKind.EXTENDED, OptionGroup.INFO){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            try {
                Log log = helper.getLog();
                log.setWriters(new PrintWriter((Writer)new FileWriter(arg), true));
            }
            catch (IOException e) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.ErrorWritingFile(arg, e.getMessage()));
            }
            super.process(helper, option, arg);
        }
    }
    ,
    XPRINT("-Xprint", "opt.print", OptionKind.EXTENDED, OptionGroup.BASIC),
    XPRINTROUNDS("-XprintRounds", "opt.printRounds", OptionKind.EXTENDED, OptionGroup.BASIC),
    XPRINTPROCESSORINFO("-XprintProcessorInfo", "opt.printProcessorInfo", OptionKind.EXTENDED, OptionGroup.BASIC),
    XPREFER("-Xprefer:", "opt.prefer", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ONEOF, "source", "newer"),
    XXUSERPATHSFIRST("-XXuserPathsFirst", "opt.userpathsfirst", OptionKind.HIDDEN, OptionGroup.BASIC),
    XPKGINFO("-Xpkginfo:", "opt.pkginfo", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ONEOF, "always", "legacy", "nonempty"),
    O("-O", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    XJCOV("-Xjcov", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    PLUGIN("-Xplugin:", "opt.arg.plugin", "opt.plugin", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String p) {
            String prev = helper.get(PLUGIN);
            helper.put(26.PLUGIN.primaryName, prev == null ? p : prev + '\u0000' + p);
        }
    }
    ,
    XDIAGS("-Xdiags:", "opt.diags", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ONEOF, "compact", "verbose"),
    DEBUG("--debug", null, OptionKind.HIDDEN, OptionGroup.BASIC, ArgKind.REQUIRED){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            HiddenGroup.DEBUG.process(helper, option, arg);
        }
    }
    ,
    SHOULDSTOP("--should-stop", null, OptionKind.HIDDEN, OptionGroup.BASIC, ArgKind.REQUIRED){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            HiddenGroup.SHOULDSTOP.process(helper, option, arg);
        }
    }
    ,
    DIAGS("--diags", null, OptionKind.HIDDEN, OptionGroup.BASIC, ArgKind.REQUIRED){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            HiddenGroup.DIAGS.process(helper, option, arg);
        }
    }
    ,
    XD("-XD", null, OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public boolean matches(String s) {
            return s.startsWith(this.primaryName);
        }

        @Override
        public void process(OptionHelper helper, String option) {
            this.process(helper, option, option.substring(this.primaryName.length()));
        }

        @Override
        public void process(OptionHelper helper, String option, String arg) {
            int eq = arg.indexOf(61);
            String key = eq < 0 ? arg : arg.substring(0, eq);
            String value = eq < 0 ? arg : arg.substring(eq + 1);
            helper.put(key, value);
        }
    }
    ,
    ADD_EXPORTS("--add-exports", "opt.arg.addExports", "opt.addExports", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            if (arg.length() == 0) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(option));
            }
            if (!this.getPattern().matcher(arg).matches()) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(option, arg));
            }
            String prev = helper.get(ADD_EXPORTS);
            helper.put(31.ADD_EXPORTS.primaryName, prev == null ? arg : prev + '\u0000' + arg);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("([^/]+)/([^=]+)=(,*[^,].*)");
        }
    }
    ,
    ADD_OPENS("--add-opens", null, null, OptionKind.HIDDEN, OptionGroup.BASIC),
    ADD_READS("--add-reads", "opt.arg.addReads", "opt.addReads", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            if (arg.length() == 0) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(option));
            }
            if (!this.getPattern().matcher(arg).matches()) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(option, arg));
            }
            String prev = helper.get(ADD_READS);
            helper.put(32.ADD_READS.primaryName, prev == null ? arg : prev + '\u0000' + arg);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("([^=]+)=(,*[^,].*)");
        }
    }
    ,
    MODULE("--module -m", "opt.arg.m", "opt.m", OptionKind.STANDARD, OptionGroup.BASIC),
    ADD_MODULES("--add-modules", "opt.arg.addmods", "opt.addmods", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            if (arg.length() == 0) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(option));
            }
            if (!this.getPattern().matcher(arg).matches()) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(option, arg));
            }
            String prev = helper.get(ADD_MODULES);
            helper.put(33.ADD_MODULES.primaryName, prev == null ? arg : prev + ',' + arg);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile(",*[^,].*");
        }
    }
    ,
    LIMIT_MODULES("--limit-modules", "opt.arg.limitmods", "opt.limitmods", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            if (arg.length() == 0) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(option));
            }
            if (!this.getPattern().matcher(arg).matches()) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(option, arg));
            }
            helper.put(34.LIMIT_MODULES.primaryName, arg);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile(",*[^,].*");
        }
    }
    ,
    MODULE_VERSION("--module-version", "opt.arg.module.version", "opt.module.version", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            if (arg.length() == 0) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(option));
            }
            try {
                ModuleWrapper.ModuleDescriptor.Version.parse(arg);
            }
            catch (IllegalArgumentException e) {
                throw helper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(option, arg));
            }
            super.process(helper, option, arg);
        }
    }
    ,
    AT("@", "opt.arg.file", "opt.AT", OptionKind.STANDARD, OptionGroup.INFO, ArgKind.ADJACENT){

        @Override
        public void process(OptionHelper helper, String option) {
            throw new AssertionError((Object)"the @ flag should be caught by CommandLine.");
        }
    }
    ,
    SOURCEFILE("sourcefile", null, OptionKind.HIDDEN, OptionGroup.INFO){

        @Override
        public boolean matches(String s) {
            if (s.endsWith(".java")) {
                return true;
            }
            int sep = s.indexOf(47);
            if (sep != -1) {
                return SourceVersion.isName(s.substring(0, sep)) && SourceVersion.isName(s.substring(sep + 1));
            }
            return SourceVersion.isName(s);
        }

        @Override
        public void process(OptionHelper helper, String option) throws InvalidValueException {
            if (option.endsWith(".java")) {
                try {
                    Path p = Paths.get(option, new String[0]);
                    if (!Files.exists(p, new LinkOption[0])) {
                        throw helper.newInvalidValueException(CompilerProperties.Errors.FileNotFound(p.toString()));
                    }
                    if (!Files.isRegularFile(p, new LinkOption[0])) {
                        throw helper.newInvalidValueException(CompilerProperties.Errors.FileNotFile(p));
                    }
                    helper.addFile(p);
                }
                catch (InvalidPathException ex) {
                    throw helper.newInvalidValueException(CompilerProperties.Errors.InvalidPath(option));
                }
            } else {
                helper.addClassName(option);
            }
        }
    }
    ,
    MULTIRELEASE("--multi-release", "opt.arg.multi-release", "opt.multi-release", OptionKind.HIDDEN, OptionGroup.FILEMANAGER),
    INHERIT_RUNTIME_ENVIRONMENT("--inherit-runtime-environment", "opt.inherit_runtime_environment", OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper helper, String option) throws InvalidValueException {
            String[] runtimeArgs;
            block3: for (String arg : runtimeArgs = VMWrapper.getRuntimeArguments()) {
                for (Option o : this.getSupportedRuntimeOptions()) {
                    if (!o.matches(arg)) continue;
                    switch (o) {
                        case ADD_MODULES: {
                            int eq = arg.indexOf(61);
                            Assert.check(eq > 0, () -> "invalid runtime option:" + arg);
                            String mods = Arrays.stream(arg.substring(eq + 1).split(",")).filter(s -> s.length() != 0 && !s.equals("ALL-DEFAULT")).collect(Collectors.joining(","));
                            if (mods.length() == 0) continue block3;
                            String updatedArg = arg.substring(0, eq + 1) + mods;
                            o.handleOption(helper, updatedArg, Collections.emptyIterator());
                            break;
                        }
                        default: {
                            o.handleOption(helper, arg, Collections.emptyIterator());
                            break;
                        }
                    }
                    continue block3;
                }
            }
        }

        private Option[] getSupportedRuntimeOptions() {
            Option[] supportedRuntimeOptions = new Option[]{ADD_EXPORTS, ADD_MODULES, LIMIT_MODULES, MODULE_PATH, UPGRADE_MODULE_PATH, PATCH_MODULE};
            return supportedRuntimeOptions;
        }
    };

    public static final String LINT_CUSTOM_ALL = "all";
    public static final String LINT_CUSTOM_NONE = "none";
    public final String primaryName;
    public final String[] names;
    protected final String argsNameKey;
    protected final String descrKey;
    private final OptionKind kind;
    private final OptionGroup group;
    private final ArgKind argKind;
    private final ChoiceKind choiceKind;
    private final Set<String> choices;
    private static final String SMALL_INDENT = "  ";
    private static final String LARGE_INDENT = "        ";
    private static final int DEFAULT_SYNOPSIS_WIDTH = 28;
    private static final int DEFAULT_MAX_LINE_LENGTH = 80;
    private static final String COMPACT_FORMAT = "  %-28s %s";

    public static Option lookup(String arg) {
        return Option.lookup(arg, EnumSet.allOf(Option.class));
    }

    public static Option lookup(String arg, Set<Option> options) {
        for (Option option : options) {
            if (!option.matches(arg)) continue;
            return option;
        }
        return null;
    }

    private static void showHelp(Log log, OptionKind kind) {
        Comparator<Option> comp = new Comparator<Option>(){
            final Collator collator = Collator.getInstance(Locale.US);
            {
                this.collator.setStrength(0);
            }

            @Override
            public int compare(Option o1, Option o2) {
                return this.collator.compare(o1.primaryName, o2.primaryName);
            }
        };
        Option.getJavaCompilerOptions().stream().filter(o -> o.kind == kind).sorted(comp).forEach(o -> o.help(log));
    }

    private Option(String text, String descrKey, OptionKind kind, OptionGroup group) {
        this(text, null, descrKey, kind, group, null, null, ArgKind.NONE);
    }

    private Option(String text, String descrKey, OptionKind kind, OptionGroup group, ArgKind argKind) {
        this(text, null, descrKey, kind, group, null, null, argKind);
    }

    private Option(String text, String argsNameKey, String descrKey, OptionKind kind, OptionGroup group) {
        this(text, argsNameKey, descrKey, kind, group, null, null, ArgKind.REQUIRED);
    }

    private Option(String text, String argsNameKey, String descrKey, OptionKind kind, OptionGroup group, ArgKind ak) {
        this(text, argsNameKey, descrKey, kind, group, null, null, ak);
    }

    private Option(String text, String argsNameKey, String descrKey, OptionKind kind, OptionGroup group, ChoiceKind choiceKind, Set<String> choices) {
        this(text, argsNameKey, descrKey, kind, group, choiceKind, choices, ArgKind.REQUIRED);
    }

    private Option(String text, String descrKey, OptionKind kind, OptionGroup group, ChoiceKind choiceKind, String ... choices) {
        this(text, null, descrKey, kind, group, choiceKind, new LinkedHashSet<String>(Arrays.asList(choices)), ArgKind.REQUIRED);
    }

    private Option(String text, String argsNameKey, String descrKey, OptionKind kind, OptionGroup group, ChoiceKind choiceKind, Set<String> choices, ArgKind argKind) {
        this.names = text.trim().split("\\s+");
        Assert.check(this.names.length >= 1);
        this.primaryName = this.names[0];
        this.argsNameKey = argsNameKey;
        this.descrKey = descrKey;
        this.kind = kind;
        this.group = group;
        this.choiceKind = choiceKind;
        this.choices = choices;
        this.argKind = argKind;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public OptionKind getKind() {
        return this.kind;
    }

    public Option getCustom() {
        return Option.valueOf(this.name() + "_CUSTOM");
    }

    public Option getLintCustom() {
        if (this == XLINT || this == WERROR) {
            return this.getCustom();
        }
        throw new IllegalArgumentException();
    }

    public boolean isInBasicOptionGroup() {
        return this.group == OptionGroup.BASIC;
    }

    public ArgKind getArgKind() {
        return this.argKind;
    }

    public boolean hasArg() {
        return this.argKind != ArgKind.NONE;
    }

    public boolean hasSeparateArg() {
        return this.getArgKind() == ArgKind.REQUIRED && !this.primaryName.endsWith(":") && !this.primaryName.endsWith("=");
    }

    public boolean matches(String option) {
        for (String name : this.names) {
            if (!this.matches(option, name)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String option, String name) {
        boolean hasSuffix;
        if (name.startsWith("--")) {
            return option.equals(name) || this.hasArg() && option.startsWith(name + "=");
        }
        boolean bl = hasSuffix = this.argKind == ArgKind.ADJACENT || name.endsWith(":") || name.endsWith("=");
        if (!hasSuffix) {
            return option.equals(name);
        }
        if (!option.startsWith(name)) {
            return false;
        }
        if (this.choices != null) {
            String arg = option.substring(name.length());
            if (this.choiceKind == ChoiceKind.ONEOF) {
                return this.choices.contains(arg);
            }
            for (String a : arg.split(",+")) {
                if (this.choices.contains(a)) continue;
                return false;
            }
        }
        return true;
    }

    public void handleOption(OptionHelper helper, String arg, Iterator<String> rest) throws InvalidValueException {
        helper.initialize();
        if (this.hasArg()) {
            String operand;
            String option;
            int sep = Option.findSeparator(arg);
            if (this.getArgKind() == ArgKind.ADJACENT) {
                option = this.primaryName;
                operand = arg.substring(this.primaryName.length());
            } else if (sep > 0) {
                option = arg.substring(0, sep);
                operand = arg.substring(sep + 1);
            } else {
                if (!rest.hasNext()) {
                    throw helper.newInvalidValueException(CompilerProperties.Errors.ReqArg(this.primaryName));
                }
                option = arg;
                operand = rest.next();
            }
            this.process(helper, option, operand);
        } else {
            if ((this == HELP || this == X || this == HELP_LINT || this == VERSION || this == FULLVERSION) && helper.get(this) != null) {
                return;
            }
            this.process(helper, arg);
        }
    }

    public void process(OptionHelper helper, String option) throws InvalidValueException {
        if (this.argKind == ArgKind.NONE) {
            this.process(helper, this.primaryName, option);
        } else {
            int sep = Option.findSeparator(option);
            this.process(helper, this.primaryName, option.substring(sep + 1));
        }
    }

    public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
        helper.initialize();
        if (this.choices != null) {
            if (this.choiceKind == ChoiceKind.ONEOF) {
                for (String s : this.choices) {
                    helper.remove(this.primaryName + s);
                }
                String opt = this.primaryName + arg;
                helper.put(opt, opt);
                String nm = this.primaryName.substring(0, this.primaryName.length() - 1);
                helper.put(nm, arg);
            } else {
                for (String a : arg.split(",+")) {
                    String opt = this.primaryName + a;
                    helper.put(opt, opt);
                }
            }
        }
        helper.put(this.primaryName, arg);
        if (this.group == OptionGroup.FILEMANAGER) {
            helper.handleFileManagerOption(this, arg);
        }
    }

    public Pattern getPattern() {
        throw new UnsupportedOperationException();
    }

    private static int findSeparator(String word) {
        for (int i = 0; i < word.length(); ++i) {
            switch (word.charAt(i)) {
                case ':': 
                case '=': {
                    return i;
                }
            }
        }
        return -1;
    }

    protected void help(Log log) {
        this.help(log, log.localize(Log.PrefixKind.JAVAC, this.descrKey, new Object[0]));
    }

    protected void help(Log log, String descr) {
        String synopses = Arrays.stream(this.names).map(s -> this.helpSynopsis((String)s, log)).collect(Collectors.joining(", "));
        if (synopses.length() < 28 && !descr.contains("\n") && SMALL_INDENT.length() + 28 + 1 + descr.length() <= 80) {
            log.printRawLines(Log.WriterKind.STDOUT, String.format(COMPACT_FORMAT, synopses, descr));
            return;
        }
        if (synopses.length() <= 80) {
            log.printRawLines(Log.WriterKind.STDOUT, SMALL_INDENT + synopses);
        } else {
            for (String name : this.names) {
                log.printRawLines(Log.WriterKind.STDOUT, SMALL_INDENT + this.helpSynopsis(name, log));
            }
        }
        log.printRawLines(Log.WriterKind.STDOUT, LARGE_INDENT + descr.replace("\n", "\n        "));
    }

    private static String formatAbbreviatedList(Collection<String> values) {
        int i;
        List<Object> list = values instanceof List ? (List<Object>)values : new ArrayList<String>(values);
        int size = list.size();
        if (size == 0) {
            return "";
        }
        if (size <= 6) {
            return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)list);
        }
        StringJoiner sj = new StringJoiner(", ");
        for (i = 0; i < 3; ++i) {
            sj.add((CharSequence)list.get(i));
        }
        sj.add("...");
        for (i = size - 3; i < size; ++i) {
            sj.add((CharSequence)list.get(i));
        }
        return sj.toString();
    }

    private String helpSynopsis(String name, Log log) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        if (this.argsNameKey == null) {
            if (this.choices != null) {
                if (!name.endsWith(":")) {
                    sb.append(" ");
                }
                String sep = "{";
                for (String choice : this.choices) {
                    sb.append(sep);
                    sb.append(choice);
                    sep = ",";
                }
                sb.append("}");
            }
        } else {
            if (!name.matches(".*[=:]$") && this.argKind != ArgKind.ADJACENT) {
                sb.append(" ");
            }
            sb.append(log.localize(Log.PrefixKind.JAVAC, this.argsNameKey, new Object[0]));
        }
        return sb.toString();
    }

    private static Set<String> getXLintChoices() {
        LinkedHashSet<String> choices = new LinkedHashSet<String>();
        choices.add(LINT_CUSTOM_ALL);
        Lint.LintCategory.options().stream().flatMap(ident -> Stream.of(ident, "-" + ident)).forEach(choices::add);
        choices.add(LINT_CUSTOM_NONE);
        return choices;
    }

    static Set<Option> getJavaCompilerOptions() {
        return EnumSet.allOf(Option.class);
    }

    public static Set<Option> getJavacFileManagerOptions() {
        return Option.getOptions(OptionGroup.FILEMANAGER);
    }

    public static Set<Option> getJavacToolOptions() {
        return Option.getOptions(OptionGroup.BASIC);
    }

    private static Set<Option> getOptions(OptionGroup group) {
        return Arrays.stream(Option.values()).filter(o -> o.group == group).collect(Collectors.toCollection(() -> EnumSet.noneOf(Option.class)));
    }

    public static enum OptionKind {
        STANDARD,
        EXTENDED,
        HIDDEN;

    }

    static enum OptionGroup {
        BASIC,
        FILEMANAGER,
        INFO,
        OPERAND;

    }

    public static enum ArgKind {
        NONE,
        REQUIRED,
        ADJACENT;

    }

    static enum ChoiceKind {
        ONEOF,
        ANYOF;

    }

    public static class InvalidValueException
    extends Exception {
        private static final long serialVersionUID = -1L;

        public InvalidValueException(String msg) {
            super(msg);
        }

        public InvalidValueException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static enum PkgInfo {
        ALWAYS,
        LEGACY,
        NONEMPTY;


        public static PkgInfo get(Options options) {
            String v = options.get(XPKGINFO);
            return v == null ? LEGACY : PkgInfo.valueOf(StringUtils.toUpperCase(v));
        }
    }

    static enum HiddenGroup {
        DIAGS("diags"),
        DEBUG("debug"),
        SHOULDSTOP("should-stop");

        final String text;

        private HiddenGroup(String text) {
            this.text = text;
        }

        public void process(OptionHelper helper, String option, String arg) throws InvalidValueException {
            String[] subOptions;
            for (String subOption : subOptions = arg.split(";")) {
                subOption = this.text + "." + subOption.trim();
                XD.process(helper, subOption, subOption);
            }
        }
    }
}

