/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.templates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateAttributes;
import org.netbeans.api.templates.CreateFromTemplateDecorator;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.api.templates.FileBuilder;
import org.netbeans.modules.templates.ScriptingCreateFromTemplateHandler;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.Parameters;

final class CreateFromTemplateImpl {
    private static final Logger LOG = Logger.getLogger(CreateFromTemplateImpl.class.getName());
    private static final String NEWLINE = "\n";
    private final FileBuilder builder;
    private final CreateDescriptor desc;
    private Map<String, ?> originalParams;
    private List<CreateFromTemplateDecorator> decorators;
    private CreateFromTemplateHandler handler;

    private CreateFromTemplateImpl(FileBuilder builder) {
        this.builder = builder;
        this.desc = builder.getDescriptor();
    }

    static List<FileObject> build(FileBuilder flb) throws IOException {
        CreateFromTemplateImpl impl = new CreateFromTemplateImpl(flb);
        AtomicReference fos = new AtomicReference();
        impl.desc.getTarget().getFileSystem().runAtomicAction(() -> fos.set(impl.build(impl.prepare())));
        return (List)fos.get();
    }

    static void collectAttributes(FileBuilder flb) {
        CreateFromTemplateImpl impl = new CreateFromTemplateImpl(flb);
        CreateFromTemplateImpl.computeEffectiveName(impl.desc);
        flb.withParameters(impl.findTemplateParameters());
    }

    private void setupDecorators() {
        this.decorators = new ArrayList<CreateFromTemplateDecorator>(Lookup.getDefault().lookupAll(CreateFromTemplateDecorator.class));
        Iterator<CreateFromTemplateDecorator> it = this.decorators.iterator();
        while (it.hasNext()) {
            CreateFromTemplateDecorator dec = it.next();
            if (dec.accept(this.desc)) continue;
            it.remove();
        }
    }

    List<FileObject> prepare() throws IOException {
        FileObject f = this.desc.getTemplate();
        FileObject folder = this.desc.getTarget();
        FileBuilder.Mode defaultMode = this.builder.defaultMode;
        Format frm = this.builder.format;
        Parameters.notNull((CharSequence)"f", (Object)f);
        Parameters.notNull((CharSequence)"folder", (Object)folder);
        assert (defaultMode != FileBuilder.Mode.FORMAT || frm != null) : "Format must be provided for Mode.FORMAT";
        if (!folder.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + folder);
        }
        this.findTemplateParameters();
        this.setupDecorators();
        CreateFromTemplateImpl.computeEffectiveName(this.desc);
        List<FileObject> initialFiles = this.callDecorators(true, new ArrayList<FileObject>());
        CreateFromTemplateImpl.computeEffectiveName(this.desc);
        this.handler = Stream.concat(this.desc.getLookup().lookupAll(CreateFromTemplateHandler.class).stream(), Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class).stream()).filter(h -> h.accept(this.desc)).findFirst().orElse((CreateFromTemplateHandler)f.getAttribute("template.createTemplateHandler"));
        return initialFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FileObject> build(List<FileObject> initialFiles) throws IOException {
        try {
            List<FileObject> pf = null;
            if (this.handler != null) {
                pf = this.handler.createFromTemplate(this.desc);
                assert (pf != null && !pf.isEmpty());
            }
            if (pf == null && this.builder.defaultMode != FileBuilder.Mode.FAIL) {
                pf = this.defaultCreate();
            }
            if (pf == null) {
                List<FileObject> list = pf;
                return list;
            }
            ArrayList<FileObject> result = new ArrayList<FileObject>(pf);
            result.addAll(initialFiles);
            this.callDecorators(false, result);
            ArrayList<FileObject> arrayList = result;
            return arrayList;
        }
        finally {
            this.builder.getDescriptor().parameters = this.originalParams;
        }
    }

    private List<FileObject> callDecorators(boolean preCreate, List<FileObject> result) throws IOException {
        for (CreateFromTemplateDecorator deco : this.decorators) {
            List<FileObject> preFiles;
            if (!(preCreate ? deco.isBeforeCreation() : deco.isAfterCreation()) || (preFiles = deco.decorate(this.desc, result)) == null) continue;
            preFiles.removeAll(result);
            result.addAll(preFiles);
        }
        return result;
    }

    static String interpolateName(ScriptEngine eng, String name, Map<String, ?> values, FileObject template) {
        if (eng == null) {
            return CreateFromTemplateHandler.mapParameters(name, values);
        }
        Bindings bind = eng.getContext().getBindings(100);
        bind.putAll((Map<? extends String, ? extends Object>)values);
        bind.put("name", (Object)name);
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            eng.getContext().setWriter(pw);
            eng.getContext().setAttribute(FileObject.class.getName() + ".owner", template, 100);
            eng.getContext().setAttribute("javax.script.filename", template.getNameExt(), 100);
            eng.eval(name);
            pw.flush();
            return sw.toString();
        }
        catch (ScriptException ex) {
            LOG.log(Level.SEVERE, "Errors encountered during interpolation of {0}", name);
            LOG.log(Level.SEVERE, "Cannot interpolate name", ex);
            return name;
        }
    }

    static void computeEffectiveName(CreateDescriptor desc) {
        String name = desc.getName();
        if (name == null) {
            boolean merge;
            Object o = desc.getParameters().get("name");
            ScriptEngine scriptEng = ScriptingCreateFromTemplateHandler.engine(desc.getTemplate());
            String n = o instanceof String ? o.toString() : desc.getTemplate().getName();
            name = CreateFromTemplateImpl.interpolateName(scriptEng, n, desc.getParameters(), desc.getTemplate());
            boolean bl = merge = Boolean.TRUE.equals(desc.getValue("template.mergeFolders")) || Boolean.TRUE.equals(desc.getTemplate().getAttribute("template.mergeFolders"));
            if (desc.getTemplate().isFolder() && merge) {
                desc.parameters.put("template.mergeFolders", Boolean.TRUE);
            } else {
                name = FileUtil.findFreeFileName((FileObject)desc.getTarget(), (String)name, (String)desc.getTemplate().getExt());
            }
        }
        desc.proposedName = name;
    }

    public Map<String, Object> findTemplateParameters() {
        HashMap<String, Object> all = new HashMap<String, Object>();
        all.putAll(this.desc.getParameters());
        this.originalParams = this.desc.parameters;
        this.desc.parameters = all;
        for (CreateFromTemplateAttributes provider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributes.class)) {
            Map<String, ?> map = provider.attributesFor(this.desc);
            if (map == null) continue;
            for (Map.Entry<String, ?> e : map.entrySet()) {
                if (this.originalParams != null && this.originalParams.containsKey(e.getKey())) continue;
                all.put(e.getKey(), e.getValue());
            }
        }
        String name = this.desc.getName();
        if (name == null) {
            name = this.desc.getProposedName();
        }
        if (!all.containsKey("name") && name != null) {
            String n = name;
            if (this.desc.hasFreeExtension()) {
                n = name.replaceFirst("[.].*", "");
            }
            all.put("name", n);
        }
        Date d = new Date();
        if (!all.containsKey("dateTime")) {
            all.put("dateTime", d);
        }
        String ext = this.desc.getTemplate().getExt();
        if (!all.containsKey("nameAndExt") && name != null) {
            if (!(ext == null || ext.length() <= 0 || this.originalParams == null || this.desc.hasFreeExtension() && name.indexOf(46) != -1)) {
                all.put("nameAndExt", name + "." + ext);
            } else {
                all.put("nameAndExt", name);
            }
        }
        return all;
    }

    private List<FileObject> defaultCreateFolder() throws IOException {
        String tn = this.desc.getProposedName();
        FileObject fo = FileUtil.createFolder((FileObject)this.desc.getTarget(), (String)tn);
        CreateFromTemplateHandler.copyAttributesFromTemplate(null, this.desc.getTemplate(), fo);
        return CreateFromTemplateHandler.defaultCopyContents(this.desc, this.desc.getTemplate(), fo);
    }

    private List<FileObject> defaultCreate() throws IOException {
        if (this.desc.getTemplate().isFolder()) {
            return this.defaultCreateFolder();
        }
        Map<String, Object> params = this.desc.getParameters();
        FileBuilder.Mode defaultMode = this.builder.defaultMode;
        Format frm = this.builder.format;
        if (defaultMode != FileBuilder.Mode.COPY && frm instanceof MapFormat) {
            MapFormat mf = (MapFormat)frm;
            Map m = mf.getMap();
            HashMap<String, Object> x = null;
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (m.containsKey(entry.getKey())) continue;
                if (x == null) {
                    x = new HashMap<String, Object>(m);
                }
                x.put(entry.getKey(), entry.getValue());
            }
            if (x != null) {
                mf.setMap(x);
            }
        }
        FileObject f = this.desc.getTemplate();
        String ext = this.desc.getTemplate().getExt();
        FileObject fo = this.desc.getTarget().createData(this.desc.getProposedName(), ext);
        boolean preformatted = false;
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)f);
        boolean success = false;
        FileLock lock = fo.lock();
        try (InputStream is = f.getInputStream();
             InputStreamReader reader2 = new InputStreamReader(is, encoding);
             BufferedReader r = new BufferedReader(reader2);){
            preformatted = this.desc.isPreformatted();
            encoding = FileEncodingQuery.getEncoding((FileObject)fo);
            ScriptEngine en = this.desc.isPreformatted() ? null : ScriptingCreateFromTemplateHandler.indentEngine();
            StringWriter sw = new StringWriter();
            try (OutputStream os = fo.getOutputStream(lock);
                 OutputStreamWriter w = new OutputStreamWriter(os, encoding);
                 Writer iw = preformatted || en == null ? w : sw;){
                String current;
                String line = null;
                while ((current = r.readLine()) != null) {
                    if (line != null) {
                        iw.append(NEWLINE);
                    }
                    line = frm != null ? frm.format(current) : current;
                    iw.append(line);
                }
                iw.append(NEWLINE);
                iw.flush();
                if (en != null) {
                    en.getContext().setAttribute("mimeType", f.getMIMEType(), 100);
                    en.getContext().setWriter(w);
                    en.eval(new StringReader(sw.toString()));
                }
            }
            CreateFromTemplateHandler.copyAttributesFromTemplate(null, f, fo);
            success = true;
        }
        catch (IOException ex) {
            try {
                fo.delete(lock);
            }
            catch (IOException reader2) {
                // empty catch block
            }
            throw ex;
        }
        catch (ScriptException ex) {
            IOException io = ex.getCause() instanceof IOException ? (IOException)ex.getCause() : null;
            try {
                fo.delete(lock);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw io == null ? new IOException(ex) : io;
        }
        finally {
            if (!success) {
                fo.delete(lock);
            }
            lock.releaseLock();
        }
        return Collections.singletonList(fo);
    }
}

