/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.ToStringPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ToStringGenerator
implements CodeGenerator {
    private static final String ERROR = "<error>";
    private final JTextComponent component;
    private final ElementNode.Description description;
    private final boolean useStringBuilder;
    private final boolean supportsStringBuilder;

    @CheckForNull
    static ToStringGenerator createToStringGenerator(JTextComponent component, CompilationController controller, TypeElement typeElement, boolean useStringBuilder) {
        ArrayList<ElementNode.Description> descriptions = new ArrayList<ElementNode.Description>();
        if (typeElement.getKind() == ElementKind.ENUM) {
            Element enumElement = controller.getTypes().asElement(typeElement.getSuperclass());
            for (Element element : ElementFilter.methodsIn(enumElement.getEnclosedElements())) {
                Name name = element.getSimpleName();
                if (name.contentEquals("ordinal")) {
                    descriptions.add(0, ElementNode.Description.create((CompilationInfo)controller, element, null, true, true));
                    continue;
                }
                if (!name.contentEquals("name")) continue;
                descriptions.add(ElementNode.Description.create((CompilationInfo)controller, element, null, true, true));
            }
        }
        for (Element element : typeElement.getEnclosedElements()) {
            switch (element.getKind()) {
                case METHOD: {
                    if (!element.getSimpleName().contentEquals("toString") || !((ExecutableElement)element).getParameters().isEmpty() || controller.getElementUtilities().isSynthetic(element)) break;
                    return null;
                }
                case FIELD: {
                    if (ERROR.contentEquals(element.getSimpleName()) || element.getModifiers().contains((Object)Modifier.STATIC)) break;
                    descriptions.add(ElementNode.Description.create((CompilationInfo)controller, element, null, true, true));
                    break;
                }
            }
        }
        return new ToStringGenerator(component, ElementNode.Description.create((CompilationInfo)controller, typeElement, descriptions, false, false), useStringBuilder, ToStringGenerator.supportsStringBuilder(controller));
    }

    private static boolean supportsStringBuilder(CompilationController controller) {
        return SourceVersion.RELEASE_5.compareTo(controller.getSourceVersion()) <= 0 && controller.getElements().getTypeElement("java.lang.StringBuilder") != null;
    }

    private ToStringGenerator(JTextComponent component, ElementNode.Description description, boolean useStringBuilder, boolean supportsStringBuilder) {
        this.component = component;
        this.description = description;
        this.useStringBuilder = useStringBuilder;
        this.supportsStringBuilder = supportsStringBuilder;
    }

    ElementNode.Description getDescription() {
        return this.description;
    }

    boolean useStringBuilder() {
        return this.useStringBuilder;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ToStringGenerator.class, (String)"LBL_tostring");
    }

    public void invoke() {
        final int caretOffset = this.component.getCaretPosition();
        final ToStringPanel panel = new ToStringPanel(this.description, this.useStringBuilder, this.supportsStringBuilder);
        DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(panel, NbBundle.getMessage(ToStringGenerator.class, (String)"LBL_generate_tostring"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != dialogDescriptor.getDefaultValue()) {
            return;
        }
        JavaSource js = JavaSource.forDocument((Document)this.component.getDocument());
        if (js != null) {
            try {
                ModificationResult mr = js.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element e = ToStringGenerator.this.description.getElementHandle().resolve((CompilationInfo)copy);
                        TreePath path = e != null ? copy.getTrees().getPath(e) : copy.getTreeUtilities().pathFor(caretOffset);
                        path = copy.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
                        if (path == null) {
                            String message = NbBundle.getMessage(ToStringGenerator.class, (String)"ERR_CannotFindOriginalClass");
                            Utilities.setStatusBoldText((JTextComponent)ToStringGenerator.this.component, (String)message);
                        } else {
                            ClassTree cls = (ClassTree)path.getLeaf();
                            ArrayList<Element> fields = new ArrayList<Element>();
                            for (ElementHandle<? extends Element> elementHandle : panel.getVariables()) {
                                Element field = elementHandle.resolve((CompilationInfo)copy);
                                if (field == null) {
                                    return;
                                }
                                fields.add(field);
                            }
                            MethodTree mth = ToStringGenerator.createToStringMethod(copy, fields, cls.getSimpleName().toString(), panel.useStringBuilder());
                            copy.rewrite((Tree)cls, (Tree)GeneratorUtils.insertClassMembers(copy, cls, Collections.singletonList(mth), caretOffset));
                        }
                    }
                });
                GeneratorUtils.guardedCommit(this.component, mr);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static MethodTree createToStringMethod(WorkingCopy wc, Iterable<? extends Element> fields, String typeName, boolean useStringBuilder) {
        TypeElement override;
        TreeMaker make = wc.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        LinkedList<AnnotationTree> annotations = new LinkedList<AnnotationTree>();
        if (GeneratorUtils.supportsOverride((CompilationInfo)wc) && (override = wc.getElements().getTypeElement("java.lang.Override")) != null) {
            annotations.add(wc.getTreeMaker().Annotation((Tree)wc.getTreeMaker().QualIdent((Element)override), Collections.emptyList()));
        }
        ModifiersTree modifiers = make.Modifiers(mods, annotations);
        BlockTree body = ToStringGenerator.createToStringMethodBody(make, typeName, fields, useStringBuilder);
        return make.Method(modifiers, (CharSequence)"toString", (Tree)make.Identifier((CharSequence)"String"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    private static BlockTree createToStringMethodBody(TreeMaker make, String typeName, Iterable<? extends Element> fields, boolean useStringBuilder) {
        List<StatementTree> statements = useStringBuilder ? ToStringGenerator.createToStringMethodBodyWithStringBuilder(make, typeName, fields) : ToStringGenerator.createToStringMethodBodyWithPlusOperator(make, typeName, fields);
        BlockTree body = make.Block(statements, false);
        return body;
    }

    private static List<StatementTree> createToStringMethodBodyWithPlusOperator(TreeMaker make, String typeName, Iterable<? extends Element> fields) {
        ExpressionTree exp = make.Literal((Object)(typeName + "{"));
        boolean first = true;
        for (Element element : fields) {
            StringBuilder sb = new StringBuilder();
            if (!first) {
                sb.append(", ");
            }
            sb.append(element.getSimpleName().toString()).append('=');
            exp = make.Binary(Tree.Kind.PLUS, exp, (ExpressionTree)make.Literal((Object)sb.toString()));
            exp = make.Binary(Tree.Kind.PLUS, exp, ToStringGenerator.makeExpression(make, element));
            first = false;
        }
        ReturnTree stat = make.Return((ExpressionTree)make.Binary(Tree.Kind.PLUS, exp, (ExpressionTree)make.Literal((Object)Character.valueOf('}'))));
        return Collections.singletonList(stat);
    }

    private static List<StatementTree> createToStringMethodBodyWithStringBuilder(TreeMaker make, String typeName, Iterable<? extends Element> fields) {
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        ExpressionTree stringBuilder = make.QualIdent(StringBuilder.class.getName());
        NewClassTree newStringBuilder = make.NewClass(null, Collections.emptyList(), stringBuilder, Collections.emptyList(), null);
        VariableTree variable = make.Variable(make.Modifiers(Collections.emptySet()), (CharSequence)"sb", (Tree)stringBuilder, (ExpressionTree)newStringBuilder);
        statements.add(variable);
        IdentifierTree varName = make.Identifier((CharSequence)variable.getName());
        statements.add(make.ExpressionStatement((ExpressionTree)ToStringGenerator.createAppendInvocation(make, varName, Collections.singletonList(make.Literal((Object)(typeName + "{"))))));
        boolean first = true;
        for (Element element : fields) {
            StringBuilder sb = new StringBuilder();
            if (!first) {
                sb.append(", ");
            }
            sb.append(element.getSimpleName().toString()).append('=');
            statements.add(make.ExpressionStatement((ExpressionTree)ToStringGenerator.createAppendInvocation(make, ToStringGenerator.createAppendInvocation(make, varName, Collections.singletonList(make.Literal((Object)sb.toString()))), Collections.singletonList(ToStringGenerator.makeExpression(make, element)))));
            first = false;
        }
        statements.add(make.ExpressionStatement((ExpressionTree)ToStringGenerator.createAppendInvocation(make, varName, Collections.singletonList(make.Literal((Object)Character.valueOf('}'))))));
        statements.add(make.Return((ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)varName, (CharSequence)"toString"), Collections.emptyList())));
        return statements;
    }

    private static MethodInvocationTree createAppendInvocation(TreeMaker make, ExpressionTree expression, List<? extends ExpressionTree> arguments) {
        return make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(expression, (CharSequence)"append"), arguments);
    }

    private static ExpressionTree makeExpression(TreeMaker make, Element element) {
        return element.getKind() == ElementKind.METHOD ? make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)element.getSimpleName()), Collections.emptyList()) : make.Identifier((CharSequence)element.getSimpleName());
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<ToStringGenerator> ret = new ArrayList<ToStringGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            if (component == null || controller == null) {
                return ret;
            }
            TreePath path = (TreePath)context.lookup(TreePath.class);
            TreePath treePath = path = path != null ? controller.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path) : null;
            if (path == null) {
                return ret;
            }
            try {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException ioe) {
                return ret;
            }
            TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
            if (typeElement == null || !typeElement.getKind().isClass()) {
                return ret;
            }
            ToStringGenerator generator = ToStringGenerator.createToStringGenerator(component, controller, typeElement, false);
            if (generator == null) {
                return ret;
            }
            ret.add(generator);
            return ret;
        }
    }
}

