/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.AbstractTableColumn;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.openide.util.NbBundle;

public class ColumnListCommand
extends AbstractCommand {
    private Vector columns = new Vector();
    static final long serialVersionUID = 3646663278680222131L;

    public Vector getColumns() {
        return this.columns;
    }

    public TableColumn specifyColumn(String type, String name, String cmd, boolean newObject, boolean newColumn) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Map typemap;
        Map gprops = this.getSpecification().getProperties();
        Map props = this.getSpecification().getCommandProperties(cmd);
        Map bindmap = (Map)props.get("Binding");
        String tname = (String)bindmap.get(type);
        if (tname != null) {
            typemap = (Map)gprops.get(tname);
            if (typemap == null) {
                throw new InstantiationException(MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_UnableLocateType"), tname, props.keySet().toString()));
            }
        } else {
            throw new InstantiationException(MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_UnableToBind"), type, bindmap.toString()));
        }
        Class<?> typeclass = Class.forName((String)typemap.get("Class"));
        String format = (String)typemap.get("Format");
        TableColumn column = (TableColumn)typeclass.newInstance();
        column.setObjectName(name);
        column.setObjectType(type);
        column.setColumnName(name);
        column.setFormat(format);
        column.setNewObject(newObject);
        column.setNewColumn(newColumn);
        this.columns.add(column);
        return column;
    }

    @Override
    public Map getCommandProperties() throws DDLException {
        Map props = this.getSpecification().getProperties();
        String cols = (String)props.get("ColumnListHeader");
        String coldelim = (String)props.get("ColumnListDelimiter");
        Map args = super.getCommandProperties();
        Enumeration col_e = this.columns.elements();
        while (col_e.hasMoreElements()) {
            AbstractTableColumn col = (AbstractTableColumn)col_e.nextElement();
            boolean inscomma = col_e.hasMoreElements();
            cols = cols + col.getCommand(this) + (inscomma ? coldelim : "");
        }
        args.put("columns", cols);
        return args;
    }

    @Override
    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readObject(in);
        this.columns = (Vector)in.readObject();
    }

    @Override
    public void writeObject(ObjectOutputStream out) throws IOException {
        super.writeObject(out);
        out.writeObject(this.columns);
    }
}

